<?php
if (! can_action('admin'))
	redirect();

require_once(LIB.'BlockTable.class.php');
$blockObj = new BlockTable();

$page = 1;
if (! empty($_GET['p']))
	$page = (int)$_GET['p'];
$show_count = 20;
$offset = ($page-1) * $show_count;

$rules = $blockObj->get($offset.','.$show_count);
$cnt = $blockObj->count();

$title = 'Block Table';
$css_links = array('admin.css');
$script = <<<EOD
function del_rule(id, name) {
	if (! confirm("本当にルール「" + name+"」(No"+id+")を削除してよろしいですか？\\n※この操作は取り消し出来ません。"))
		return;

	location.href = T.base+"del_block/"+id;
}
function autodelete_rule() {
	if (! confirm("期限切れのルールを自動的にすべて削除します。本当によろしいですか？\\n※この操作は取り消し出来ません。"))
		return;

	location.href = T.base+"block_autodelete";
}
EOD;
include LAYOUTS.'header.inc.php';

$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box">
			<a href="<?php echo BASE_URL;?>edit_block">新しいルールを作成</a>
		</div>
		<div class="controller-box">
			<table id="log-table"><tbody>
				<tr>
					<th>No</th>
					<th>識別名</th>
					<th>効果</th>
					<th>対象</th>
					<th>行動</th>
					<th>IP</th>
					<th>ID</th>
					<th>ユーザID</th>
					<th>対象ID</th>
					<th>対象詳細</th>
					<th>詳細</th>
					<th>開始</th>
					<th>終了</th>
					<th>作成</th>
					<th>更新</th>
					<th>Action</th>
				</tr>
<?php
if (! empty($rules)) {
	foreach ($rules as $k => $l) {
		echo '<tr>';
		echo '<td><a href="'.BASE_URL.'edit_block/'.$l['rule_id'].'">'.h($l['rule_id']).'</a></td>';
		echo '<td>'.h($l['name']).'</td>';
		echo '<td>'.h($l['block']).'</td>';
		echo '<td>'.h($l['target']).'</td>';
		echo '<td>'.h($l['action']).'</td>';
		echo '<td>'.h($l['ip']).'</td>';
		echo '<td>'.h($l['id']).'</td>';
		echo '<td>'.h($l['user_id']).'</td>';
		echo '<td>'.h($l['target_id']).'</td>';
		echo '<td>'.h($l['target_key']).'</td>';
		echo '<td>'.h($l['detail']).'</td>';
		echo '<td>'.h($l['rule_start']).'</td>';
		echo '<td>'.h($l['rule_end']).'</td>';
		echo '<td>'.h($l['created']).'</td>';
		echo '<td>'.h($l['modified']).'</td>';
		echo '<td><a href="javascript:del_rule('.$l['rule_id'].', \''.str_replace("'","\\'", $l['name']).'\')">削除</a></td>';
		echo '</tr>';
	}
}
?>
			</tbody></table>
<?php
if (empty($rules)) {
			echo '<div>ルールが見つかりません。</div>';
} else {
		print_paging_q(BASE_URL.'block/', $page, $show_count, $cnt);
}
?>
		</div>

		<div class="controller-box">
			<a href="<?php echo BASE_URL;?>block_autodelete">期限切れのルールをすべて削除する</a>
		</div>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>