<?php
require_once(LIB.'Box.class.php');
if (! can_action('admin'))
	redirect();

$box = new Box();
$boxes = $box->listBoxes();

$title = 'ボックス管理';
$script = 'var boxes = [];';
foreach ($boxes as $b) {
	$script .= "\nboxes.push(\"".h($b)."\");";
}
$script .= <<<EOD
$(function() {
	$.each(boxes, function() {
		$("<option/>").text(this).appendTo($("#box_list"));
	});
	$("#box_list").change(function(e) {
		if (! $(this).val()) {
			$("#box-content").val("");
			$("#box-description").val("");
			return;
		}
		$("<div id='l'/>").insertAfter("#box_list").spin();
		$.get2(
			T.api+"read_box.php",
			{name: $(this).val()},
			function(ret) {
				$("#l").remove();
				$("#box-content").val(ret.script);
				$("#box-name").val(ret.filename);
				$("#box-description").val(ret.description);
				if (ret.error) {
					$("#error-box").html(
						"ファイルと相違あり<div><textarea id='error-content'></textarea>"
					);
					$("#error-content").val(ret.error);
				} else {
					$("#error-box").html("");
				}
			},
			function() {
				$("#l").remove();
				alert("エラー");
			},
			"json"
		);
	});
	$(".hresizable").resizable({});
});
function del() {
	var param = {}
	param.old_name = $("#box_list").val();
	if (! param.old_name) {
		alert("対象を選択してください。");
		return;
	}
	if (! confirm("本当に"+param.old_name+"を削除しますか？\\n※実行後、元に戻せません。")) {
		return;
	}
	$(".button").attr("disabled", "disabled");
	$.post2(
		T.api+"del_box.php",
		param,
		function(ret) {
			if (! ret) {
				alert("削除に失敗しました。\\n※ページで使われているボックスは削除できません。設定を確認してください。")
				$(".button").removeAttr("disabled");
				$("#l").remove();
				return;
			}
			location.reload();
		},
		function() {
			alert("削除に失敗しました。\\n※ページで使われているボックスは削除できません。設定を確認してください。");
			$("#l").remove();
			$(".button").removeAttr("disabled");
		},
		"json"
	);
}
function save() {
	var param = {}
	param.old_name = $("#box_list").val();
	param.name = $("#box-name").val();
	param.description = $("#box-description").val();
	param.script = $("#box-content").val();
	if (param.old_name) {
		if (param.old_name != param.name) {
			if (! confirm(param.old_name+"を"+param.name+"として登録しなおします。\\nよろしいですか？\\n※実行後、元に戻せません。")) {
				return;
			}
		} else {
			if (! confirm(param.old_name+"を上記の内容で修正します。\\nよろしいですか？\\n※実行後、元に戻せません。")) {
				return;
			}
		}
	} else {
		if (! confirm(param.name+"を新しく作成します。\\nよろしいですか？")) {
			return;
		}
	}
	$("<div id='l'/>").insertAfter("#box_list").spin();
	$(".button").attr("disabled", "disabled");
	$.post2(
		T.api+"save_box.php",
		param,
		function(ret) {
			if (! ret) {
				alert("保存に失敗しました。")
				$(".button").removeAttr("disabled");
				$("#l").remove();
				return;
			}
			location.reload();
		},
		function() {
			alert("保存に失敗しました。");
			$("#l").remove();
			$(".button").removeAttr("disabled");
		},
		"json"
	);
}
EOD;
$css_links = array('admin.css');
include LAYOUTS.'header.inc.php';
$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget hresizable">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box">
			<h2>ボックス一覧</h2>
			<select id="box_list">
				<option></option>
			</select>
		</div>
	
		<div class="controller-box">
			<h2>ボックス名</h2>
			<div>
				<input type="text" id="box-name" value="" />
			</div>
		</div>

		<div class="controller-box">
			<h2>ボックス説明</h2>
			<div>
				<textarea id="box-description"></textarea>
			</div>
		</div>

		<div class="controller-box">
			<h2>ボックスコンテンツ</h2>
			<div>
				<textarea id="box-content" class="hresizable"></textarea>
			</div>
		</div>

		<div id="error-box"></div>

		<div class="controller-box">
			<div>
				<input id="save-button" type="button" onclick="save()" value="保存" class="button" />
				<input id="del-button" type="button" onclick="del()" value="削除" class="button" />
			</div>
		</div>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>