<?php
if (! can_action('admin'))
	redirect();

require_once(LIB.'BlockTable.class.php');
$blockObj = new BlockTable();

$id = @$params[0];

if (! empty($_POST['save'])) {
	if (empty($id)) {
		$ret = $blockObj->create($_POST);
	} else {
		$ret = $blockObj->modify($id, $_POST);
	}
	if ($ret === FALSE) {
		$message = (empty($id) ? '作成' : '更新').'に失敗しました。';
	} else {
		$blockObj->updateCache();
		redirect('block');
	}
}

if (empty($id)) {
	$block = array();
	$cnt = $blockObj->count();
	$block['name'] = 'ルール'.($cnt+1);
	$block['block'] = 'block';
} else {
	$block = $blockObj->read($id);
}

$title = ($id ? 'Modify ' : 'Create ').'Block Table';
$css_links = array('admin.css');
$script = <<<EOD
	$(function() {
	});
EOD;
include LAYOUTS.'header.inc.php';

$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<form method="post" action="<?php echo BASE_URL;?>edit_block/<?php echo $id;?>">
		<div class="controller-box">
			<table id="edit-block-table"><tbody>
				<tr>
					<th>No</th>
					<td><?php echo empty($block['rule_id']) ? '(自動)' : $block['rule_id'];?></td>
					<td></td>
				</tr>
				<tr>
					<th>識別名</th>
					<td><input type="text" name="name" value="<?php echo h(@$block['name']);?>" /></td>
					<td>任意の名前を指定してください。</td>
				</tr>
				<tr>
					<th>効果</th>
					<td><input type="text" name="block" value="<?php echo h(@$block['block']);?>" /></td>
					<td>現在は"block"のみ効果があります</td>
				</tr>
				<tr>
					<th>対象</th>
					<td><input type="text" name="target" value="<?php echo h(@$block['target']);?>" /></td>
					<td>正規表現で指定してください</td>
				</tr>
				<tr>
					<th>行動</th>
					<td><input type="text" name="action" value="<?php echo h(@$block['action']);?>" /></td>
					<td>正規表現で指定してください</td>
				</tr>
				<tr>
					<th>IP</th>
					<td><input type="text" name="ip" value="<?php echo h(@$block['ip']);?>" /></td>
					<td>正規表現で指定してください</td>
				</tr>
				<tr>
					<th>ID</th>
					<td><input type="text" name="id" value="<?php echo h(@$block['id']);?>" /></td>
					<td>正規表現で指定してください</td>
				</tr>
				<tr>
					<th>ユーザID</th>
					<td><input type="text" name="user_id" value="<?php echo h(@$block['user_id']);?>" /></td>
					<td>数値式で指定してください</td>
				</tr>
				<tr>
					<th>対象ID</th>
					<td><input type="text" name="target_id" value="<?php echo h(@$block['target_id']);?>" /></td>
					<td>数値式で指定してください</td>
				</tr>
				<tr>
					<th>詳細</th>
					<td><input type="text" name="detail" value="<?php echo h(@$block['detail']);?>" /></td>
					<td>正規表現で指定してください</td>
				</tr>
				<tr>
					<th>開始</th>
					<td><input type="text" name="rule_start" value="<?php echo h(@$block['rule_start']);?>" /></td>
					<td>YYYY-MM-DD HH:MM:SS形式して指定してください</td>
				</tr>
				<tr>
					<th>終了</th>
					<td><input type="text" name="rule_end" value="<?php echo h(@$block['rule_end']);?>" /></td>
					<td>YYYY-MM-DD HH:MM:SS形式して指定してください</td>
				</tr>
				<tr>
					<th>作成日</th>
					<td><?php echo empty($block['created']) ? '(自動)' : $block['created'];?></td>
					<td></td>
				</tr>
				<tr>
					<th>更新日</th>
					<td><?php echo empty($block['modified']) ? '(自動)' : $block['modified'];?></td>
					<td></td>
				</tr>
			</tbody></table>
		</div>

		<div class="controller-box">
			<input type="submit" value="保存" class="button" name="save" />
			<input type="button" class="button" onclick="location.href='<?php echo BASE_URL;?>block'" class="button" value="戻る" />
		</div>

		<div class="controller-box">
			数値式では、以下の記述が使えます。<br />
			<table><tbody>
				<tr>
					<td>等式:</td>
					<td>100</td>
					<td>100の値が該当します</td>
				</tr>
				<tr>
					<td>不等式:</td>
					<td>!100</td>
					<td>100以外の値が該当します</td>
				</tr>
				<tr>
					<td>小なり:</td>
					<td>&lt;100</td>
					<td>100未満の値が該当します</td>
				</tr>
				<tr>
					<td>大なり:</td>
					<td>&gt;100</td>
					<td>100より大きい値が該当します</td>
				</tr>
				<tr>
					<td>範囲式:</td>
					<td>50:100</td>
					<td>50～100の値が該当します</td>
				</tr>
			</tbody></table>
		</div>
		</form>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>