<?php
$id = @$params[0];
if ($id) {
	if (! can_action('edit_theme'))
		redirect();
} else {
	if (! can_action('create_theme'))
		redirect();
}

$theme = NULL;
if (! empty($id)) {
	require_once(LIB.'Post.class.php');
	$post = new Post();
	$theme = $post->readTheme($id);
	if (empty($theme))
		redirect();
}
$script = <<<EOD
$(function() {
	$("input[type='button'], input[type='submit'], .button, .tag a").button();
	$("#keyword").keydown(function(e) {
		if (e.keyCode == 13) {
			var err = add_keyword($("#keyword").val(), true);
			if (err != true)
				setTimeout(function() { alert(err) }, 0);
			return false;
		}
	});
	$("[title]").tooltip();
});
function save() {
	var keywords = $(".tag a");
	for (var i=0; i<keywords.length; i++)
		$("#key"+(i+1)).val($(keywords[i]).text());

	var test = $("#theme_name").val();
	test = T.trim(test);
	if (test.trim().length < 2) {
		alert("テーマ名を2文字以上で入力してください");
		$("#theme_name").focus();
		return false;
	}

	var p = {
		"key1" : $("#key1").val(),
		"key2" : $("#key2").val(),
		"key3" : $("#key3").val(),
		"name" : $("#theme_name").val(),
		"description" : $("#theme_description").val()
	}
	if ($("#id").length)
		p.id = $("#id").val();
	$("<div id='l'/>").insertBefore(".final-action").spin();
	$(".button").attr("disabled", "disabled");
	$.post2(
		T.api+'save_theme.php',
		p,
		function(ret) {
			if (! ret) {
				alert("保存に失敗しました");
				$(".button").removeAttr("disabled");
				$("#l").remove();
				return;
			}
			location.href = T.base+"theme/"+encodeURIComponent($("#theme_name").val());
		},
		function() {
			alert("保存に失敗しました");
			$(".button").removeAttr("disabled");
			$("#l").remove();
		},
		"json"
	);


	return false;
}
function add_keyword(value, err) {
	try {
		var keywords = $(".tag a");
		if (keywords.length > 2) {
			throw "キーワードは最大3つまで登録出来ます。どれかキーワードを削除してから再度追加作業を行ってください。";
		}

		value = T.trim(value);
		if (value.length < 2) {
			$("#keyword").focus();
			throw "キーワード名を2文字以上で入力してください";
		}

		for (var i=0; i<keywords.length; i++) {
			if ($(keywords[i]).text() == value) {
				$("#keyword").focus();
				throw "同一キーワードが既に登録されています。";
			}
		}

		var new_keyword = $("<a/>");
		new_keyword.attr("href", "javascript:del_keyword("+keywords.length+")");
		new_keyword.text(value);
		$(".tag").append(new_keyword);
		$(".tag a").button();

		$("#keyword").focus();

	} catch (ex) {
		if (err)
			return ex;
		alert(ex);
		return false;
	}
	return true;
}
function del_keyword(index) {
	var keywords = $(".tag a");
	for (var i=index+1; i<keywords.length; i++)
		$(keywords[i]).attr("href", "javascript:del_keyword("+(i-1)+")");

	$($(".tag a")[index]).remove();
	$("#keyword").focus();
}
EOD;
if ($theme) {
	$keys = array();
	if ($theme['key1'])
		$keys[] = $theme['key1'];
	if ($theme['key2'])
		$keys[] = $theme['key2'];
	if ($theme['key3'])
		$keys[] = $theme['key3'];
	
	$script .= '$(function() {
';
	foreach ($keys as $k) {
		$script .= '	add_keyword("'.h($k).'");
';
	}
	$script .='
})';
}
$css_links = array('theme.css');
$title = $theme ? 'テーマの編集' : 'テーマの作成';
include LAYOUTS.'header.inc.php';
$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>

<div id="content-container" class="container ui-widget">
	<div class="ui-widget-content ui-corner-all">
		<form onsubmit="return save()" id="theme" name="theme" method="post" action="<?php echo API_URL.'save_theme.php';?>">
			<input type="hidden" id="key1" name="key1" />
			<input type="hidden" id="key2" name="key2" />
			<input type="hidden" id="key3" name="key3" />
<?php
if ($id) {
?>
			<input type="hidden" id="id" name="id" value="<?php echo h($id);?>" />
<?php
}
?>
			<div>
				<div>
					<label>テーマ名</label>
				</div>
				<div>
					<input type="text" name="name" id="theme_name" value="<?php echo $theme ? h($theme['name']) : '';?>" class="ui-corner-all" />
				</div>
			</div>
			<div>
				<div>
					<label>解説</label>
				</div>
				<div>
					<textarea name="description" id="theme_description" class="ui-corner-all"><?php echo $theme ? h($theme['description']) : '';?></textarea>
				</div>
			</div>
			<div>
				<div>
					<label>キーワード</label>
				</div>
				<div>
					<input type="text" name="keyword" id="keyword" value="" class="ui-corner-all" />
					<input type="button" value="追加" onclick="add_keyword($('#keyword').val())" />
				</div>
				<div class="tag">
				</div>
				<div class="tag-info">
					<p style="display:none">キー1は○○、××のテーマでも利用されています。</p>
				</div>
			</div>
			<div class="final-action">
				<input type="submit" class="button" value="保存" />
				<input type="button" class="button" value="中止" onclick="location.href=T.base" />
			</div>
		</form>

		<div class="help">
			<p>キーワードは0～3つまで設定出来ます。</p>
			<p>設定されたキーワードを含む書き込みは、自動的に本テーマに関連付けられます。</p>
			<p>キーワードが設定されていないテーマは、自動反映が行われない掲示板のような扱いになります。</p>
			<p>キーワードは2文字以上、16文字以下で設定してください。</p>
			<p>/</p>
		</div>
	</div>
</div>

<?php
include LAYOUTS.'footer.inc.php';
?>