<?php
require_once(LIB.'Post.class.php');
$post = new Post();

$themes = $post->getThemeCloud(30, TRUE);

$title = '話題のテーマ';
$box = get_show_boxes(__FILE__);
$css_links = array('url.css');
$script = <<<EOD
	$(function() {
		T.initRead(true);
	});
EOD;
include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
<?php
if (! empty($themes)) {
	echo '<ul class="url-list">';
	foreach ($themes as $k => $v) {
		echo '<li>';
		echo '<a href="'.BASE_URL.'theme/'.rawurlencode($v['t_theme']).'" class="name url-title">'.h($v['t_theme']).'</a><br/>';
		echo h(mb_truncate($v['description'], 48)).'<br/>';
		echo '勢い: '.$v['rcnt'].', 言及数: '.$v['cnt'];
		echo '</li>';
	}
	echo '</ul>';
	echo '<div class="controller-box"><a href="'.BASE_URL.'theme_cloud">テーマクラウドで見る</a></div>';
} else {
	echo '<div style="margin:1em">現在特にテーマは話題になっていないようです。</div>';
}
?>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>