<?php
require_once(LIB.'Post.class.php');

if (! can_action('operation'))
	redirect();

require_once(LIB.'TImage.class.php');

$imgManager = new TImage();
$dirs = $imgManager->listDir();
function recursive_print($dirs, $p) {
	echo '<ul>';
	foreach ($dirs as $name => $d) {
		echo '<li>';
		echo '<a href="javascript:list_image(\''.(empty($p) ? $name : ($p.'/'.$name)).'\')">'.h($name).'</a>';
		if (count($d))
			recursive_print($d, (empty($p) ? $name : ($p.'/'.$name)));
		echo '</li>';
	}
	echo '</ul>';
}

$title = '画像管理';
$css = '
	ul {
		margin:0;
		padding-left:1.5ex;
	}
	.img {
		float:left;
		margin-right:1ex;
		text-align:center;
	}
	.img img {
		max-width:200px;
		max-height:200px;
	}
';
$img_url = h(IMG_URL);
$script = <<<EOD
	var before_path = null;
	$(function() {
		T.initRead(true);
	});
	function del_image(d, del_post) {
		if (del_post) {
			if (! confirm("この画像を書き込みごと削除します。\\n本当によろしいですか？\\n※この操作は取り消せません")) {
				return;
			}
		} else {
			if (! confirm("この画像を削除します。この画像のURLをクリックすると、エラーページに遷移するようになります。\\n本当によろしいですか？\\n※この操作は取り消せません")) {
				return
			}
		}
		var param = {d: d}
		if (del_post) {
			param.with_post = true;
		}
		$("<div class='loading_image_icon' />").appendTo($("#thumbnails")).spin();
		$.post2(
			T.api+"del_image.php",
			param,
			function(ret) {
				if (! ret) {
					$(".loading_image_icon").remove();
					alert("削除に失敗しました。");
					return;
				}
				list_image(before_path, true);
				alert("削除しました。");
			},
			function() {
					$(".loading_image_icon").remove();
				alert("削除に失敗しました。");
			},
			"json"
		);
	}
	function list_image(d, no_add) {
		before_path = d;
		$("#thumbnails").html("");
		if (! no_add)
			$("<div class='loading_image_icon' />").appendTo($("#thumbnails")).spin();
		$.get2(
			T.api+'get_images.php?d='+d,
			function(ret) {
				if ((!ret) || (ret.length == 0)) {
					$(".loading_image_icon").remove();
					$("#thumbnails").html("画像がありません。");
					return;
				}
				var imgs = [];
				for (var i=0; i<ret.length; i++) {
					var img_url = "{$img_url}"+d+"/"+ret[i];
					imgs.push(
						"<a href=\"javascript:T.preview('"+img_url+"', true)\"><img src=\""+img_url+"\" /><br/>"
						+ ''+ret[i]+"</a><br/>"
						+ "<a href=\"javascript:del_image('"+d+"/"+ret[i]+"')\")>削除</a><br/>"
						//+ "<a href=\"javascript:del_image('"+d+"/"+ret[i]+"', true)\">書き込みごと削除</a>"
					);
				}
				$("#thumbnails").html(
					'<div class="img">'+imgs.join('</div><div class="img">')+"</div>"
					+ '<div class="c"></div>'
				);
			},
			function() {
				$(".loading_image_icon").remove();
				alert("データ取得に失敗しました。");
			},
			"json"
		);
	}
EOD;

include LAYOUTS.'header.inc.php';
?>
<div id="control-box" class="box controller ui-widget-content ui-corner-all">
	<div class="box controller" style="font-size:80%; padding-left:1ex; url-space">
		<ul>
			<li><a href="javascript:list_image('')"><?php echo h(IMG); ?></a>
<?php
	recursive_print($dirs, '');
?>
			</li>
		</ul>
	</div>
</div>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div id="thumbnails" class="controller-box">
		</div>
	</div>
</div>
<div id="preview-dialog"></div>
<?php
include LAYOUTS.'footer.inc.php';
?>