<?php
if (! can_action('admin'))
	redirect();

$css = <<<EOD
select {
	width:200px !important;
	color:black !important;
	background-color:white !important;
}
EOD;
$script = <<<EOD
function start_load() {
	var s = $("#load_url").val();
	if (! s) {
		alert("読込先BULLETのURLを入力してください。");
		$("#load_val").focus();
		return;
	}
	if (s.substr(-1) != "/")
		s += "/";

	$("#load_val").attr("href", "javascript:loading_alert()");
	$("#remote-loader").effect("fade", {mode:"show"});

	var t = $("#import-theme");
	var k = $("#import-keyword");
	t.html("");
	k.html("");
	window.loading++;
	$("<div id='l'/>").appendTo($("#remote-loader")).spin();
	$.get2(
		s + "api/get_active_keyword.php",
		{limit:"none"},
		function(ret) {
			for (var i=0; i<ret.length; i++) {
				if (! window.keywords[ret[i].keyword])
					$("<option selected/>").text(ret[i].keyword).appendTo(k);
			}
			$.get2(
				s + "api/get_recent_theme.php",
				{limit:"none"},
				function(ret) {
					for (var i=0; i<ret.length; i++) {
						if (! window.themes[ret[i].name])
							$("<option selected/>").attr("k1", ret[i].key1).attr("k2", ret[i].key2).attr("k3", ret[i].key3).attr("d", ret[i].description).text(ret[i].name).appendTo(t);
					}
					//$("#l").remove();
					alert("読み込みに成功しました。インポート作業に進んでください。");
					recover();
					$("#remote-url").effect("fade", {mode:"hide"});
					$("#import-container").effect("fade", {mode:"show"});
				},
				function() {
					alert("読み込みに失敗しました。");
					recover();
				},
				"json"
			);
		},
		function() {
			alert("読み込みに失敗しました。");
			recover();
		},
		"json"
	);
}

function import_theme(themes, index) {
	if (themes.length == index) {
		alert("インポート処理が終了しました。\\n特にインポート処理を続行する必要が無ければ、別ページに移動してください。");
		$("#import-button").attr("href", "javascript:start_import()");
		$("#import-status").html("<div aling='center'><div><a href='"+T.base+"'>TOPへ</a></div><div><a href='"+T.base+"active_keywords'>最近言及されたキーワードへ</a></div><div><a href='"+T.base+"recent_themes'>新しいテーマへ</a></div></div>");
		$("#l").remove();
		return;
	}
	$("#import-cnt").text(index+1);
	var t = $(themes[index]);
	$.post2(
		T.api+"save_theme.php",
		{
			name: t.val(),
			description: t.attr("d"),
			key1: t.attr("k1"),
			key2: t.attr("k2"),
			key3: t.attr("k3")
		},
		function(ret) {
			$(themes[index]).remove();
			import_theme(themes, ++index, themes);
		},
		function() {
			$("#import-ng-theme").append($(themes[index]).clone());
			$(themes[index]).remove();
			import_keyword(themes, ++index, themes);
		},
		"json"
	);
}

function import_keyword(keywords, index, themes) {
	if (keywords.length == index) {
		$("#import-status").html("テーマ登録中...<span id=\"import-cnt\">0</span>/<span id=\"import-max\">"+themes.length+"</span>");
		import_theme(themes, 0);
		return;
	}
	$("#import-cnt").text(index+1);
	$.post2(
		T.api+"save_keyword.php",
		{keyword: $(keywords[index]).val()},
		function(ret) {
			$(keywords[index]).remove();
			import_keyword(keywords, ++index, themes);
		},
		function() {
			$("#import-ng-keyword").append($(keywords[index]).clone());
			$(keywords[index]).remove();
			import_keyword(keywords, ++index, themes);
		},
		"json"
	);
}
function start_import() {
	var keywords = $("#import-keyword option:selected");
	var themes = $("#import-theme option:selected");
	$("#import-button").attr("href", "javascript:loading_alert()");
	$("#import-status").html("キーワード登録中...<span id=\"import-cnt\">0</span>/<span id=\"import-max\">"+keywords.length+"</span>");
	$("<div id='l'/>").insertAfter($("#import-status")).spin();

	import_keyword(keywords, 0, themes);
}
function add_keyword() {
	move("import-ng-keyword", "import-keyword");
}
function del_keyword() {
	move("import-keyword", "import-ng-keyword");
}
function add_theme() {
	move("import-ng-theme", "import-theme");
}
function del_theme() {
	move("import-theme", "import-ng-theme");
}
function move(_this, target) {
	$("select#" + _this + " option:selected").each(function() {
		$("select#" + target).append($(this).clone());
		$(this).remove();
	});
}
function recover() {
	$("#l").remove();
	$("#load_val").attr("href", "javascript:start_load()");
	$("#remote-loader").stop(true, true).effect("fade", {mode:"hide"});
	window.loading--;
}
function loading_alert() {
	alert("読み込み中です");
}
function bound() {
	if (window.loading > 0) {
		window.counter++;
		if (window.counter % 3 == 0) {
			window.counter = 0;
			$(".loader:visible").effect("bounce");
		}
	}
}
$(function() {
	window.loading = 1;
	window.counter = 0;
	$("#remote-url").hide();
	$("#remote-loader").hide();
	$("#import-container").hide();
	window.setInterval(bound, 1000);
	window.keywords = {}
	window.themes = {}
	$("<div id='l'/>").appendTo($("#local-loader")).spin();
	$.get2(
		T.api+"get_active_keyword.php",
		{limit: "none"},
		function(ret) {
			for (var i=0; i<ret.length; i++) {
				window.keywords[ret[i].keyword] = true;
			}
			$.get2(
				T.api+"get_recent_theme.php",
				{limit: "none"},
				function(ret) {
					$("#l").remove();
					for (var i=0; i<ret.length; i++) {
						window.themes[ret[i].name] = true;
					}
					$("#local-loader").effect("fade", {mode:"hide"});
					$("#remote-url").effect("fade", {mode:"show"});
					window.loading--;
				},
				function() {
					alert("ローカルキーワードの読み込みに失敗しました。");
					location.reload();
				},
				"json"
			);
		},
		function() {
			alert("ローカルキーワードの読み込みに失敗しました。");
			location.reload();
		},
		"json"
	);
});
EOD;

$title = 'テーマ・キーワードのインポート';
$css_links = array('admin.css');
include LAYOUTS.'header.inc.php';
$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div id="local-loader" class="controller-box">
			<div class="loader">
				ローカルのテーマとキーワードを読み込んでいます
			</div>
		</div>

		<div id="remote-url" class="controller-box">
			<div>
				読込先BULLETのURL: <input type="text" id="load_url" name="load_url" value="http://tsuge.sub.jp/theme/demo/" />
			</div>
			<div class="action">
				<a href="javascript:start_load()" class="button">読み込み開始</a>
			</div>
		</div>

		<div class="controller-box">
			<div id="remote-loader" class="loader">
				リモートのテーマとキーワードを読み込んでいます
			</div>
		</div>

		<div id="import-container" class="controller-box">
			<div>
				<table><tbody>
					<tr>
						<th colspan="3">テーマ</th>
						<th colspan="3">キーワード</th>
					</tr>
					<tr>
						<th>対象</th>
						<th></th>
						<th>除外</th>
						<th>対象</th>
						<th></th>
						<th>除外</th>
					</tr>
					<tr>
						<td><select id="import-theme" size="10" multiple></select></td>
						<td class="action" align="center">
							<a href="javascript:del_theme()" class="button">→</a>
							<a href="javascript:add_theme()" class="button">←</a>
						</td>
						<td><select id="import-ng-theme" size="10" multiple></select></td>
						<td><select id="import-keyword" size="10" multiple></select></td>
						<td class="action" align="center">
							<a href="javascript:del_keyword()" class="button">→</a>
							<a href="javascript:add_keyword()" class="button">←</a>
						</td>
						<td><select id="import-ng-keyword" size="10" multiple></select></td>
					</tr>
				</tbody></table>
			</div>
			<div class="action">
				<a id="import-button" href="javascript:start_import()" class="button">インポート開始</a>
			</div>
		</div>

		<div class="controller-box">
			<div id="import-status" class="loader">
			</div>
		</div>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>