<?php
require_once(LIB.'Box.class.php');
if (! can_action('admin'))
	redirect();

$box = new Box();
$pages = $box->getPages();
$boxes = $box->listBoxes();
$layouts = $box->getLayouts();
$short_names = array();
foreach ($boxes as $b) {
	$short_names[$b] = $box->getShortestName($b, $boxes);
}
foreach ($boxes as $b) {
	$short_names[$b] = $box->getShortestName($short_names[$b], $short_names);
}

function _layout_print_header($boxes, $short_names) {
?>
			<tr class="layout-header">
				<th></th>
				<th>元</th>
				<th>先</th>
<?php
	foreach ($boxes as $b) {
		echo '<th>'.h($short_names[$b]).'</th>';
	}
	echo '<th>順序</th>';
?>
			</tr>
<?php
}

$script = <<<EOD
function swap_layout(page_name, box_name, has) {
	var mes;
	if (has) {
		mes = page_name + "に" + box_name + "を追加します。";
	} else {
		mes = page_name + "から" + box_name + "を削除します。";
	}
	if (! confirm(mes+"\\nよろしいですか？"))
		return;
	$("#layout-table a").css("visibility","hidden");
	$("input").hide();
	var param = {
		page_name: page_name,
		box_name: box_name,
		has: has
	}
	if ($("#sort").val() != "") {
		param.sort = $("#sort").val();
	}
	$.post2(
		T.api+"change_layout.php",
		param,
		function(ret) {
			if (! ret) {
				alert("更新に失敗しました。");
				$("#layout-table a").css("visibility","visible");
				$("input").show();
				return;
			}

			//不確実なので使わない
			//$("#layout-table a").css("visibility","visible");
			//$("#"+page_name+"-"+box_name).text(has ? "◆" : "◇").attr("href",
			//	"javascript:swap_layout(\""+page_name+"\",\""+box_name+"\"", has ? 0 : 1+")"
			//).attr("title", has ? "削除" : "追加");
			location.reload();
		},
		function() {
			alert("更新に失敗しました。");
			$("#layout-table a").css("visibility","visible");
			$("input").show();
		},
		"json"
	);
}
function copy_layout() {
	var src = $("input[name='copy_source']:checked");
	var dist = $("input[name='copy_dist']:checked");
	if (src.length == 0) {
		alert("コピー元を選択してください。");
		return false;
	}
	if (dist.length == 0) {
		alert("コピー先を選択してください。");
		return false;
	}

	var param = {src: src.val()};
	param.dist = [];
	var index = 0;
	dist.each(function() {
		param.dist[index++] = this.value;
	});

	$("#layout-table a").css("visibility","hidden");
	$("input").hide();

	$.post2(
		T.api+"copy_layout.php",
		param,
		function(ret) {
			if (! ret) {
				alert("コピーに失敗しました。");
				$("#layout-table a").css("visibility","visible");
				$("input").show();
				return;
			}
			location.reload();
		},
		function() {
			alert("コピーに失敗しました。");
			$("#layout-table a").css("visibility","visible");
			$("input").show();
		},
		"json"
	);

	return false;
}
$(function() {
	$("td").hover(
		function(e) {
			$(".layout-header").find("th:eq("+$(this).index()+")").addClass("active");
			$(this).parent().find("th").addClass("active");
		},
		function(e) {
			$(".layout-header").find("th:eq("+$(this).index()+")").removeClass("active");
			$(this).parent().find("th").removeClass("active");
		}
	);
});
EOD;

$table = array();
foreach ($pages as $p) {
	$table[$p] = array();
	foreach ($boxes as $b) {
		$table[$p][$b] = FALSE;
	}
}
foreach ($layouts as $d) {
	$table[$d['page']][$d['filename']] = TRUE;
}

$title = 'レイアウト管理';
$css_links = array('admin.css');
include LAYOUTS.'header.inc.php';
$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box">
			<form name="copy_form" onsubmit="return copy_layout()">
			<table id="layout-table"><tbody>
<?php
	$i=0;
	foreach ($table as $page_name => $row) {
		if ($i % 15 == 0) {
			_layout_print_header($boxes, $short_names);
		}
		$i++;
		echo '<tr>';
		echo '<th>'.h($page_name).'</th>';
		echo '<td><input type="radio" name="copy_source" value="'.h($page_name).'"/></td>';
		echo '<td><input type="checkbox" name="copy_dist" value="'.h($page_name).'"/></td>';
		foreach ($row as $box_name => $has) {
			echo '<td>';
			echo '<a id="'.$page_name.'-'.$box_name.'" href="javascript:swap_layout(\''.h($page_name).'\', \''.$box_name.'\', '.($has ? '0' : '1').')" title="'.($has ? '削除' : '追加').'">'.($has ? '◆' : '◇').'</a></td>';
		}
		echo '<td>';
		$ret = array();
		foreach ($layouts as $l) {
			if ($l['page']==$page_name) {
				$ret[] = $short_names[$l['filename']];
			}
		}
		echo implode(',',$ret);
		echo '</td>';
		echo '</tr>';
	}
?>
			</tbody></table>
			<div class="sub-box"></div>
			<div>
				<input type="submit" value="元から先へコピーする" name="noajax" />
			</div>
			</form>
		</div>

		<div class="controller-box">
			ソート番号: <input type="text" id="sort" value="" />
		</div>
	
		<div class="controller-box">
			<h2>略称</h2>
			<table id="auth-table"><tbody>
<?php
			foreach ($boxes as $b) {
				echo '<tr>';
				echo '<th style="text-align:left">'.h($short_names[$b]).'</td>';
				echo '<td style="text-align:left">'.h($b).'</td>';
				echo '</tr>';
			}
?>
			</tbody></table>
		</div>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>