<?php
require_once(LIB.'Post.class.php');
$post = new Post();

$page = 1;
if (! empty($params[0]))
	$page = (int)$params[0];

$show_count = 50;
$offset = ($page-1) * $show_count;

$contents = $post->getUnsafe(array_merge($_GET, array('limit' => $offset.','.$show_count, 'order' => 'id desc')));
$cnt = $post->count(0, $_GET);

$title = '投稿一覧';
$box = get_show_boxes(__FILE__);
$script = <<<EOD
	$(function() {
		T.initRead();
	});
EOD;
include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div id="content-box" class="box ui-widget-content ui-corner-all">
<?php
if (! can_action('view')) {
	echo '<div class="content">投稿を見るにはログインしてください。</div>';
} else {
	if (! empty($contents)) {
?>
<?php
		foreach ($contents as $content) {
?>
<div class="content" id="content<?php echo $content['id'];?>">
	<div class="header">
		<?php
			echo '<a href="'.BASE_URL;
			if ($content['user_id']) {
				echo 'user/'.rawurlencode($content['login_id']).'" class="name user'.$content['t'].'">'.h($content['n']).'</a>';
			} else {
				echo 'name/'.rawurlencode($content['n']).'" class="name">'.h($content['n']).'</a>';
				if ($content['trip']) {
					echo '<a href="'. BASE_URL.'trip/'.rawurlencode($content['trip']).'" class="name">@'.h($content['trip']).'</a>';
				}
			}
			?><span class="user">-</span><span class="time" d="<?php echo $content['created'];?>"><?php echo $content['created'];?></span>
	</div>
	<div class="body">
<?php
		$lines = explode("\n", h($content['content']));
		echo '<span>'.implode ('</span><br/><span>', $lines).'</span>';
?>
	</div>
	<div class="tag">
<?php
	if ($content['t_theme']) {
		echo '<a href="'.BASE_URL.'theme/'.rawurlencode($content['t_theme']).'" style="font-weight:bold">'.h($content['t_theme']).'</a>';
	}
	$tags = json_decode($content['jt']);
	if ($tags) {
		foreach ($tags as $tag) {
			echo '<a href="'.BASE_URL.'theme/'.rawurlencode($tag).'">'.h($tag).'</a>';
		}
	}
?>
	</div>
	<div class="action"><a href="<?php echo BASE_URL.'read/'.$content['id'];?>">詳細</a></div>
</div>
<?php
		}
		print_paging(BASE_URL.'list', $page, $show_count, $cnt);
	}
}
?>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>