<?php
require_once(LIB.'Post.class.php');
$css_links = array('login.css');
$title = 'ログイン';
$script = <<<EOD
	$(function() {
		$("#id").focus();
		$("input[type='submit']").button();
		$("#login-form").submit(function() {
			var id = $("#id").val();
			var password = $("#password").val();
			if (! id) {
				alert("IDを入力してください");
				$("#id").focus();
				return false;
			} 
			if (! password) {
				alert("パスワードを入力してください");
				$("#password").focus();
				return false;
			}
			$("#noajax").attr("disabled", "disabled");
			$.post2(
				T.api+'login.php',
				{id: id, password: password},
				function(res) {
					if (! res) {
						alert("ログインに失敗しました。\\nIDとパスワードを確認してください。");
						$("#id").focus();
						$("#noajax").removeAttr("disabled");
						return;
					}
					location.href = T.base;
				},
				function() {
					alert("ログインに失敗しました。\\nIDとパスワードを確認してください。");
					$("#id").focus();
					$("#noajax").removeAttr("disabled");
				},
				"json"
			);
			return false;
		});
	});
EOD;
include LAYOUTS.'header.inc.php';
$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div id="login-container" class="ui-widget-content ui-corner-all">
		<form id="login-form" action="<?php echo API_URL.'login.php';?>" method="post">
			<div id="login-center">
				<div class="input-area">
					<label for="id">ID</label>
					<input type="text" class="ui-corner-all" id="id" name="id" value="" />
				</div>
				<div class="input-area">
					<label for="password">パスワード</label>
					<input type="password" class="ui-corner-all" id="password" name="password" value="" />
				</div>
				<div class="login-button">
					<input type="submit" value="ログイン" id="noajax" name="noajax" />
				</div>
<?php
	if (can_action('regist')) {
		echo '<div class="login-button">';
		echo '<a href="'.BASE_URL.'regist">新規ユーザ登録</a>';
		echo '</div>';
	}
?>
			</div>
		</form>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>