<?php
require_once(LIB.'Post.class.php');

$title = 'ページ一覧';
$box = get_show_boxes(__FILE__);
$script = <<<EOD
	$(function() {
		T.initRead();
	});
EOD;
include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
?>
<style>
.virtual-page {
	display:none;
}
</style>
<div id="content-container" class="container ui-widget">
	<div class="ui-widget-content ui-corner-all help">
		<ul>
			<li>ユーザ関連
				<ul>
<?php
	if (is_login()) {
?>
					<li><a href="<?php echo BASE_URL;?>logout">ログアウト</a></li>
					<li><a href="<?php echo BASE_URL;?>my">マイページ</a></li>
					<li><a href="<?php echo BASE_URL;?>favorite_manage">お気に入り管理</a></li>
<?php
	} else {
?>
					<li><a href="<?php echo BASE_URL;?>login">ログイン</a></li>
<?php
	}
	if (can_action('regist')) {
?>
					<li><a href="<?php echo BASE_URL;?>regist">ユーザ登録</a></li>
<?php
	}
?>
				</ul>
			</li>
			<li>投稿関連のページ
				<ul>
					<li><a href="<?php echo BASE_URL;?>all">全投稿</a></li>
					<li><a href="<?php echo BASE_URL;?>list">全投稿 - 一覧形式</a></li>
					<li><a href="<?php echo BASE_URL;?>search">投稿検索</a>
						<ul class="virtual-page">
							<li>投稿詳細</li>
						</ul>
					</li>
					<li><a href="<?php echo BASE_URL;?>id_search">ID検索</a>
						<ul class="virtual-page">
							<li>XXXの投稿</li>
						</ul>
					</li>
					<li><a href="<?php echo BASE_URL;?>trip_search">トリップ検索</a>
						<ul class="virtual-page">
							<li>トリップ XXXの投稿</li>
						</ul>
					</li>
					<li><a href="<?php echo BASE_URL;?>user_search">ユーザ検索</a>
						<ul class="virtual-page">
							<li>XXX (XXX) の投稿</li>
						</ul>
					</li>
				</ul>
			</li>
			<li>テーマ関連のページ
				<ul>
					<li><a href="<?php echo BASE_URL;?>hot_theme">新しいテーマ</a>
						<ul class="virtual-page">
							<li>テーマ: XXX</li>
<?php
	if (can_action('edit_theme')) {
?>
							<li>テーマの編集</li>
<?php
	}
?>
						</ul>
	
					</li>
					<li><a href="<?php echo BASE_URL;?>recent_themes">話題のテーマ</a></li>
					<li><a href="<?php echo BASE_URL;?>theme_cloud">テーマクラウド</a></li>
<?php
	if (can_action('create_theme')) {
?>
					<li><a href="<?php echo BASE_URL;?>edit_theme">テーマの作成</a></li>
<?php
	}
?>
				</ul>
			</li>
			<li>URL関連のページ
				<ul>
					<li><a href="<?php echo BASE_URL;?>hot_urls">話題のURL</a>
						<ul class="virtual-page">
							<li>URL詳細</li>
						</ul>
					</li>
					<li><a href="<?php echo BASE_URL;?>recent_urls">新しいURL</a></li>
				</ul>
			</li>
			<li>キーワード関連のページ
				<ul>
					<li><a href="<?php echo BASE_URL;?>active_keywords">最近言及されたキーワード</a>
						<ul class="virtual-page">
							<li>キーワード: XXX</li>
						</ul>
					</li>
				</ul>
			</li>
<?php
	if (can_action('admin') || can_action('operation')) {
?>
			<li>管理者向けページ
				<ul>
					<li><a href="<?php echo BASE_URL;?>admin">管理機能メニュー</a></li>
<?php
	if (can_action('operation')) {
?>
					<li><a href="<?php echo BASE_URL;?>image">画像管理</a></li>
					<li><a href="<?php echo BASE_URL;?>userman">ユーザ管理</a></li>
<?php
	}
?>
<?php
	if (can_action('admin')) {
?>
					<li><a href="<?php echo BASE_URL;?>auth">権限管理</a></li>
					<li><a href="<?php echo BASE_URL;?>import">テーマ・キーワードのインポート</a></li>
					<li><a href="<?php echo BASE_URL;?>layout">ボックス配置</a></li>
					<li><a href="<?php echo BASE_URL;?>box">ボックス管理</a></li>
					<li><a href="<?php echo BASE_URL;?>skin">スキン管理</a></li>
					<li><a href="<?php echo BASE_URL;?>actionlog">セキュリティ設定</a></li>
<?php
	}
?>
				</ul>
			</li>
<?php
	}
?>
			<li>その他
				<ul>
					<li><a href="<?php echo BASE_URL;?>pagelist">ページ一覧</a></li>
					<li><a href="<?php echo BASE_URL;?>help">ヘルプ</a></li>
				</ul>
			</li>
		</ul>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>