<?php
require_once(LIB.'Post.class.php');
$id = @$params[0];
if (empty($id))
	redirect();
$post = new Post();
$content = $post->read($id);
if (empty($content))
	redirect();

$tree = $post->get(array('pp' => empty($content['t_id']) ? $content['id'] : $content['t_id']), NULL);

if (! can_action('view'))
	redirect();

require_once(LIB.'TKeyword.class.php');
$keyword = new TKeyword();
$keyword->load();

require_once(LIB.'TCommand.class.php');
$analyzer = new TCommandAnalyzer($content['content']);
$analyzer->analysis();
$urls = array();
$keywords = array();
if ($analyzer->commands) {
	foreach ($analyzer->commands as $command) {
		if (is_a($command, 'UrlCommand')) {
			$urls[] = $command->target;
		}
	}
}
$keywords = array_unique($keyword->matchAll($analyzer->dist));

$content_id = $content['id'];
$content_pp_id = $content['t_id'] ? $content['t_id'] : $content['id'];
$script = <<<EOD
	$(function() {
		T.reply_callback = function() {
			location.reload();
		}
		var url_path = $("<a/>").attr("href", T.base+"url")[0].href;
		T.autoLink();
		$(".content .body a").each(function() {
			if(this.href.match(/\.(png|jpeg|jpg|gif)/i)) {
				var url;
				if (url_path == this.href.substr(0, url_path.length)) {
					url = decodeURIComponent(decodeURIComponent(this.href.substr(url_path.length+1)))
				} else {
					url = this.href;
				}
				var img = $("<img/>");
				img.attr("src", url);
				$(window).resize(function() {
					if ($(img).width() > $(".theme-view").innerWidth())
						$(img).width($(".theme-view").innerWidth());
				});
				$("<div class='theme-view'>").append(img).insertBefore(".content");
			}
		});
		$.each($(".time"), function() {
			$(this).text(T.countdown_by($(this).text()));
		});

		var content = $("#linked_contents");
		content.attr("i",{$content_id}).attr("pp", {$content_pp_id});
		T.conversation(content);
	});
EOD;
$id = $params[0];
$title = $content['trip'] ? $content['trip'] : $content['display_name'];
$title .= ': '.mb_truncate($content['content'], 32);
$tags = json_decode($content['json_theme']);
include LAYOUTS.'header.inc.php';
$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div id="content-box" class="box ui-widget-content ui-corner-all" style="font-size:160%">
<div class="content" id="content<?php echo $content['id'];?>" style="border-bottom:none">
	<div class="header header-border">
		<div>
			<a class="name" href="<?php echo BASE_URL.'name/'.rawurlencode($content['display_name']);?>"><?php echo h($content['display_name']); ?></a><?php if ($content['trip']) { echo '<a href="'. BASE_URL.'trip/'.rawurlencode($content['trip']).'" class="name">@'.h($content['trip']).'</a>';} ?> - <span class="time" d="<?php echo $content['created'];?>"><?php echo $content['created'];?></span>
		</div>
		<div>
			投稿ID: <?php echo $content['id'];?>
		</div>
	</div>
	<div class="body<?php if ($tags || $keywords || $urls) echo ' header-border';?>">
<?php
		$lines = explode("\n", h($content['content']));
		echo '<span>'.implode ('</span><br/><span>', $lines).'</span>';
?>
	</div>
	<div class="tag">
<?php
	if ($tags || $content['t_theme']) {
		echo '<h3>関連付けられているテーマ:</h3>';
		echo '<ul class="link-list">';
		if ($content['t_theme']) {
			echo '<li><strong><a class="name" href="'.BASE_URL.'theme/'.rawurlencode($content['t_theme']).'">'.h($content['t_theme']).'</a></strong></li>';
		}
		foreach ($tags as $tag) {
			echo '<li><a class="name" href="'.BASE_URL.'theme/'.rawurlencode($tag).'">'.h($tag).'</a></li>';
		}
		echo '</ul>';
	}
?>
	</div>
	<div class="tag">
<?php
	if ($keywords) {
		echo '<h3>マッチしたキーワード:</h3>';
		echo '<ul class="link-list">';
		foreach ($keywords as $keyword) {
			echo '<li><a class="name" href="'.BASE_URL.'keyword/'.rawurlencode($keyword).'">'.h($keyword).'</a></li>';
		}
		echo '</ul>';
	}
?>
	</div>
	<div class="tag">
<?php
	if ($urls) {
		echo '<h3>関連付けられているURL:</h3>';
		echo '<ul class="link-list">';
		foreach ($urls as $url) {
			echo '<li><a class="name" href="'.BASE_URL.'url/'.rawurlencode(rawurlencode($url)).'">'.h($url).'</a></li>';
		}
		echo '</ul>';
	}
?>
	</div>

	<div class="tag">
		<h3>関連する書き込み:</h3>
		<div class="content" id="linked_contents">
		</div>
	</div>
</div>
<div id="preview-dialog"></div>
<div id="reply-dialog"></div>
<?php
include LAYOUTS.'footer.inc.php';
?>