<?php
require_once(LIB.'Post.class.php');
$post = new Post();

$page = 1;
if (! empty($params[1]))
	$page = (int)$params[1];
$show_count = 30;
$offset = ($page-1) * $show_count;

$search = rawurldecode(@$params[0]);
if ($search) {
	$w = '`name` like ? or key1 like ? or key2 like ? or key3 like ?';
	$n = '%'.str_replace('%', '\\%', $search).'%';
	$params = array($n, $n, $n, $n);
	$themes = $post->getRecentTheme($offset.','.$show_count, $w, $params);
	$cnt = $post->countTheme($w, $params);
} else {
	$themes = $post->getRecentTheme($offset.','.$show_count);
	$cnt = $post->countTheme();
}

$title = '新しいテーマ一覧';
$css_links = array('url.css');
$box = get_show_boxes(__FILE__);
$script = <<<EOD
	$(function() {
		T.initRead(true);
		$.each($(".time"), function() {
			$(this).text(T.countdown_by($(this).text()));
		});
		$("#search_form").submit(function() {
			location.href = $("#search_form").attr("action")+"/"+encodeURIComponent(encodeURIComponent($("#search").val()));
			return false;
		});
	});
EOD;
include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box theme-box">
			<form id="search_form" name="search_form" action="<?php echo BASE_URL;?>recent_themes">
				<input type="text" name="search" id="search" value="<?php echo h($search);?>"  /> <input type="submit" value="検索" class="button" />
			</form>
		</div>
<?php
	if (! empty($themes)) {
		echo '<ul class="url-list">';
		foreach ($themes as $k => $v) {
			echo '<li>';
			echo '<a href="'.BASE_URL.'theme/'.rawurlencode($v['name']).'" class="name url-title">'.h($v['name']).'</a> - <span class="time">'.$v['created'].'</span><br/>';
			echo h(mb_truncate($v['description'], 48)).'<br/>';
			/*
			$keys = array();
			if (! empty($v['key1']))
				$keys[] = $v['key1'];
			if (! empty($v['key2']))
				$keys[] = $v['key2'];
			if (! empty($v['key3']))
				$keys[] = $v['key3'];
			foreach ($keys as $k2 => $v2) {
				if ($k2)
					echo ', ';
				echo 'キー'.($k2+1).': '.$v2;
			}
			if ($keys)
				echo '<br/>';
			*/
			echo '言及数: '.$v['cnt'];
			echo '</li>';
		}
		echo '</ul>';
	} else {
		echo '<div style="margin:1em">テーマが見つかりません。</div>';
	}
?>
<?php
	print_paging(BASE_URL.'recent_themes/'.$search, $page, $show_count, $cnt);
?>
<?php
	if (can_action('create_theme')) {
?>
		<div class="controller-box theme-box">
			<a href="<?php echo u('edit_theme');?>">テーマを作る</a>
		</div>
<?php
	}
?>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>