<?php
require_once(LIB.'Post.class.php');
$post = new Post();

$page = 1;
if (! empty($params[1]))
	$page = (int)$params[1];
$show_count = 30;
$offset = ($page-1) * $show_count;

$search = rawurldecode(@$params[0]);
if ($search) {
	$w = 'title like ? or url like ?';
	$n = '%'.str_replace('%', '\\%', $search).'%';
	$params = array($n, $n);
	$urls = $post->getRecentUrl($offset.','.$show_count, $w, $params);
	$cnt = $post->countUrl($w, $params);
} else {
	$urls = $post->getRecentUrl($offset.','.$show_count);
	$cnt = $post->countUrl();
}

$title = '新しいURL一覧';
$box = get_show_boxes(__FILE__);
$css_links = array('url.css');
$script = <<<EOD
	$(function() {
		T.initRead(true);
		$.each($(".time"), function() {
			$(this).text(T.countdown_by($(this).text()));
		});
		$("#search_form").submit(function() {
			location.href = $("#search_form").attr("action")+"/"+encodeURIComponent(encodeURIComponent($("#search").val()));
			return false;
		});
	});
EOD;

include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box theme-box">
			<form id="search_form" name="search_form" action="<?php echo BASE_URL;?>recent_urls">
				<input type="text" name="search" id="search" value="<?php echo h($search);?>"  /> <input type="submit" value="検索" class="button" />
			</form>
		</div>

		<ul class="url-list">
<?php
if (! empty($urls)) {
	foreach ($urls as $k => $v) {
		echo '<li>';
		echo '<a href="'.BASE_URL.'url/'.rawurlencode(rawurlencode($v['url'])).'" class="name url-title">'.h(empty($v['title'])? $v['url'] : $v['title']).'</a><br/>';
		echo '<a href="'.$v['url'].'" class="name">'.h($v['url']).'</a><br/>';
		echo '初出: <span class="time">'.$v['created'].'</span>';
		echo '</li>';
	}
}
?>
	</ul>
<?php
	print_paging(BASE_URL.'recent_urls/'.$search, $page, $show_count, $cnt);
?>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>