<?php
require_once(LIB.'User.class.php');
$userObj = new User();
$user = $userObj->load();
if (! can_action('regist'))
	redirect();

$css_links = array('login.css');
$title = 'ユーザ登録';
$script = <<<EOD
	$(function() {
		$("#display_name").focus();
		$("input[type='submit']").button();
		$("#login-form").submit(function() {
			var id = $("#id").val();
			var password = $("#password").val();
			var display_name = $("#display_name").val();
			if (! id) {
				alert("IDを入力してください");
				$("#id").focus();
				return false;
			} 
			if (! password) {
				alert("パスワードを入力してください");
				$("#password").focus();
				return false;
			}
			if (! display_name) {
				alert("表示名を入力してください");
				$("#display_name").focus();
				return false;
			}

			var user_type_id = $("#user_type_id").val();
			if (! user_type_id)
				user_type_id = 2;

			$("#noajax").attr("disabled", "disabled");
			$.post2(
				T.api+'regist.php',
				{id: id, password: password, display_name: display_name, user_type_id: user_type_id},
				function(res) {
					if (! res.ret) {
						if (res.message) {
							alert(res.message);
						} else {
							alert("ユーザ登録に失敗しました");
						}
						if (res.field) {
							$("#"+res.field).focus();
						}
						$("#noajax").removeAttr("disabled");
						return;
					}
					alert("ユーザ登録に成功しました。");
					location.href = T.base+"login";
				},
				function() {
					alert("ユーザ登録に失敗しました");
					$("#noajax").removeAttr("disabled");
					return;
				},
				"json"
			);
			return false;
		});
	});
EOD;
include LAYOUTS.'header.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div id="login-container" class="ui-widget-content ui-corner-all">
		<form id="login-form" action="<?php echo API_URL.'regist.php';?>" method="post">
			<div id="regist-center">
				<div class="input-area">
					<label for="display_name">表示名</label>
					<input type="text" class="ui-corner-all" id="display_name" name="display_name" value="" />
				</div>
				<div class="input-area">
					<label for="id">ID</label>
					<input type="text" class="ui-corner-all" id="id" name="id" value="" />
				</div>
				<div class="input-area">
					<label for="password">パスワード</label>
					<input type="password" class="ui-corner-all" id="password" name="password" value="" />
				</div>
<?php
	if (can_action('admin')) {
?>
				<div class="input-area">
					<label for="user_type_id">ユーザ種別</label>
					<select name="user_type_id" id="user_type_id">
						<option value="2" checked>ユーザ</option>
						<option value="1">管理者</option>
						<option value="3">運用者</option>
					<select>
				</div>
<?php
}
?>
				<div class="login-button">
					<input type="submit" value="登録" id="noajax" name="noajax" />
				</div>
			</div>
		</form>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>