<?php
require_once(LIB.'TSearch.class.php');
$searchEngine = new TSearch();

$page = 1;
if (! empty($_GET['p']))
	$page = (int)$_GET['p'];

$show_count = 20;
$offset = ($page-1) * $show_count;

$q = @$_GET['q'];
if ($q) {
	$contents = $searchEngine->search($q, $offset, $show_count, $_GET);
	$cnt = $searchEngine->count($q, $_GET);
}

$title = ($q ? ($q.'の検索結果') : '投稿検索');
$box = get_show_boxes(__FILE__);
$script = <<<EOD
	$(function() {
		T.initRead();
	});
EOD;
include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box ui-widget-content ui-corner-all">

	<div class="controller-box theme-box">
		<form id="search_form" name="search_form" action="<?php echo BASE_URL;?>search/">
			<input type="text" name="q" value="<?php echo h($q);?>"  /> <input type="submit" value="検索" class="button" />
		</form>
<?php
	if (empty($q)) {
?>
		<div>
			検索したい語句を入力して、検索ボタンを押してください。
		</div>
	</div>
<?php
	} else {
?>
		<div>
			<?php echo h($q);?>の検索結果
		</div>
	</div>

	<div id="content-box">
<?php
if (! can_action('view')) {
	echo '<div class="content">投稿を見るにはログインしてください。</div>';
} else {
	if (! empty($q) && ! empty($contents)) {
?>
<?php
		foreach ($contents as $content) {
?>
<div class="content" id="content<?php echo $content['id'];?>">
	<div class="header">
		<?php
			echo '<a href="'.BASE_URL;
			if ($content['user_id']) {
				echo 'user/'.rawurlencode($content['login_id']).'" class="name user'.$content['t'].'">'.h($content['n']).'</a>';
			} else {
				echo 'name/'.rawurlencode($content['n']).'" class="name">'.h($content['n']).'</a>';
				if ($content['trip']) {
					echo '<a href="'. BASE_URL.'trip/'.rawurlencode($content['trip']).'" class="name">@'.h($content['trip']).'</a>';
				}
			}
			?><span class="user">-</span><span class="time" d="<?php echo $content['created'];?>"><?php echo $content['created'];?></span>
	</div>
	<div class="body">
<?php
		$lines = explode("\n", h($content['content']));
		echo '<span>'.implode ('</span><br/><span>', $lines).'</span>';
?>
	</div>
	<div class="tag">
<?php
	if ($content['t_theme']) {
		echo '<a href="'.BASE_URL.'theme/'.rawurlencode($content['t_theme']).'" style="font-weight:bold">'.h($content['t_theme']).'</a>';
	}
	$tags = json_decode($content['jt']);
	if ($tags) {
		foreach ($tags as $tag) {
			echo '<a href="'.BASE_URL.'theme/'.rawurlencode($tag).'">'.h($tag).'</a>';
		}
	}
?>
	</div>
	<div class="action"><a href="<?php echo BASE_URL.'read/'.$content['id'];?>">詳細</a></div>
</div>
<?php
		}
	}
}
		print_paging_q(BASE_URL.'search/?q='.rawurlencode($q), $page, $show_count, $cnt);
?>
	</div>
<?php
	}
?>

	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>