<?php
require_once(LIB.'Skin.class.php');
if (! can_action('admin'))
	redirect();

$skin = new Skin();
$skins = $skin->getSkinList();

$title = 'スキン管理';
$script = 'var skins=[];
';
foreach ($skins as $s) {
	$script .= 'skins.push("'.h($s).'");
';
}
$script .= 'var current_skin = "'.h(Setting::Get('skin')).'";
';
$skin->load(Setting::Get('skin'));
$script .= 'var current_admin_color = "'.h(Setting::Get('admin-color', '#ff0')).'";
';
$script .= 'var current_operator_color = "'.h(Setting::Get('operator-color', '#f92')).'";
';
$script .= <<<EOD
$(function() {
	var l =$("#skin-list");
	for (var i=0; i<skins.length; i++) {
		var opt = $("<option/>").text(skins[i]);
		if (skins[i] == current_skin) {
			opt.attr("selected", current_skin);
		}
		l.append(opt);
	}
	l.change(function() {
		var skin = $(this).val();
		if (! skin) {
			//意味無し
			$("#skin-preview").removeAttr("src").removeAttr("alt");
			$("#skin").attr("href", T.css+current_skin+"/jquery-ui-1.9.2.custom.css");
		} else {
			$("#skin-preview").attr("src", T.css+skin+"/images/preview.png").attr("alt", skin);
			$("#skin").attr("href", T.css+skin+"/jquery-ui-1.9.2.custom.css");
		}
	}).change();
	$("#admin-color").val(current_admin_color).keyup(function() {
		$("#color-preview").css("background-color", $(this).val());
	}).keyup();
	$("#operator-color").val(current_operator_color).keyup(function() {
		$("#color-preview2").css("background-color", $(this).val());
	}).keyup();
});
function change_skin() {
	var target_skin = $("#skin-list").val();
	if (! target_skin) {
		alert("スキンを選択してください。");
		return;
	}
	$(".button").hide();
	$.post2(
		T.api+"change_skin.php",
		{skin: target_skin, admin:$("#admin-color").val(), operator:$("#operator-color").val()},
		function(ret) {
			if (! ret) {
				alert("スキンの更新に失敗しました。");
				$(".button").show();
				return;
			}
			location.reload();
		},
		function() {
			alert("スキンの更新に失敗しました。");
			$(".button").show();
		},
		"json"
	);
}
function restore_skin() {
	if (! confirm("現在の設定を取り消し、スキンをデフォルトの状態に戻します。よろしいですか？\\n※この操作は取り消し出来ません")) {
		return;
	}
	$(".button").hide();
	$.post2(
		T.api+"restore_skin.php",
		function(ret) {
			if (! ret) {
				alert("エラーです。");
				$(".button").show();
				return;
			}
			location.reload();
		},
		function() {
			alert("エラーです。");
			$(".button").show();
		},
		"json"
	);
}
EOD;
$css_links = array('admin.css');
include LAYOUTS.'header.inc.php';
$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget hresizable">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box">
			<h2>スキン一覧</h2>
			<select id="skin-list">
				<option></option>
			</select>
		</div>
	
		<div class="controller-box">
			<h2>スキンプレビュー</h2>
			<div>
				<img id="skin-preview" />
			</div>
		</div>

		<div class="controller-box">
			<h2>管理ユーザ色</h2>
			<div>
				<input type="text" id="admin-color" value="" />
				<span id="color-preview" style="width:20px; height:20px; display:inline-block"></span>
			</div>
			<h2>運用ユーザ色</h2>
			<div>
				<input type="text" id="operator-color" value="" />
				<span id="color-preview2" style="width:20px; height:20px; display:inline-block"></span>
			</div>
		</div>

		<div id="error-box"></div>

		<div class="controller-box">
			<div>
				<input id="save-button" type="button" onclick="change_skin()" value="保存" class="button" />
				<input id="del-button" type="button" onclick="restore_skin()" value="初期値に戻す" class="button" />
			</div>
		</div>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>