<?php
require_once(LIB.'Post.class.php');
$post = new Post();
$id = @$params[0];
$theme = $post->readTheme($id);

if (empty($theme)) {
	$message = 'テーマ「'.$id.'」は現在存在しません。';
	$sub_title = $message;
	include 'error.php';
	die;
}
$theme_name = $theme['name'];
$theme_name_url = h($theme_name);

$contents = $post->get(array('theme' => $theme['name']));

$script = <<<EOD
	$(function() {
		$("#post-btn").val("このテーマに投稿");
		T.readOpt.theme = "{$theme_name_url}";
		T.initRead();
		T.autoLink("#theme-detail .description", true);
	});
EOD;

$title = 'テーマ: '.$theme['name'];
$box = get_show_boxes(__FILE__);
$meta_description = empty($theme['description']) ? NULL : $theme['description'];
$meta_keyword = '';
foreach (array($theme['key1'],$theme['key2'],$theme['key3']) as $k) {
	if (! empty($k)) {
		if (! empty($meta_keyword))
			$meta_keyword .= ',';
		$meta_keyword .= $k;
	}
}
include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
include LAYOUTS.'content.inc.php';
include LAYOUTS.'footer.inc.php';
?>