<?php
require_once(LIB.'User.class.php');
$userObj = new User();

$page = 1;
if (! empty($_GET['p']))
	$page = (int)$_GET['p'];
$show_count = 20;
$offset = ($page-1) * $show_count;

$q = @$_GET['q'];
if ($q) {
	$users = $userObj->searchTrip($q, $offset.','.$show_count);
	$cnt = $userObj->countSearchTrip($q);
}

$title = 'トリップ検索';
$css_links = array('url.css');
$box = get_show_boxes(__FILE__);
$script = <<<EOD
	$(function() {
		T.initRead(true);
		$.each($(".time"), function() {
			$(this).text(T.countdown_by($(this).text()));
		});
	});
EOD;
include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box theme-box">
			<form id="search_form" name="search_form" action="<?php echo BASE_URL;?>trip_search/">
				<input type="text" name="q" value="<?php echo h($q);?>"  /> <input type="submit" value="検索" class="button" />
			</form>
		</div>
<?php
	if (! empty($users)) {
		echo '<ul class="url-list">';
		foreach ($users as $k => $v) {
			echo '<li>';
			echo '<a href="'.BASE_URL.'trip/'.rawurlencode($v['trip']).'" class="name url-title">'.h($v['trip']).'</a><br/>';
			if ($v['recent_post'])
				echo '最終投稿: <span id="time">'.$v['recent_post'].'</span><br/>';
			echo '投稿数: '.$v['post_count'];
			echo '</li>';
		}
		echo '</ul>';
		print_paging_q(BASE_URL.'trip_search/?q='.rawurlencode($q), $page, $show_count, $cnt);
	} else if (empty($q)) {
		echo '<div style="margin:1em">探したい語句を入力し、検索してください。<br/>';
		echo '<a href="'.BASE_URL.'id_search">ID検索</a>ならびにトリップ検索では、ABCDEFGHを探す場合、ABCなら探せますが、FGHでは探せない点に注意してください。</div>';
	} else {
		echo '<div style="margin:1em">トリップが見つかりません。<br/>';
		echo '<a href="'.BASE_URL.'id_search">ID検索</a>ならびにトリップ検索では、ABCDEFGHを探す場合、ABCなら探せますが、FGHでは探せない点に注意してください。</div>';
?>
<?php
	}
?>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>