<?php
require_once(LIB.'Post.class.php');
$post = new Post();
$id = @$params[0];
if (empty($id)) {
	$message = 'URL「'.$id.'」は現在存在しません。';
	$sub_title = $message;
	include 'error.php';
	die;
}
$id = rawurldecode($id);
if (substr($id, -1) == '/')
	$id = substr($id, 0, -1);
$url = $post->readUrl($id);

if (empty($url)) {
	$message = 'URL「'.$id.'」は現在存在しません。';
	$sub_title = $message;
	include 'error.php';
	die;
}
$url_name = $url['url'];
$url_name_url = h($url_name);

$contents = $post->get(array('url' => $url['url']));

$script = <<<EOD
	$(function() {
		$("#post-btn").val("このURLについて投稿");
	});
	$(function() {
		T.readOpt.url = "{$url_name_url}";
		var theme_preview = $("<div class='theme-view' />");
		T.initRead();
		if(T.readOpt.url.match(/\\.(png|jpeg|jpg|gif)/i)) {
			var img = $("<img src='{$url_name_url}' />");
			$(window).resize(function() {
				if ($(img).width() > $(".theme-view").innerWidth())
					$(img).width($(".theme-view").innerWidth());
			});
			img.error(function() {
				img.remove();
			});
			theme_preview.append(img).insertBefore($("#loading"));
		}
	});
EOD;

$title = mb_truncate(empty($url['title']) ? $url['url'] : $url['title'], 40);
$box = get_show_boxes(__FILE__);
include LAYOUTS.'header.inc.php';
include LAYOUTS.'control.inc.php';
include LAYOUTS.'content.inc.php';
include LAYOUTS.'footer.inc.php';
?>