<?php
if (! can_action('operation'))
	redirect();

$id = @$params[0];
if (empty($id))
	redirect('userman');

require_once(LIB.'User.class.php');
$userObj = new User();
$user = $userObj->readAdmin($id);
$title = 'ユーザ詳細: '.$user['login_id'];
$css_links = array('admin.css');

$user_types = $userObj->getUserTypes();

$active_value = $user['is_active'] ? '0' : '1';
$script = <<<EOD
	$(function() {
		$(".time").each(function() {
			var t = $(this).text();
			if (t)
				$(this).text(T.countdown_by($(this).text()));
		});
	});
	function switch_active() {
		var params = {}
		params.is_active = {$active_value};
		$.post2(
			T.api+"edit_profile.php?id={$id}",
			params,
			function(ret) {
				if ((!ret) || (!ret.ret)) {
					if (ret.message) {
						alert(ret.message);
					} else {
						alert("失敗しました。");
					}
					return;
				}
				alert((params.is_active ? "有効" : "無効") + "化しました。");
				location.reload();
			},
			function() {
				alert("無効化に失敗しました。");
			},
			"json"
		);
	}
EOD;

include LAYOUTS.'header.inc.php';
$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box">
			<a href="<?php echo BASE_URL;?>userman">戻る</a>
		</div>
		<div class="controller-box">
			<h2>基本情報</h2>
			<table class="user-table detail-info"><tbody>
			<tr>
				<th>内部ID</th>
				<td><?php echo h($user['id']);?></td>
			</tr>
			<tr>
				<th>ログインID</th>
				<td><a href="<?php echo BASE_URL.'user/'.rawurlencode($user['login_id']);?>"><?php echo h($user['login_id']);?></a></td>
			</tr>
			<tr>
				<th>ユーザ種別</th>
				<td><?php echo h($user_types[$user['user_type_id']]['name']);?></td>
			</tr>
			<tr>
				<th>表示名</th>
				<td><a href="<?php echo BASE_URL.'name/'.rawurlencode($user['display_name']);?>"><?php echo h($user['display_name']);?></a></td>
			</tr>
			<tr>
				<th>暗号化パスワード</th>
				<td><?php echo h($user['password']);?></td>
			</tr>
			<tr>
				<th>投稿数</th>
				<td><?php echo h($user['post_count']);?></td>
			</tr>
			<tr>
				<th>登録日時</th>
				<td><?php echo h($user['registered']);?></td>
			</tr>
			<tr>
				<th>最終ログイン</th>
				<td><?php echo h($user['last_login']);?></td>
			</tr>
			<tr>
				<th>有効</th>
				<td>
					<?php echo h($user['is_active']);?><br />
					<a href="javascript:switch_active()"><?php echo ($user['is_active']) ? '無効化' : '有効化';?></a>
				</td>
			</tr>
			</tbody></table>
		</div>
		<div class="controller-box">
			<h2>最近の投稿</h2>
			<table class="user-table detail-info"><tbody>
			<tr>
				<th>日時</th>
				<th>ID</th>
				<th>匿名</th>
				<th>トリップ</th>
				<th>表示名</th>
				<th>テーマ</th>
				<th>メイン</th>
				<th>内容</th>
			</tr>
<?php
	foreach ($user['posts'] as $p) {
		echo '<tr>';
		echo '<td>'.h($p['created']).'</td>';
		echo '<td><a href="'.BASE_URL.'read/'.$p['id'].'">'.$p['id'].'</a></td>';
		echo '<td>'.($p['anonymous'] ? '◆' : '').'</td>';
		echo '<td><a href="'.BASE_URL.'trip/'.rawurlencode($p['trip']).'">'.h($p['trip']).'</a></td>';
		echo '<td><a href="'.BASE_URL.'name/'.rawurlencode($p['display_name']).'">'.h($p['display_name']).'</a></td>';
		if ($p['json_theme']) {
			echo '<td>';
			$themes = json_decode($p['json_theme']);
			foreach ($themes as $theme) {
				echo '<a href="'.BASE_URL.'theme/'.rawurlencode($theme).'">'.h($theme).'</a> ';
			}
			echo '</td>';
		} else {
			echo '<td>-</td>';
		}
		if ($p['t_theme']) {
			echo '<td><a href="'.BASE_URL.'theme/'.rawurlencode($p['t_theme']).'">'.h($p['t_theme']).'</a></td>';
		} else {
			echo '<td>-</td>';
		}
		echo '<td>'.h($p['content']).'</td>';
		echo '</tr>';
	}
?>
			</tbody></table>
		</div>
		<div class="controller-box">
			<h2>Action log</h2>
			<table class="user-table detail-info"><tbody>
			<tr>
				<th>日時</th>
				<th>ID</th>
				<th>IP</th>
				<th>ID</th>
				<th>対象</th>
				<th>行動</th>
				<th>id or key</th>
				<th>成功</th>
				<th>詳細</th>
			</tr>
<?php
	foreach ($user['logs'] as $l) {
		echo '<tr>';
		echo '<td>'.h($l['created']).'</td>';
		echo '<td><a href="'.BASE_URL.'actiondetail/'.rawurlencode($l['log_id']).'/?back_url='.rawurlencode($_SERVER['REQUEST_URI']).'">'.h($l['log_id']).'</a></td>';
		echo '<td>'.h($l['ip']).'</td>';
		echo '<td>'.h($l['id']).'</td>';
		echo '<td>'.h($l['target']).'</td>';
		echo '<td>'.h($l['action']).'</td>';
		if ($l['target_id'] && $l['target_key']) {
			echo '<td>'.$l['target_id'] .'('.h($l['target_key']).')</td>';
		} else if( $l['target_id']) {
			echo '<td>'.$l['target_id'] .'</td>';
		} else if ($l['target_key']) {
			echo '<td>'.h($l['target_key']).'</td>';
		} else {
			echo '<td>-</td>';
		}
		echo '<td>'.($l['success'] ? '◆' : '').'</td>';
		if (empty($l['detail'])) {
			echo '<td>-</td>';
		} else {
			$test = @unserialize($l['detail']);
			if ($test) {
				echo '<td>';
				var_dump($test);
				echo '</td>';
			} else {
				echo '<td>'.h($l['detail']).'</td>';
			}
		}
		echo '</tr>';
	}
?>
			</tbody></table>
		</div>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>