<?php
if (! can_action('operation'))
	redirect();

require_once(LIB.'User.class.php');
$userObj = new User();

$page = 1;
if (! empty($_GET['p']))
	$page = (int)$_GET['p'];
$show_count = 20;
$offset = ($page-1) * $show_count;

$q = @$_GET['q'];
$user_type_id = empty($_GET['user_type_id']) ? '2' : $_GET['user_type_id'];
$cnt = $userObj->countSearchAdmin($user_type_id, $q);
$users = $userObj->searchAdmin($user_type_id, $q, $offset.','.$show_count);
$user_types = $userObj->getUserTypes();

$title = 'ユーザ管理';
$css_links = array('admin.css');

$script = <<<EOD
	$(function() {
		$(".time").each(function() {
			var t = $(this).text();
			if (t)
				$(this).text(T.countdown_by2($(this).text()));
		});
	});
EOD;

include LAYOUTS.'header.inc.php';
$box = get_show_boxes(__FILE__);
include LAYOUTS.'control.inc.php';
?>
<div id="content-container" class="container ui-widget">
	<div class="box controller ui-widget-content ui-corner-all">
		<div class="controller-box">
			<form id="search_form" name="search_form" action="<?php echo BASE_URL;?>userman/">
				<input type="text" name="q" value="<?php echo h($q);?>"  />
				<select name="user_type_id">
<?php
	foreach ($user_types as $user_type) {
			if (empty($user_type['id']))
				continue;
			echo '<option value="'.$user_type['id'].'"'.($user_type_id == $user_type['id'] ? ' selected' : '').'>'.h($user_type['name']).'</option>';
	}
?>
				</select>
				<input type="submit" value="検索" class="button" />
			</form>
<?php
	if (! empty($users)) {
?>
			<table id="user-table"><tbody>
			<tr>
				<th>内部ID</th>
				<th>ID</th>
				<th>表示名</th>
				<th>投稿数</th>
				<th>最終投稿</th>
				<th>登録日時</th>
				<th>ログイン</th>
				<th>有効</th>
				<th>Action</th>
			</tr>
<?php
		foreach ($users as $user) {
?>
			<tr>
<?php
			echo '<td>'.h($user['id']).'</td>';
			echo '<td><a href="'.BASE_URL.'user/'.rawurlencode($user['login_id']).'">'.h($user['login_id']).'</a></td>';
			echo '<td><a href="'.BASE_URL.'name/'.rawurlencode($user['display_name']).'">'.h($user['display_name']).'</a></td>';
			echo '<td>'.$user['post_count'].'</td>';
			echo '<td class="time">'.h($user['recent_post']).'</td>';
			echo '<td class="time">'.h($user['registered']).'</td>';
			echo '<td class="time">'.h($user['last_login']).'</td>';
			echo '<td>'.($user['is_active'] ? '◆' : '').'</td>';
			echo '<td><a href="'.BASE_URL.'userdetail/'.$user['id'].'">詳細</a></td>';
?>
			</tr>
<?php
		}
?>
			</tbody></table>
<?php
		print_paging_q(BASE_URL.'userman/?q='.rawurlencode($q), $page, $show_count, $cnt);
	} else {
?>
		<div>ユーザが見つかりません。</div>
<?php
	}
?>
		</div>
	</div>
</div>
<?php
include LAYOUTS.'footer.inc.php';
?>