<?php
include 'env.php';
require_once(LIB.'config.inc.php');
require_once(LIB.'Setting.class.php');
require_once(LIB.'util.inc.php');
Setting::Load();
mb_internal_encoding('UTF-8');
function _url($v) {
	$url = 'http://';
	$url .= $_SERVER['SERVER_NAME'];
	if ($_SERVER['SERVER_PORT'] != 80) {
		$url .= ':'.$_SERVER['SERVER_PORT'];
	}
	$url .= $v;
	return $url;
}
if (! empty($_POST['do_table'])) {
	include dirname(__FILE__).'/doc/tables.inc.php';
	include LIB.'db.inc.php';
	foreach ($tables as $table) {
		$t = $db->getTableName($table);
		$create = file_get_contents(dirname(__FILE__).'/doc/'.$table.'.sql');
		$create_sql = str_replace('%%%TABLE_NAME%%%', $t, $create);
		//$db->execute('drop table `'.$t.'`');
		$ret = $db->execute($create_sql);
		//if ($ret === FALSE)
		//	die('error: '.$table);
		if (file_exists(dirname(__FILE__).'/doc/'.$table.'.data.sql')) {
			$pure_data = file_get_contents(dirname(__FILE__).'/doc/'.$table.'.data.sql');
			$data = unserialize($pure_data);
			$db->pureDelete($table);
			foreach ($data as $d)
				$db->insert($table, $d);
		}
	}
	require_once(LIB.'User.class.php');
	$user = new User();
	$user->saveAuthCache();
	header('Location: setup.php');
	die;
}
if (! empty($_POST['do'])) {
	require_once(LIB.'User.class.php');
	$user = new User();
	$ret = $user->db->selectRow('users', NULL, array('user_type_id' => 1));
	if ($ret) {
		header('Location: setup.php');
		die;
	}
	$ret = $user->registUser(
		$_POST['login_id'],
		$_POST['password'],
		$_POST['display_name'],
		1,
		1
	);
	if ($ret) {
		header('Location: setup.php');
		die;
	}
}

$title = 'セットアップツール';
include LAYOUTS.'header.inc.php';
?>
<style>
#status {
	width:auto;
	border-collapse:collapse;
	color:#fff;
}
#status th {
	font-weight: normal;
	background-color: #3a8104;
	border:1px solid #45930B;
	text-align: center;
	padding: 8px;
}
#status td {
	width: auto;
	background-color: #285c00;
	border:1px solid #45930B;
	text-align: center;
	padding: 8px;
}
#status td.desc {
	width:auto;
	text-align:left;
}
#status td.error {
	background-color:#ff7572;
}
</style>
<table id="status"><tbody>
<tr>
	<th>項目</th>
	<th>状態</th>
	<th>補足</th>
</tr>
<?php
	$c = array();
	$i = 0;
	$c[$i] = array(
		'name' => 'Rewrite Base',
		'desc' => '/.htaccessを開き、RewriteBaseをURLに合わせて修正する必要があります。'
	);
	$c[$i++]['ret'] = 'チェック不可';

	$c[$i] = array(
		'name' => 'DATAディレクトリ',
		'desc' => DATA.'ディレクトリに、書き込み権限を与えてください。'
	);
	$c[$i++]['ret'] = is_writable(DATA);

	$c[$i] = array(
		'name' => 'SESSIONディレクトリ',
		'desc' => SESSION.'ディレクトリに、書き込み権限を与えてください。'
	);
	$c[$i++]['ret'] = is_writable(SESSION);

	if (ENABLE_IMG_UPLOAD) {
		$c[$i] = array(
			'name' => 'IMGディレクトリ',
			'desc' => '画像アップロード機能を使う場合、imgディレクトリに書き込み権限を与えてください。'
		);
		$c[$i++]['ret'] = is_writable(IMG);
	}

	$c[$i] = array(
		'name' => 'LAYOUTSディレクトリ',
		'desc' => '必須ではありませんが、書き込み権限を与えないと管理機能の「ボックス配置」が動作しません。'
	);
	$c[$i++]['ret'] = is_writable(LAYOUTS);

	$c[$i] = array(
		'name' => 'boxディレクトリ',
		'desc' => '必須ではありませんが、書き込み権限を与えないと管理機能の「ボックス管理」が動作しません。'
	);
	$c[$i++]['ret'] = is_writable(PAGES.'box');

	$c[$i] = array(
		'name' => 'BASE_URL',
		'desc' => 'config.inc.phpで、正しいサーバのURLを設定してください。'
	);
	$c[$i++]['ret'] = BASE_URL. ' ('._url(BASE_URL).')';

	$c[$i] = array(
		'name' => 'TIMEZONE',
		'desc' => 'config.inc.phpを設定してください。日本ならAsia/Tokyoになります。'
	);
	$c[$i++]['ret'] = TIMEZONE;

	$c[$i] = array(
		'name' => 'BULLET_SECRET_KEY',
		'desc' => 'config.inc.phpで適当な値を入力して下さい。'
	);
	$c[$i++]['ret'] = BULLET_SECRET_KEY ? TRUE : FALSE;

	$c[$i] = array(
		'name' => 'BULLET_USER_SECRET_KEY',
		'desc' => 'config.inc.phpで適当な値を入力して下さい。'
	);
	$c[$i++]['ret'] = BULLET_USER_SECRET_KEY ? TRUE : FALSE;

	$c[$i] = array(
		'name' => 'BULLET_TRIP_SECRET_KEY',
		'desc' => 'config.inc.phpで適当な値を入力して下さい。'
	);
	$c[$i++]['ret'] = BULLET_TRIP_SECRET_KEY ? TRUE : FALSE;

	$c[$i] = array(
		'name' => 'TABLE_PREFIX',
		'desc' => '作成するテーブルにプリフィックスをつける場合、config.inc.phpで設定してください。'
	);
	$c[$i++]['ret'] = TABLE_PREFIX;

	$c[$i] = array(
		'name' => 'LOGIN_MENU',
		'desc' => 'ヘッダにログインメニューを表示するかどうかです。不要の場合config.inc.phpをFALSEにしてください。'
	);
	$c[$i++]['ret'] = LOGIN_MENU ? '表示' : '非表示';

	include LIB.'db.inc.php';
	$c[$i] = array(
		'name' => 'DB接続',
		'desc' => 'config.inc.phpのDB_USER, DB_PASSなどの情報を正しく設定してください。'
	);
	$c[$i++]['ret'] = empty($db->_d) ? FALSE : TRUE;

	include dirname(__FILE__).'/doc/tables.inc.php';
	$has_table_error = FALSE;
	foreach ($tables as $table) {
		$c[$i] = array(
			'name' => $table,
			'desc' => $table.'テーブルの存在チェックをしています。'
		);
		if (! empty($db->_d)) {
			$tmp = $db->hasTable($table);
			if ($tmp === FALSE)
				$has_table_error = TRUE;
			$c[$i++]['ret'] = $tmp;
		} else {
			$c[$i++]['ret'] = FALSE;
			$has_table_error = TRUE;
		}
	}

	$c[$i] = array(
		'name' => 'adminユーザ',
		'desc' => '管理機能を使う場合、初期adminユーザが一人は必要です。'
	);
	if (! empty($db->_d)) {
		$user = $db->selectRow('users', NULL, array('user_type_id' => 1));
		$c[$i++]['ret'] = $user ? $user['login_id'] : FALSE;
	} else {
		$c[$i++]['ret'] = FALSE;
	}

	foreach ($c as $r) {
		echo '<tr>';
		echo '<th>'.h($r['name']).'</th>';
		if (is_bool($r['ret'])) {
			if ($r['ret']) {
				echo '<td>OK</td>';
			} else {
				echo '<td class="error">不可</td>';
			}
		} else {
			echo '<td>'.h($r['ret']).'</td>';
		}
		echo '<td class="desc">'.h($r['desc']).'</td>';
		echo '</tr>';
	}
?>
</tbody></table>

<?php
	if ($has_table_error && ! empty($db->_d)) {
?>
		<form method="post">
			<div align="center">
				<input type="submit" value="テーブル作成" name="do_table" />
			</div>
		</form>
<?php
	}

	if (empty($user) && ! empty($db->_d)) {
?>
		<form method="post">
			<h3>管理ユーザを作成する</h3>
			<table><tbody>
				<tr>
					<th>
						表示名
					</th>
					<td>
						<input type="text" name="display_name" value="" />
					</td>
				</tr>
				<tr>
					<th>
						ログインID
					</th>
					<td>
						<input type="text" name="login_id" value="" />
					</td>
				</tr>
				<tr>
					<th>
						パスワード
					</th>
					<td>
						<input type="password" name="password" value="" />
					</td>
				</tr>
			</tbody></table>
			<div align="center">
				<input type="submit" value="登録" name="do" />
			</div>
		</form>
<?php
	}
?>

<div>
	<p>最後に、必ずこのファイルを手動で削除してください。</p>
</div>

<?php
include LAYOUTS.'footer.inc.php';
?>