<?php
// $Id: class.bytesmailer.php,v 1.4 2003/02/02 08:42:13 haruki Exp $
//
// bytesmailer - enhanced PHP email transport class
//  that can handle non ascii charactors properly.
// Copyright (C) Haruki Setoyama <haruki@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
/**
 * bytesmailer - enhanced PHP email transport class.
 *
 * This class can handle non ascii charactors properly.
 * Partly based on phpmailer 1.62 (author: Brent R. Matzelle) http://phpmailer.sourceforge.net/,
 * and other open source scripts.
 * See comments.
 *
 * @license LGPL, see LICENSE
 * @author Haruki Setoyama <haruki@planewave.org>
 * @package bytesmailer
 * @version 0.1
 */
/**
 * define.
 */
define('_BYTESMAILER_LE', "\r\n");
define('_BYTESMAILER_FWS', _BYTESMAILER_LE.' ');
define('_BYTESMAILER_MAX_LINE_LENGTH', 998); // 998
if(! defined('_BYTESMAILER_DIR')) define('_BYTESMAILER_DIR', dirname(__FILE__).'/');
if(! defined('_BYTESMAILER_DEBUG')) define('_BYTESMAILER_DEBUG', 0);
define('_BYTESMAILER_VERSION', '0.1');

/**
 * include classes.
 */
include_once _BYTESMAILER_DIR.'class/class.mailheader.php';
include_once _BYTESMAILER_DIR.'class/class.mailbody.php';
include_once _BYTESMAILER_DIR.'class/class.sender.php';

/**
 * bytesmailer - enhanced PHP email transport class.
 * @access public
 */
class bytesmailer {

    /**
     * mail header and body class
     * @access public
     */
    var $header;
    var $body;

    /**
     * method to send the mail
     * @access public
     */
    var $sender;

    /**
     * object of main message part. multipart/altanative.
     * @access public
     */
    var $message;

    /**
     * error message.
     * @access public
     */
    var $error;

    /**
     * constructor
     * @access public
     */
    function bytesmailer(){
        $this->header = new mailheader;
        $this->body =new mailbody(true);
        // default settings
        $this->setCharacterEncoding('UTF-8');
        $this->setSendMethod('mail');
    }

    /**
     * singleton.
     * This method shuild use only to initialize.
     * @access public
     */
    function &getInstance(){
        static $obj;
        if(! isset($obj)) $obj = new bytesmailer();
        return $obj;
    }

    /**
     * get new instance
     * @access public
     */
    function newInstance(){
        $obj = bytesmailer::getInstance();
        //$obj->setData('');
        return $obj;
    }

    /**
     * initialize character encoding to use.
     * @access public
     */
    function initCharacterEncoding($internal_encoding, $mail_encoding=''){
        $obj =& bytesmailer::getInstance();
        return $obj->setCharacterEncoding($internal_encoding, $mail_encoding);
    }

    /**
     * initialize method to send mail.
     * @access public
     */
    function initSendMethod($type, $param=''){
        $obj =& bytesmailer::getInstance();
        return $obj->setSendMethod($type, $param);
    }

    /**
     * transfar mail.
     * @access public
     */
    function send() {
        return $this->sender->send($this->header, $this->body);
    }

    ///// setter

    /**
     * set character encodig for mail.
     * use like bytesmailer::initCharacterEncoding('EUC-JP','ISO-2022-JP');
     * befor you get instance of this class
     * @access public
     */
    function setCharacterEncoding($internal_encoding, $mail_encoding=''){
        $text_simple =& bm_text_simple::getInstance();
        $text_simple->setCharacterEncoding($internal_encoding);
        $text_mail =& bm_text_mail::getInstance();
        if($mail_encoding != ''){
            $text_mail->setCharacterEncoding($mail_encoding);
            $text_mail->setOriginalCharacterEncoding($internal_encoding);
        }else{
            $text_mail->setCharacterEncoding($internal_encoding);
        }
        return true;
    }

    /**
     * set the way to send mail.
     * use like bytesmailer::setSendMethod('smtp', 'localhost');
     * befor you get instance of this class
     * @access public
     */
    function setSendMethod($type, $param=''){
        $class_name = 'bm_sender_'.strtolower($type);
        if(! class_exists($class_name)) {
            $this->_set_error('fali to setSendMethod.');
            return false;
        }
        $this->sender = new $class_name($param);
        return true;
    }

    /**
     * add mail address to 'to' 'cc' etc.
     * @access public
     * @return object   address class. see class.address.php
     */
    function &addAddress($addrspec, $displayname='', $type='to'){
        static $allowed_type = array(   'to' => 'to',
                                        'cc' => 'cc',
                                        'bcc' => 'bcc',
                                        'from' => 'from',
                                        'sender' => 'sender',
                                        'replyto' => 'replyTo',
                                        'reply' => 'replyTo',
                                        'confirmreadingto' =>'confirmReadingTo',
                                        'confirm' =>'confirmReadingTo');

        $type = strtolower($type);
        if(! isset($allowed_type[$type])) return false;
        return $this->header->$allowed_type[$type]->addAddress($addrspec, $displayname);
    }

    /**
     * add mail group to 'to' 'cc' etc.
     * @access public
     * @return object   group class. see class.address.php
     */
    function &addGroup($name, $type='to'){
        static $allowed_type = array(   'to' => 'to',
                                        'cc' => 'cc',
                                        'bcc' => 'bcc',
                                        'replyto' => 'replyTo',
                                        'reply' => 'replyTo');
        $type = strtolower($type);
        if(! isset($allowed_type[$type])) return false;
        return $this->header->$allowed_type[$type]->addGroup($name);
    }

    /**
     * set subject string
     * @access public
     * @return object  bm_text_mail class.
     */
    function &setSubject($text){
        $this->header->subject->setData($text);
    }

    /**
     * add mail content
     * @access public
     */
    function &addContent($data, $type='', $subtype='') {
        return $this->body->addContent($data, $type='', $subtype='');
    }

    /**
     * add plane text mail message
     * @access public
     */
    function &addTextMessage($text, $charset='') {
        if(! isset($this->message)) {
            $this->message =& $this->body->addAlternativePart();
        }
        if($charset == ''){
            return $this->message->addContent($text, 'text', 'plain');
        }else{
            $data = bm_text_simple::getBlankInstance();
            $data->setCharacterEncoding($charset);
            $data->setData($text);
            return $this->message->addContent($data, 'text', 'plain');
        }
    }

    /**
     * add text/html mail message
     * @access public
     */
    function &addHtmlMessage($text, $charset='') {
        if(! isset($this->message)) {
            $this->message =& $this->body->addAlternativePart();
        }
        return $this->message->addHtmlMessage($text, $charset);
    }

    /**
     * add text/html mail message from file
     * @access public
     */
    function &addHtmlMessageFromFile($path, $charset='') {
        if(! isset($this->message)) {
            $this->message =& $this->body->addAlternativePart();
        }
        return  $this->message->addHtmlMessageFromFile($path, $charset);
    }

    /**
     * add attachment
     * @access public
     */
    function &addAttachment($data, $filename, $type, $subtype) {
        return $this->body->addAttachment($data, $filename, $type, $subtype);
    }

    /**
     * add attachment from file
     * @access public
     */
    function &addAttachmentFromFile($path, $filename='') {
        return $this->body->addAttachmentFromFile($path, $filename);
    }

    ///// private functions

    function _set_error($msg){
        $this->error[] = $msg;
        if(_BYTESMAILER_DEBUG){
            echo ' <b>bytesmailer error</b>: '.$msg.'<br />';
        }
    }
}
?>