<?php
/**
 * classe for mail address.
 *
 * This is a part of bytesmailer.
 * @package bytesmailer
 * @version $Id: class.address.php,v 1.2 2003/01/24 13:03:31 haruki Exp $
 * @author	Haruki Setoyama <haruki@planewave.org>
 */
/*
* include bm_mail_text class
*/
include_once 'class.text.mail.php';
/*
* template of other address handle classes.
* ex. nameaddr , nulladdr and mailbox class.
*/
class address{

    function address(){
    }

    /**
     * get address-objects that this object holds.
     * @return array array of objects
     */
    function getContentObjs(){}

    /**
     * return the number of Addresses whitch this object holds)
     * @return int
     */
    function countAddress(){}

    /**
     * return encoded string
     * @return string
     */
    function getStringForHeader(){}

    /**
     * return array of addr-spec style (like hoge@hoge.com) address
     * @return array
     */
    function getAddrspec(){
	}
}

/**
 * nameaddr - name-addr class. see RFC2822.
 * @access public
 */
class nameaddr extends address{

    var $addrspec = '';
    var $displayname;

    /**
     * Constructor
     */
    function nameaddr(){
        $this->addrspec = '';
        $this->displayname = bm_text_mail::getBlankInstance();
    }

    /**
     * sets Name-addr.
     * @access public
     * @param string $addrspec   hoge@hege.com style mail address
     * @param string $displayname
     * @param bool $multibyte   if displayname is multibyte
     * @return bool
     */
    function &setAddress($addrspec, $displayname=''){
        $atext = '[\043-\047\052\053\055\057\060-\071\075\077\101-\132\136-\176]';

        if(preg_match('/^'.$atext.'+(\.'.$atext.'+)*@'.$atext.'+(\.'.$atext.'+)*$/',$addrspec)){
            $this->addrspec = $addrspec;
            $this->displayname = bm_text_mail::getBlankInstance();
            $this->displayname->setData($displayname);
            return $this;
        }else{
            return false;
        }
    }

    // alias
    function &addAddress($addrspec, $displayname=''){
        return $this->setAddress($addrspec, $displayname);
    }

    /**
     * get nameaddr object.
     * @access public
     * @return array
     */
    function getContentObjs(){
        return $this;
    }

    /**
     * get number of nameaddr this object holds.
     * @access public
     * @return int
     */
    function countAddress(){
        return ($this->addrspec != '') ? 1: 0;
    }

    /**
     * get encoded string.
     * @access public
     * @param object $encoder   encoder to =?charaset?B?hoge= style
     * @return string
     */
    function getStringForHeader(){
        /*
        if(strlen($this->addrspec) > 77){
            $tmp = explode('@', $this->addrspec);
            if(strlen($tmp[1]) > 77) {
                $tmp[1] = implode('.'._BYTESMAILER_FWS, explode('.', $tmp[1]));
            }
            $this->addrspec = implode('@'._BYTESMAILER_FWS,$tmp);
        }
        */
        if($this->displayname->getData() == ''){
            $str = trim($this->addrspec);
        }else{
            $str = $this->displayname->getEncodedForHeader();
            $str = $str.' <'.$this->addrspec.'>';
        }
        return $str;
        //return wordwrap($str, 78, _BYTESMAILER_FWS);
    }

    function getAddrspec(){
        return array($this->addrspec);
    }
}

/**
 * mailboxlist - mailbox-list class. Nameaddr class can be added.
 * @access public
 */
class mailboxlist extends address{

    var $contents = array();
    //var $mailText;

    function mailboxlist(){
        $this->address();
    }

    /**
     * add Nameaddr class.
     * @access public
     * @param object $obj  nameaddr to be added.
     * @return string
     */
    function &add($obj){
        switch(get_class($obj)) {
        case 'nameaddr':
            array_push($this->contents, $obj);
            return true;
        case 'mailboxlist':
            array_push($this->contents, $obj->getContentObjs());
            return true;
        default:
            return false;
		}
    }

    /**
     * add Nameaddr. This is easy way.
     * @access public
     * @return bool
     */
    function &addAddress($addrspec, $displayname=''){
        $obj = new nameaddr();
        if($obj->setAddress($addrspec, $displayname)){
            $num = count($this->contents);
            $this->contents[$num] = $obj;
            return $this->contents[$num];
        }else{
            return false;
        }
    }

    /**
     * get nameaddr array.
     * @access public
     * @return array
     */
    function getContentObjs(){
        return $this->contents;
    }

    /**
     * get number of nameaddr this object holds.
     * @access public
     * @return int
     */
    function countAddress(){
        $num = 0;
        foreach($this->contents as $obj){
            $num += $obj->countAddress();
        }
        return $num;
    }

    /**
     * get encoded string.
     * @access public
     * @param object $encoder   encoder to =?charaset?B?hoge= style
     * @return string
     */
    function getStringForHeader(){
        foreach($this->contents as $content) {
            $ret[] = $content->getStringForHeader();
        }
        return implode(','._BYTESMAILER_FWS, $ret);
    }

    function getAddrspec(){
        $ret = array();
        foreach($this->contents as $content) {
            $ret = array_merge($ret, $content->getAddrspec());
        }
        return $ret;
    }
}

/**
 * addresslist - address-list class. Nameaddr class and addressgroup class can be added.
 * @access public
 */
class addresslist extends mailboxlist{

    function addresslist(){
        $this->mailboxlist();
    }

    /**
     * add nameaddr class or addressgroup class.
     * @access public
     * @param object (nameaddr,mailboxlist,addressgroup) to be added.
     * @return string
     */
    function &add($obj){
        switch(get_class($obj)){
        case 'nameaddr':
        case 'addressgroup':
            array_push($this->contents, $obj);
            return true;
        case 'mailboxlist':
        case 'addresslist':
            array_push($this->contents, $obj->getContentObjs());
            return true;
        default:
            return false;
		}
    }

    function &addGroup($name=''){
        $obj = new addressgroup();
        $obj->setName($name);
        $num = count($this->contents);
        $this->contents[$num] = $obj;
        return $this->contents[$num];
    }
}

/**
 * addressgroup - group of name-addr class.
 * @access public
 */
class addressgroup extends mailboxlist{

    var $name;

    function addressgroup(){
        $this->mailboxlist();
        $this->name = bm_text_mail::getBlankInstance();
    }
    /**
     * sets name of group
     * @access public
     * @param string $name
     * @return bool
     */
    function setName($name){
        //$this->name = encodableHeader::factory($this->mailText);
        $this->name = bm_text_mail::getBlankInstance();
        $this->name->setData($name);
    }

    /**
     * get name of this group.
     * @access public
     * @return string
     */
    function getName(){
        return $this->name->getData();
    }

    /**
     * get encoded string.
     * @access public
     * @param object $encoder   encoder to =?charaset?B?hoge= style
     * @return string
     */
    function getStringForHeader(){
        foreach($this->contents as $content) {
            $ret[] = $content->getStringForHeader();
        }
        return $this->name->getEncodedForHeader().' :'._BYTESMAILER_FWS.implode(','._BYTESMAILER_FWS, $ret).' ;';
    }
}
?>