<?php
/**
 * distinction of the Mime type of file.
 *
 * @package bytesmailer
 * @version $Id: class.filemimetype.php,v 1.1 2003/01/21 14:17:56 haruki Exp $
 * @author  Haruki Setoyama <haruki@planewave.org>
 */
/**
 * distinction of the Mime type of file.
 *
 * @access public
 */
class fileMimetype {

    var $mimetypes;

    function getMimeType($path){
        $atom = explode('.', basename($path));
        $ext = $atom[count($atom)-1];
        if(count($atom) >1 && isset($this->mimetypes[$ext]))
            return explode('/', $this->mimetypes[$ext]);
        else
            return array('application','octet-stream');
    }

    function &getInstance(){
        static $inst;
        if(! isset($inst)) $inst = new fileMimetype;
        return $inst;
    }

    /**
     * constructor
     */
    function fileMimetype() {
        $this->mimetypes = array(
            '123'   => 'application/vnd.lotus-1-2-3',
            '3gp'   => 'video/3gpp',
            'aab'   => 'application/x-authoware-bin',
            'aam'   => 'application/x-authoware-map',
            'aas'   => 'application/x-authoware-seg',
            'ai'    => 'application/postscript',
            'aif'   => 'audio/x-aiff',
            'aifc'  => 'audio/x-aiff',
            'aiff'  => 'audio/x-aiff',
            'akd'   => 'application/x-Koan',
            'akt'   => 'application/x-Koan',
            'als'   => 'audio/X-Alpha5',
            'amc'   => 'application/x-mpeg',
            'asc'   => 'text/plain',
            'asd'   => 'application/astound',
            'asd'   => 'application/astound',
            'asf'   => 'video/x-ms-asf',
            'asn'   => 'application/astound',
            'asp'   => 'application/x-asap',
            'asx'   => 'video/x-ms-asf',
            'au'    => 'audio/basic',
            'avi'   => 'video/x-msvideo',
            'bcpio' => 'application/x-bcpio',
            'bin'   => 'application/octet-stream',
            'bld'   => 'application/bld',
            'bld2'  => 'application/bld2',
            'bmp'   => 'image/bmp',
            'bz2'   => 'application/x-bzip2',
            'cal'   => 'image/x-cals',
            'ccn'   => 'application/x-cnc',
            'cco'   => 'application/x-cocoa',
            'cdf'   => 'application/x-netcdf',
            'cgi'   => 'magnus-internal/cgi',
            'class' => 'application/octet-stream',
            'clp'   => 'application/x-msclip',
            'cmx'   => 'application/x-cmx',
            'co'    => 'application/x-cult3d-object',
            'cod'   => 'image/cis-cod',
            'cpio'  => 'application/x-cpio',
            'cpt'   => 'application/mac-compactpro',
            'crd'   => 'application/x-mscardfile',
            'csh'   => 'application/x-csh',
            'csm'   => 'chemical/x-csml',
            'csml'  => 'chemical/x-csml',
            'css'   => 'text/css',
            'dcm'   => 'x-lml/x-evm',
            'dcr'   => 'application/x-director',
            'dcx'   => 'image/x-dcx',
            'dir'   => 'application/x-director',
            'djv'   => 'image/vnd.djvu',
            'djvu'  => 'image/vnd.djvu',
            'dll'   => 'application/octet-stream',
            'dms'   => 'application/octet-stream',
            'doc'   => 'application/msword',
            'doc'   => 'application/msword',
            'dot'   => 'application/x-dot',
            'dvi'   => 'application/x-dvi',
            'dwf'   => 'drawing/x-dwf',
            'dwg'   => 'image/vnd',
            'dxf'   => 'image/x-dxf',
            'dxr'   => 'application/x-director',
            'ebk'   => 'application/x-expandedbook',
            'emb'   => 'chemical/x-embl-dl-nucleotide',
            'embl'  => 'chemical/x-embl-dl-nucleotide',
            'eps'   => 'application/postscript',
            'eri'   => 'image/x-eri',
            'es'    => 'audio/echospeech',
            'esl'   => 'audio/echospeech',
            'etc'   => 'application/x-earthtime',
            'etx'   => 'text/x-setext',
            'evm'   => 'x-lml/x-evm',
            'evy'   => 'application/x-envoy',
            'exe'   => 'application/octet-stream',
            'ez'    => 'application/andrew-inset',
            'fh4'   => 'image/x-freehand',
            'fh5'   => 'image/x-freehand',
            'fhc'   => 'image/x-freehand',
            'fif'   => 'image/fif',
            'fm'    => 'application/x-maker',
            'fpx'   => 'image/x-fpx',
            'fvi'   => 'video/isivideo',
            'gau'   => 'chemical/x-gaussian-input',
            'gca'   => 'application/x-gca-compressed',
            'gdb'   => 'x-lml/x-gdb',
            'gif'   => 'image/gif',
            'gps'   => 'application/x-gps',
            'gtar'  => 'application/x-gtar',
            'gz'    => 'application/x-gzip',
            'hdf'   => 'application/x-hdf',
            'hdm'   => 'text/x-hdml',
            'hdml'  => 'text/x-hdml',
            'hlp'   => 'application/winhlp',
            'hqx'   => 'application/mac-binhex40',
            'htm'   => 'text/html',
            'html'  => 'text/html',
            'ice'   => 'x-conference/x-cooltalk',
            'ico'   => 'image/x-icon',
            'ief'   => 'image/ief',
            'ief'   => 'image/ief',
            'ifs'   => 'image/ifs',
            'iges'  => 'model/iges',
            'igs'   => 'model/iges',
            'imy'   => 'audio/x-imy',
            'ins'   => 'application/x-NET-Install',
            'ipx'   => 'application/x-ipix',
            'it'    => 'audio/x-mod',
            'itz'   => 'audio/x-mod',
            'ivr'   => 'i-world/i-vrml',
            'j2k'   => 'image/j2k',
            'jad'   => 'text/vnd.sun.j2me.app-descriptor',
            'jam'   => 'application/x-jam',
            'jar'   => 'application/java-archive',
            'jnlp'  => 'application/x-java-jnlp-file',
            'jpe'   => 'image/jpeg',
            'jpeg'  => 'image/jpeg',
            'jpg'   => 'image/jpeg',
            'jpz'   => 'image/jpeg',
            'js'    => 'application/x-javascript',
            'jwc'   => 'application/jwc',
            'kar'   => 'audio/midi',
            'lak'   => 'x-lml/x-lak',
            'latex' => 'application/x-latex',
            'lcc'   => 'application/fastman',
            'lcl'   => 'application/x-digitalloca',
            'lcr'   => 'application/x-digitalloca',
            'lgh'   => 'application/lgh',
            'lha'   => 'application/octet-stream',
            'lml'   => 'x-lml/x-lml',
            'lmlpack'   => 'x-lml/x-lmlpack',
            'lsf'   => 'video/x-ms-asf',
            'lsx'   => 'video/x-ms-asf',
            'lzh'   => 'application/octet-stream',
            'lzh'   => 'application/x-lzh',
            'm13'   => 'application/x-msmediaview',
            'm14'   => 'application/x-msmediaview',
            'm3u'   => 'audio/x-mpegurl',
            'man'   => 'application/x-troff-man',
            'map'   => 'magnus-internal/imagemap',
            'mbd'   => 'application/mbedlet',
            'mct'   => 'application/x-mascot',
            'mdb'   => 'application/x-msaccess',
            'mdz'   => 'audio/x-mod',
            'me'    => 'application/x-troff-me',
            'mesh'  => 'model/mesh',
            'mg'    => 'video/mpeg',
            'mi'    => 'application/x-mif',
            'mid'   => 'audio/midi',
            'midi'  => 'audio/midi',
            'mif'   => 'application/x-mif',
            'mil'   => 'image/x-cals',
            'mio'   => 'audio/x-mio',
            'mmf'   => 'application/x-smaf',
            'mng'   => 'video/x-mng',
            'mny'   => 'application/x-msmoney',
            'moc'   => 'application/x-mocha',
            'mocha' => 'application/x-mocha',
            'mod'   => 'audio/x-mod',
            'mof'   => 'application/x-yumekara',
            'mol'   => 'chemical/x-mdl-molfile',
            'mop'   => 'chemical/x-mopac-input',
            'mov'   => 'video/quicktime',
            'movie' => 'video/x-sgi-movie',
            'mp2'   => 'audio/x-mpeg',
            'mp3'   => 'audio/x-mpeg',
            'mp4'   => 'video/x-pv-mp4',
            'mpe'   => 'video/mpeg',
            'mpeg'  => 'video/mpeg',
            'mpg'   => 'video/mpeg',
            'mpga'  => 'audio/mpeg',
            'mpp'   => 'application/vnd.ms-project',
            'mps'   => 'application/x-mapserver',
            'mrl'   => 'text/x-mrml',
            'mrm'   => 'application/x-mrm',
            'ms'    => 'application/x-troff-ms',
            'msh'   => 'model/mesh',
            'mts'   => 'application/metastream',
            'mxu'   => 'video/vnd.mpegurl',
            'nar'   => 'application/zip',
            'nc'    => 'application/x-netcdf',
            'ndb'   => 'x-lml/x-ndb',
            'nif'   => 'application/x-nif',
            'nmz'   => 'application/x-scream',
            'npx'   => 'application/x-netfpx',
            'nva'   => 'application/x-neva1',
            'oda'   => 'application/oda',
            'oom'   => 'application/x-AtlasMate-Plugin',
            'pac'   => 'audio/x-pac',
            'pae'   => 'audio/x-epac',
            'pan'   => 'application/x-pan',
            'pbm'   => 'image/x-portable-bitmap',
            'pcx'   => 'image/x-pcx',
            'pda'   => 'image/x-pda',
            'pdb'   => 'chemical/x-pdb',
            'pdf'   => 'application/pdf',
            'pfr'   => 'application/font-tdpfr',
            'pgm'   => 'image/x-portable-graymap',
            'pgn'   => 'application/x-chess-pgn',
            'pict'  => 'image/x-pict',
            'pm'    => 'application/x-perl',
            'pmd'   => 'application/x-pmd',
            'png'   => 'image/png',
            'pnm'   => 'image/x-portable-anymap',
            'pnz'   => 'image/png',
            'pot'   => 'application/vnd.ms-powerpoint',
            'ppm'   => 'image/x-portable-pixmap',
            'pps'   => 'application/vnd.ms-powerpoint',
            'ppt'   => 'application/vnd.ms-powerpoint',
            'pqf'   => 'application/x-cprplayer',
            'pqi'   => 'application/cprplayer',
            'prc'   => 'application/x-prc',
            'proxy' => 'application/x-ns-proxy-autoconfig',
            'ps'    => 'application/postscript',
            'ptlk'  => 'application/listenup',
            'pub'   => 'application/x-mspublisher',
            'pvx'   => 'video/x-pv-pvx',
            'qcp'   => 'audio/vnd.qcelp',
            'qt'    => 'video/quicktime',
            'qti'   => 'image/x-quicktime',
            'qtif'  => 'image/x-quicktime',
            'r3t'   => 'text/vnd.rn-realtext3d',
            'ra'    => 'audio/x-realaudio',
            'ram'   => 'audio/x-pn-realaudio',
            'ras'   => 'image/x-cmu-raster',
            'rf'    => 'image/vnd.rn-realflash',
            'rgb'   => 'image/x-rgb',
            'rlf'   => 'application/x-richlink',
            'rm'    => 'audio/x-pn-realaudio',
            'rnx'   => 'application/vnd.rn-realplayer',
            'roff' => 'application/x-troff',
            'rp'    => 'image/vnd.rn-realpix',
            'rpm'   => 'audio/x-pn-realaudio-plugin',
            'rt'    => 'text/vnd.rn-realtext',
            'rte'   => 'x-lml/x-gps',
            'rtf'   => 'text/rtf',
            'rtg'   => 'application/metastream',
            'rtx'   => 'text/richtext',
            'rv'    => 'video/vnd.rn-realvideo',
            'rwc'   => 'application/x-rogerwilco',
            's3m'   => 'audio/x-mod',
            's3z'   => 'audio/x-mod',
            'sca'   => 'application/x-supercard',
            'scd'   => 'application/x-msschedule',
            'sdf'   => 'application/e-score',
            'sea'   => 'application/x-stuffit',
            'sgm'   => 'text/sgml',
            'sgml'  => 'text/sgml',
            'sh'    => 'application/x-sh',
            'shar'  => 'application/x-shar',
            'shtml' => 'magnus-internal/parsed-html',
            'shw'   => 'application/presentations',
            'silo'  => 'model/mesh',
            'sit'   => 'application/x-stuffit',
            'sit'   => 'application/x-stuffit',
            'skd'   => 'application/x-koan',
            'skm'   => 'application/x-koan',
            'skp'   => 'application/x-koan',
            'skt'   => 'application/x-koan',
            'slc'   => 'application/x-salsa',
            'smd'   => 'audio/x-smd',
            'smi'   => 'application/smil',
            'smil'  => 'application/smil',
            'smp'   => 'application/studiom',
            'smz'   => 'audio/x-smd',
            'snd'   => 'audio/basic',
            'so'    => 'application/octet-stream',
            'spc'   => 'text/x-speech',
            'spl'   => 'application/x-futuresplash',
            'spr'   => 'application/x-sprite',
            'sprite' => 'application/x-sprite',
            'spt'   => 'application/x-spt',
            'src'   => 'application/x-wais-source',
            'ssm'   => 'application/streamingmedia',
            'sv4cpio'   => 'application/x-sv4cpio',
            'sv4crc'    => 'application/x-sv4crc',
            'svf'   => 'image/vnd',
            'svg'   => 'image/svg-xml',
            'svh'   => 'image/svh',
            'svr'   => 'x-world/x-svr',
            'swf'   => 'application/x-shockwave-flash',
            'swfl'  => 'application/x-shockwave-flash',
            't'     => 'application/x-troff',
            'talk'  => 'text/x-speech',
            'tar'   => 'application/x-tar',
            'taz'   => 'application/x-tar',
            'tbp'   => 'application/x-timbuktu',
            'tbt'   => 'application/timbuktu',
            'tcl'   => 'application/x-tcl',
            'tex'   => 'application/x-tex',
            'texi'  => 'application/x-texinfo',
            'texinfo'   => 'application/x-texinfo',
            'tgz'   => 'application/x-tar',
            'tif'   => 'image/tiff',
            'tiff'  => 'image/tiff',
            'tki'   => 'application/x-tkined',
            'tkined'    => 'application/x-tkined',
            'toc'   => 'application/toc',
            'tr'    => 'application/x-troff',
            'trk'   => 'x-lml/x-gps',
            'trm'   => 'application/x-msterminal',
            'tsi'   => 'audio/tsplayer',
            'tsv'   => 'text/tab-seperated-values',
            'ttz'   => 'application/t-time',
            'txt'   => 'text/plain',
            'ustar' => 'application/x-ustar',
            'uu'    => 'x-uuencode',
            'uue'   => 'x-uuencode',
            'vcd'   => 'application/x-cdlink',
            'vcf'   => 'text/x-vcard',
            'vdo'   => 'video/vdo',
            'viv'   => 'video/vivo',
            'vivo'  => 'video/vivo',
            'vmi'   => 'application/x-dremacast-vms-info',
            'vms'   => 'application/x-dremacast-vms',
            'vox'   => 'audio/voxware',
            'vqe'   => 'audio/x-twinvq-plugin',
            'vqf'   => 'audio/x-twinvq',
            'vql'   => 'audio/x-twinvq',
            'vre'   => 'x-world/x-vream',
            'vrml'  => 'model/vrml',
            'vrt'   => 'x-world/x-vrt',
            'vrw'   => 'x-world/x-vream',
            'vts'   => 'workbook/formulaone',
            'wav'   => 'audio/x-wav',
            'wax'   => 'audio/x-ms-wax',
            'wbmp'  => 'image/vnd.wap.wbmp',
            'wbxml' => 'application/vnd.wap.wbxml',
            'wi'    => 'image/wavelet',
            'wm'    => 'video/x-ms-asf',
            'wma'   => 'audio/x-ms-wma',
            'wmf'   => 'application/x-msmetafile',
            'wml'   => 'text/vnd.wap.wml',
            'wmlc'  => 'application/vnd.wap.wmlc',
            'wmls'  => 'text/vnd.wap.wmlscript',
            'wmlsc' => 'application/vnd.wap.wmlscriptc',
            'wmv'   => 'video/x-ms-wmv',
            'wmx'   => 'video/x-ms-wmx',
            'wpng'  => 'image/x-up-wpng',
            'wpt'   => 'x-lml/x-gps',
            'wrl'   => 'model/vrml',
            'wrz'   => 'x-world/x-vrml',
            'wv'    => 'video/wavelet',
            'wvx'   => 'video/x-ms-wvx',
            'wxl'   => 'application/x-wxl',
            'xbm'   => 'image/x-xbitmap',
            'xdm'   => 'application/x-xdma',
            'xdma'  => 'application/x-xdma',
            'xdw'   => 'application/vnd.fujixerox.docuworks',
            'xht'   => 'application/xhtml+xml',
            'xhtml' => 'application/xhtml+xml',
            'xlc'   => 'application/x-excel',
            'xll'   => 'application/x-excel',
            'xlm'   => 'application/x-excel',
            'xls'   => 'application/x-excel',
            'xlt'   => 'application/x-excel',
            'xlw'   => 'application/x-excel',
            'xm'    => 'audio/x-mod',
            'xml'   => 'text/xml',
            'xmz'   => 'audio/x-mod',
            'xpi'   => 'application/x-xpinstall',
            'xpm'   => 'image/x-xpixmap',
            'xsl'   => 'text/xml',
            'xul'   => 'text/xul',
            'xwd'   => 'image/x-windowdump',
            'xyz'   => 'chemical/x-xyz',
            'yz1'   => 'application/x-yz1',
            'z'     => 'application/x-compress',
            'zac'   => 'application/x-zaurus-zac',
            'zip'   => 'application/zip',
         );
    }
}

?>