<?php
include 'class.filemimetype.php';
/**
 * data handling classes for mail body.
 *
 * See RFC2822
 * @package bytesmailer
 * @version $Id: class.mailbody.discrete.php,v 1.2 2003/01/24 13:03:31 haruki Exp $
 * @author  Haruki Setoyama <haruki@planewave.org>
 */
/**
 * mailBodyAbstract
 */
class mailBody_abstract {

    var $error;

    function mailBodyAbstract(){
        //
    }

    /**
     * return headers by array.
     * ex. $arr['Content-Type'] = 'text/plane; charset=us-ascii'
     *
     * @access public
     * @return array
     */
    function getHeader(){
        return array();
    }

    /**
     * return body of the mail content.
     *
     * @access public
     * @return string
     */
    function getBody(){
        return '';
    }

    /**
     * return formated messages.
     *
     * @access public
     * @return string
     */
    function getAllMessage(){
        $header = '';
        foreach($this->getHeader() as $key => $val){
            $header .= $key.': '.$val._BYTESMAILER_LE;
        }
        if($header != ''){
            return $header._BYTESMAILER_LE.$this->getBody();
        }else{
            return $this->getBody();
        }
    }
}

/**
 * content of mail. All 'Content-Type' except 'multipart' is allowed.
 *
 * @access public
 */
class mailBody_singlepart extends mailBody_abstract {

    var $data;
    var $transfer_encoding      = '';

    var $content_type           = '';
    var $content_subtype        = '';
    var $content_type_param      = array();
    var $content_language       = array();
    var $disposition_type       = '';
    var $disposition_type_param  = array();
    var $content_id             = '';
    var $custom                 = array();

    var $domain = 'bytesmailer';


    function mailBody_singlepart(){
        $this->data = bm_binary::getBlankInstance();
    }

    function getHeader(){
        $header = array();
        if($this->content_type != '' && $this->content_subtype != '') {
            $header['Content-Type'] = $this->content_type.'/'.$this->content_subtype;
            $header['Content-Type'] .= $this->_get_param_string($this->content_type_param);
        }

        if(! empty($this->content_language)) {
            $header['Content-Language'] = implode(', ',$this->content_language);
        }

        if($this->transfer_encoding != '') {
            $header['Content-Transfer-Encoding'] .= $this->transfer_encoding;
        }

        if($this->disposition_type != '') {
            $header['Content-Disposition'] .= $this->disposition_type;
            $header['Content-Disposition'] .= $this->_get_param_string($this->disposition_type_param);
        }

        if($this->content_id != '') {
            $header['Content-ID'] .= '<'.$this->content_id.'>';
        }

        array_merge($header, $this->custom);

        return $header;
    }

    function _get_param_string($arr){
        $ret = '';
        foreach($arr as $key => $val){
            $ret .=  ';'._BYTESMAILER_FWS;
            if(gettype($val) == 'object'){
                if(method_exists($val,'getEncodedForParam'))
                    $ret .= $val->getEncodedForParam($key);
            }else{
                $ret .= $key.'='.$val;
            }
        }
        return $ret;
    }

    function getBody(){
        $body = $this->data->getEncodedForBody();
        if($body != '' && substr($body, -strlen(_BYTESMAILER_LE)) != _BYTESMAILER_LE){
            $body .= _BYTESMAILER_LE;
        }
        return $body;
    }

    /////////////////////////////////////////

    function setData($data, $type, $subtype){
        if($type == 'text'){
            if(is_string($data)){
                $this->data = bm_text_mail::getBlankInstance();
                $this->data->setData($data);
            }
            elseif(is_a($data, 'bm_text_simple')){
                $this->data = $data;
            }else{
                return false;
            }
            $this->transfer_encoding = $this->data->textinfo->getEncodeTypeForBody();
            $this->content_type_param['charset'] = $this->data->textinfo->getCharacterEncoding();
            /*if(! empty($this->data->output_text_info->getLanguage())){
                $this->addLanguage($this->data->output_text_info->getLanguage());
            } */
        }else{
            $this->data = bm_binary::getBlankInstance();
            $this->data->setData($data);
            $this->transfer_encoding = 'base64';
            //$this->setDispositionType('attachment');
        }

        $this->content_type = $type;
        $this->content_subtype = $subtype;

        return true;
    }

    function setDataFromFile($path){
        if(! ($ret = $this->getDataFromFile($path))){
            return false;
        }
        list($data, $type, $subtype) = $ret;
        return $this->setData($data, $type, $subtype);
    }

    function getDataFromFile($path){
        if(!@is_file($path)){
            $this->error = sprintf("File [%s] do not exist.", $path);
            return false;
        }
        if(!@$fd = fopen($path, "rb")){
            $this->error = sprintf("Could not open file [%s]", $path);
            return false;
        }
        $data = fread($fd, filesize($path));
        fclose($fd);

        $fmt =& fileMimeType::getInstance();
        list($type,$subtype) = $fmt->getMimeType($path);
        return array($data, $type, $subtype);
    }

    /////////////////////////////////////////

    function beAttachment($filename){
        $this->setDispositionType('attachment');
        $text = bm_text_mail::getBlankInstance();
        $text->setData($filename);
        $this->addContentTypeParam('name', $text);
        $this->addDispositionTypeParam('filename', $text);
    }

    function beInline($id){
        $this->setDispositionType('inline');
        $this->content_id = $id;
    }

    /*
    content := "Content-Type" ":" type "/" subtype *(";" parameter)
        ; Matching of media type and subtype
        ; is ALWAYS case-insensitive.
    type := discrete-type / composite-type
    discrete-type := "text" / "image" / "audio" / "video" / "application" / extension-token
    composite-type := "message" / "multipart" / extension-token
    */
    function getContentType(){
        return array($this->content_type, $this->content_subtype);
    }

    function addContentTypeParam($name, $value){
        $this->content_type_param[$name] = $value;
    }

    function addContentLanguage($str){
        array_push($this->content_language, $str);
    }

    /*
    disposition := "Content-Disposition" ":" disposition-type *(";" disposition-parm)
    disposition-type := "inline" / "attachment" / extension-token
        ; values are not case-sensitive
    */
    function setDispositionType($str){
        $this->disposition_type = trim($str);
    }

    /*
    disposition-parm := filename-parm
        / creation-date-parm
        / modification-date-parm
        / read-date-parm
        / size-parm
        / parameter
    filename-parm := "filename" "=" value
    creation-date-parm := "creation-date" "=" quoted-date-time
    modification-date-parm := "modification-date" "=" quoted-date-time
    read-date-parm := "read-date" "=" quoted-date-time
    size-parm := "size" "=" 1*DIGIT
    quoted-date-time := quoted-string
        ; contents MUST be an RFC 822 `date-time'
        ; numeric timezones (+HHMM or -HHMM) MUST be used

    */
    function addDispositionTypeParam($name, $value){
        $this->disposition_type_param[$name] = $value;
    }

    function setContentId($str){
        $this->content_id = $str;
    }

    function setContentIdFromData(){
        $this->content_id = md5($this->data).'@'.$this->domain;
    }

    function addCustomHeader($name, $value){
        $this->custom = array_merge($this->custom, array($name, $value));
    }

    /*
    encoding := "Content-Transfer-Encoding" ":" mechanism
    mechanism := "7bit" / "8bit" / "binary" / "quoted-printable" / "base64" / ietf-token / x-token
    */
    function setTransferEncoding($type){
        static $allowed = array('7bit', '8bit', 'binary', 'quoted-printable', 'base64');

        if(in_array($type,$allowed))
            $this->transfer_encoding = $type;
        else
            $this->transfer_encoding = 'base64';

        return $this->transfer_encoding;
    }

}
?>