<?php
include_once 'class.mailbody.composite.php';
/**
 * class for mail body.
 *
 * This is a part of bytesmailer.
 * @package bytesmailer
 * @version $Id: class.mailbody.php,v 1.2 2003/01/24 13:03:20 haruki Exp $
 * @author	Haruki Setoyama <haruki@planewave.org>
 */
/**
 * mailBody
 */
class mailBody extends mailBody_multipart {

	//var $msg;

    function mailBody($msg=false){
        $this->mailBody_multipart($msg);
    }

    function &addContent($data, $type='', $subtype=''){
        if($type == ''){
            $type = 'text';
            $subtype = 'plane';
        }

        $obj = new mailBody_singlepart();
        $obj->setData($data, $type, $subtype);
        return $this->addPart($obj);
    }

    function &addContentFromFile($path){
        $obj = new mailBody_singlepart();
        if(! $obj->setDataFromFile($path)){
            return false;
        }
        return $this->addPart($obj);
    }

    function &addHtmlMessage($data, $charset=''){
        $obj = new mailBody_html();
        if(! $obj->setHtml($data, $charset)){
            return false;
        }
        return $this->addPart($obj);
    }

    function &addHtmlMessageFromFile($path, $charset='') {
        $obj = new mailBody_html();
        if(! $obj->setHtmlFromFile($path, $charset)){
            return false;
        }
        return $this->addPart($obj);
    }

    function &addAttachment($data, $filename, $type, $subtype){
        $obj = new mailBody_singlepart();
        $obj->setData($data, $type, $subtype);
        $obj->beAttachment($filename);
        return $this->addPart($obj);
    }

    function &addAttachmentFromFile($path, $filename=''){
        $obj = new mailBody_singlepart();
        if(! $obj->setDataFromFile($path)){
            return false;
        }
        if($filename == '') $filename = basename($path);
        $obj->beAttachment($filename);
        return $this->addPart($obj);
    }

    function &addAlternativePart(){
        $obj = new mailBody;
        $obj->setContentType('multipart','alternative');
        return $this->addPart($obj);
    }
}

?>