<?php
/**
 * text data for mail.
 *
 * @package bytesmailer
 * @version $Id: class.text.mail.php,v 1.1 2003/01/21 14:17:56 haruki Exp $
 * @author  Haruki Setoyama <haruki@planewave.org>
 */
/**
 * include.
 */
include_once 'class.text.simple.php';
/**
 * text data for mail.
 *
 * this class holds character encoding data of the inputed text
 * and the mail, and automaticaly convert its character encoding.
 * @access public
 */
class bm_text_mail extends bm_text_simple{

    var $converter;
    var $original_textinfo;

    function bm_text_mail($param=''){
        $this->converter = new converter_null;
    }

    function &getInstance($param=''){
        static $obj;
        if(! isset($obj)) $obj = new bm_text_mail($param);
        return $obj;
    }

    function getBlankInstance(){
        $obj = bm_text_mail::getInstance();
        $obj->setData('');
        return $obj;
    }

    function setData($data){
        $this->data = $this->converter->convert($data);
    }

    function &setTextinfo($obj){
        parent::setTextinfo($obj);
        $this->_load_converter();
        return $this->textinfo;
    }

    function setOriginalCharacterEncoding($encoding_name){
        $obj = new textInfo($encoding_name);
        return $this->setOriginalTextinfo($obj);
    }

    function &setOriginalTextinfo($obj){
        $this->original_textinfo = $obj;
        $this->_load_converter();
        return $this->original_textinfo;
    }

    function _load_converter(){
        if(empty($this->original_textinfo)
        || $this->textinfo->getCharacterEncoding() == $this->original_textinfo->getCharacterEncoding()){
            $this->converter = new converter_null;
            return;
        }
        $from_encoding = strtolower(str_replace('-','',$this->original_textinfo->getCharacterEncoding()));
        $to_encoding = strtolower(str_replace('-','',$this->original_textinfo->getCharacterEncoding()));
        $filename = dirname(__FILE__).'/converter/class.converter.'.$from_encoding.'.'.$to_encoding.'.php';
        if(file_exists($filename)){
            include $filename;
            $classname = 'converter_'.$from_encoding.'_'.$to_encoding;
            $this->converter = new $classname;
        }
        elseif(converter_mb::isAcceptable($this->original_textinfo->getCharacterEncoding(), $this->textinfo->getCharacterEncoding())){
            $this->converter = new converter_mb($this->original_textinfo->getCharacterEncoding(), $this->textinfo->getCharacterEncoding());
            return $this->textinfo;
        }
        else{
            $this->converter = new converter_null;
        }
    }
}

/**
 * dummy character encoding converter
 *
 * @access public
 */
class converter_null {

    function convert($text){
        return $text;
    }

}

/**
 * character encoding converter that uses mb_* functions.
 *
 * @access public
 */
class converter_mb {

    var $from_encoding;
    var $to_encoding;

    function converter_mb($from_encoding, $to_encoding){
        $this->from_encoding = $from_encoding;
        $this->to_encoding = $to_encoding;

    }

    function isAcceptable($from_encoding, $to_encoding){
        if(! function_exists(mb_convert_encoding))
            return false;

        return @mb_convert_encoding('1', $to_encoding, $from_encoding);
    }

    function convert($text){
        return @mb_convert_encoding($text, $this->to_encoding, $this->from_encoding);
    }
}
?>