<?php

class spliter_utf8 {

    function split($string, $length, $first_part_length=0){

        $b = unpack('C*', $string);
        $n = count($b);

        $ret = array();
        $lines = 0;
        $line_byte = 0;
        if($first_part_length > 0)
            $max_length = $first_part_length;
        else
            $max_length = $length;

        $st = 1;
        $char_byte = 0;
        while($st <= $n) {

            if($char_byte > 0){
                if($b[$st] > 0xBF || 0x80 > $b[$st]){
                    // this is not UTF-8
                    return array($string);
                }
            }else{

                if(0x00 <= $b[$st] && $b[$st] <= 0x7F){
                    $char_byte = 1;
                }
                elseif(0xC0 <= $b[$st] && $b[$st] <= 0xDF){
                    $char_byte = 2;
                }
                elseif(0xE0 <= $b[$st] && $b[$st] <= 0xEF){
                    $char_byte = 3;
                }
                elseif(0xF0 <= $b[$st] && $b[$st] <= 0xF7){
                    $char_byte = 4;
                }
                elseif(0xF8 <= $b[$st] && $b[$st] <= 0xFB){
                    $char_byte = 5;
                }
                elseif(0xFC <= $b[$st] && $b[$st] <= 0xFD){
                    $char_byte = 6;
                }
                else{
                    // this is not UTF-8
                    return array($string);
                }

                if($line_byte + $char_byte > $max_length){
                    $max_length = $length;
                    $lines++;
                    $ret[$lines] = '';
                    $line_byte = 0;
                }
            }

            $ret[$lines] .= chr($b[$st]);
            $line_byte++;
            $char_byte--;
            $st++;
        }

        return $ret;
    }
}

?>