<?php
/**
 * classe for mail address.
 *
 * This is a part of bytesmailer.
 * @package bytesmailer
 * @version $Id: address.php,v 1.5 2003/06/25 13:36:48 haruki Exp $
 * @author	Haruki Setoyama <haruki@planewave.org>
 */
/*
* template of other address handle classes.
* ex. nameaddr , nulladdr and mailbox class.
*/
class address extends bytesmailerFellow
{
    function address(&$leader)
    {
        $this->bytesmailerFellow($leader);
    }

    /**
     * return the number of Addresses whitch this object holds
     * @return int
     */
    function count(){}

    /**
     * return encoded string
     * @return string
     */
    function getForHeader(){}

    /**
     * return encoded string of One addr
     * @return string
     */
    function getOneForHeader(){}

    /**
     * return array of addr-spec style (ex. hoge@hoge.com) address
     * @return array
     */
    function getAddrspec(){}
}

/**
 * nameaddr - name-addr class. see RFC2822.
 * @access public
 */
class nameaddr extends address
{
    var $addrspec = '';
    var $displayname = '';

    /**
     * Constructor
     */
    function nameaddr(&$leader)
    {
        $this->address($leader);
    }

    /**
     * sets Name-addr.
     * @access public
     * @param string $addrspec   hoge@hege.com style mail address
     * @param string $displayname
     * @return bool
     */
    function set($addrspec, $displayname ='')
    {
        $addrspec = trim($addrspec);
        $atext = '[\043-\047\052\053\055\057\060-\071\075\077\101-\132\136-\176]';

        if(preg_match('/^'.$atext.'+(\.'.$atext.'+)*@'.$atext.'+(\.'.$atext.'+)*$/',$addrspec))
        {
            $this->addrspec = $addrspec;
            if(isset($displayname) && $displayname != '') {
                $this->displayname = $this->_textEncoder->headerText($displayname);
            }
            return true;
        }

        return false;
    }

    function addAddr($addrspec, $displayname ='')
    {
        return $this->set($addrspec, $displayname);
    }

    /**
     * get number of nameaddr this object holds.
     * @access public
     * @return int
     */
    function count()
    {
        return ($this->addrspec != '') ? 1: 0;
    }

    /**
     * get encoded string.
     * @access public
     * @return string
     */
    function getForHeader()
    {
        if(empty($this->displayname))
            return $this->addrspec;
        else
            return $this->displayname.' <'.$this->addrspec.'>';
    }

    /**
     * get only one nameaddr encoded.
     * @access public
     * @return string
     */
    function getOneForHeader()
    {
        return $this->getForHeader();
    }

    /**
     * get Addrspecs.
     * @access public
     * @return string
     */
    function getAddrspec()
    {
        if($this->addrspec != '')
            return array($this->addrspec);
        else
            return array();
    }
}

/**
 * mailboxlist - mailbox-list class. Nameaddr class can be added.
 * @access public
 */
class mailboxlist extends address
{
    var $contents = array();

    function mailboxlist(&$leader)
    {
        $this->address($leader);
    }

    function addAddr($addrspec, $displayname ='')
    {
        $addr = new nameaddr($this);
        if(! $addr->set($addrspec, $displayname))
            return false;
        return $this->add($addr);
    }


    /**
     * add nameaddr or mailboxlist class.
     * @access public
     * @param object $obj
     * @return bool
     */
    function add(&$obj)
    {
        switch(get_class($obj))
        {
        case 'nameaddr':
        case 'mailboxlist':
            //$this->contents = array_merge($this->contents, $obj->get());
            $this->contents[] =& $obj;
            return true;
        default:
            return false;
		}
    }

    function count()
    {
        $num = 0;
        foreach($this->contents as $obj)
        {
            $num += $obj->count();
        }
        return $num;
    }

    function getForHeader()
    {
        foreach($this->contents as $content)
        {
            $ret[] = $content->getForHeader();
        }
        return implode(','._BYTESMAILER_FWS, $ret);
    }

    function getOneForHeader()
    {
        if(! empty($this->contents))
            return $this->contents[0]->getOneForHeader();
    }

    function getAddrspec()
    {
        $ret = array();
        foreach($this->contents as $content)
        {
            $ret = array_merge($ret, $content->getAddrspec());
        }
        return $ret;
    }
}

/**
 * addresslist - address-list class. Nameaddr class and addressgroup class can be added.
 * @access public
 */
class addresslist extends mailboxlist
{
    function addresslist(&$leader)
    {
        $this->mailboxlist($leader);
    }

    function add(&$obj)
    {
        switch(get_class($obj))
        {
        case 'addressgroup':
        case 'nameaddr':
        case 'mailboxlist':
        case 'addresslist':
            //$this->contents = array_merge($this->contents, $obj->get());
            $this->contents[] =& $obj;
            return true;
        default:
            return false;
		}
    }
}

/**
 * addressgroup - group of name-addr class.
 * @access public
 */
class addressgroup extends mailboxlist
{
    var $name = '';

    function addressgroup(&$leader)
    {
        $this->mailboxlist($leader);
    }
    /**
     * sets name of group
     * @access public
     * @param string $name
     * @return bool
     */
    function setName($name)
    {
        $this->name = $this->_textEncoder->headerText($name);
    }

    /**
     * get name of this group.
     * @access public
     * @return string
     */
    function getName()
    {
        return $this->name;
    }

    function getForHeader()
    {
        foreach($this->contents as $content)
        {
            $ret[] = $content->getForHeader();
        }

        if($name != '')
        {
            return $this->name.' :'._BYTESMAILER_FWS
                .implode(','._BYTESMAILER_FWS, $ret).' ; ';
        }
        else
        {
            return implode(','._BYTESMAILER_FWS, $ret);
        }
    }
}
?>