#!/bin/sh
source cs00_common.sh
PFX="${LOGDIR}/cs01"
TASK="--fifo=MAX"

if [ ! -e /proc/cabi/cabi_status ] ; then
    echo "ERROR cabi disable!"
    exit 1
fi

TEST="12_create_destroy"
echo "[ TEST ] ${TEST} START"
LOGNAME="${PFX}_${TEST}_${LOGNAMEBASE}"
RESULT="${LOGNAME}.result"
CSV="${LOGNAME}.csv"
cstest ${TASK} --csv=${CSV} --count=10000 --TERM_SIGNAL --sig=0 --cpu_time=1 --cpu_period=2 --create > ${RESULT}
if [ $? != 0 ] ; then
    echo "[ TEST ] ${TEST} fail"
    exit 1
fi
echo "output result ${RESULT}"
echo "output csv ${CSV}"
echo "[ TEST ] ${TEST} SUCCESS"
echo ""
echo ""
