#!/bin/sh
source cs00_common.sh
PFX="${LOGDIR}/cs03"
TASK="--fifo=MAX"

if [ ! -e /proc/cabi/cabi_status ] ; then
    echo "ERROR cabi disable!"
    exit 1
fi

TEST="2_PS"
echo "[ TEST ] ${TEST} START"

eval `ctcreate --export --TERM_SIGNAL --sig=0 --cpu_time=1 --cpu_period=2`

PSCOUNT=200
COUNT=4
for (( i=1 ; i<${COUNT} ; i=i+1  )) ; do
    NOWCOUNT=$( expr ${i} \* ${PSCOUNT} )
    exec_ctfork ${PSCOUNT}
    TMP=CT_PGID${NOWCOUNT}
    eval ${TMP}=${CT_PGID}
    echo "make process group ${i} pgid ${!TMP}"
done

# bind pgid test
for (( i=0 ; i<${COUNT} ; i=i+1  )) ; do
    NOWCOUNT=$( expr ${i} \* ${PSCOUNT} )
    if [ $i == 0 ] ; then
        NOWCOUNT="000"
    fi
    LOGNAME="${PFX}_${TEST}${NOWCOUNT}_${LOGNAMEBASE}"
    RESULT="${LOGNAME}.result"
    echo "PS count=${NOWCOUNT}" > ${RESULT}
    TMP=CT_PGID${NOWCOUNT}
    echo "bind pgid ${!TMP}"
    if [ $i != 0 ] ; then
        ctbindpgid --cabiid=${CT_CABI_ID} --pgid=${!TMP}
        if [ $? != 0 ] ; then
            echo "[ TEST ] ${TEST} fail"
            killall ctfork
            exit 1
        fi
    fi
    echo "free memory count AO ${NOWCOUNT}"
    sleep 1
    free -b >> ${RESULT}
    echo "bind AO count="$(cat /proc/cabi/${CT_CABI_ID}/bind_pid | wc -l) >> ${RESULT}
done

for (( i=0 ; i<${COUNT} ; i=i+1  )) ; do
    NOWCOUNT=$( expr ${i} \* ${PSCOUNT} )
    if [ $NOWCOUNT == 0 ] ; then
        NOWCOUNT="000"
    fi
    LOGNAME="${PFX}_${TEST}${NOWCOUNT}_${LOGNAMEBASE}"
    RESULT="${LOGNAME}.result"
    echo "output result ${RESULT}"
done

echo "[ TEST ] ${TEST} SUCCESS"
echo ""
echo ""

killall ctfork
sleep 1
ctdestroy `cabiid`
