/*
 * This is sample program for CABI system.
 * create accounting object.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

#define ERR_MSG "Usage: ctcreate "

int main (int argc, char **argv)
{
	int i, ret, c, index = 0, count = 1;
	struct cabi_uaccount ucabi, *ucabip;
	struct option *options;
	static struct option ctcreate_options[] = {
		{"count", required_argument, 0, 'c'},
		{0,0,0,0},
	};


	/* clear cabi_uaccount */
	memset(&ucabi, 0, sizeof(struct cabi_uaccount));
	ucabip = &ucabi;

	/* make option table */
	options = append_common_options(ctcreate_options, 0);
	options = append_ucabi_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case 'c':
			count = parse_int(options[index].name, optarg);
			break;
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else if ( !check_ucabi(c, options, index, &ucabip) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

	for ( i = 0; i < count; i++ ){
		if ( count > 1 ){
			cabi_information("COUNT=%d/%d\n", i+1, count);
		}
		if ( ucabip == &ucabi ){
			dump_ucabi(&ucabi);
		}
		ret = cabi_account_create (ucabip);
		if ( ret == CABI_SUCCESS ){
			cabi_information("account set create. object_id [%lu(0x%lx)]\n",
					 ucabi.cabi_id, ucabi.cabi_id);
		} else {
			/* check necessary arguments */
			if ( ucabip == &ucabi ){
				check_setarg_ucabi_term_act(0,  ERR_MSG "--TERM_XXX");
				check_setarg_ucabi_cpu_time(0,  ERR_MSG "--cpu_time=x");
				check_setarg_ucabi_cpu_period(0, ERR_MSG "--cpu_period=x");
			}
			cabi_result(ret, 1);
		}
	}
	/*
	 * Ǹ AO  id  export 
	 */
	cabi_export_int(ENV_CT_CABI_ID, ucabi.cabi_id);

	
	/*
	 * ޤãϡ٤Ƥ뤿Υå
	 */
	cabi_result(0, 1);
	
	return 0;	
}


