/*
 * This is sample program for CABI system.
 * destroy overload account object.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

int main (int argc, char **argv)
{
	int ret, c, index = 0;
	struct option *options;

	/* make option table */
	options = append_common_options(NULL, 0);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

	ret = cabi_overload_destroy();
	cabi_result(ret, 1);

	return 0;
}
