/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.hash;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.HashState;

public class Fingerprint
extends Crypto {
    protected byte[] fp = null;
    protected String algorithm = null;

    public static Fingerprint create(byte[] byArray, int n, int n2, String string) throws InvalidCDSException {
        HashState hashState = HashState.create(string);
        hashState.update(byArray, n, n2);
        return hashState.calculate();
    }

    public static Fingerprint create(byte[] byArray, String string) throws InvalidCDSException {
        return Fingerprint.create(byArray, 0, byArray.length, string);
    }

    public static Fingerprint create(String string, String string2) throws InvalidCDSException {
        HashState hashState = HashState.create(string2);
        hashState.update(string);
        return hashState.calculate();
    }

    public static Fingerprint parseCDS(String string) throws InvalidCDSException {
        Fingerprint fingerprint = null;
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.ordinaryChars(48, 57);
            streamTokenizer.wordChars(48, 57);
            if (streamTokenizer.nextToken() != -3) {
                throw new InvalidCDSException("Fingerprint algorithm name expected as first argument to Fingerprint()");
            }
            String string2 = streamTokenizer.sval;
            if (streamTokenizer.nextToken() != 44) {
                throw new InvalidCDSException(", expected after " + string2);
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new InvalidCDSException("Hexadecimal string expected as second argument to Fingerprint()");
            }
            byte[] byArray = Crypto.fromHexString(streamTokenizer.sval);
            fingerprint = new Fingerprint(string2, byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fingerprint;
    }

    public String getName() {
        return this.algorithm;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.fp.length];
        System.arraycopy(this.fp, 0, byArray, 0, this.fp.length);
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Fingerprint fingerprint = (Fingerprint)object;
        if (!fingerprint.algorithm.equals(this.algorithm)) {
            return false;
        }
        int n = this.fp.length - 1;
        while (n >= 0) {
            if (this.fp[n] != fingerprint.fp[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.algorithm.hashCode();
        int n2 = 0;
        while (n2 < this.fp.length) {
            n ^= this.fp[n2] << n2 % 4 * 8;
            ++n2;
        }
        return n;
    }

    public String toString() {
        return "Fingerprint(" + this.algorithm + "," + Crypto.hexString(this.fp) + ")";
    }

    public Fingerprint(String string, byte[] byArray, int n, int n2) {
        this.algorithm = string;
        this.fp = new byte[n2];
        System.arraycopy(byArray, n, this.fp, 0, n2);
    }
}

