/*
 * Decompiled with CFR 0.152.
 */
package com.acquisitionx;

import com.acquisitionx.AqEventHandler;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AqEvent {
    public static boolean shouldSignalEvents = true;
    public static final String kSep = "<aq/>";
    public static OutputStreamWriter writer = null;
    public static Map downloadStateCache = new HashMap();
    public static final int kLWEventConnectionInitialized = 1;
    public static final int kLWEventConnectionClosed = 2;
    public static final int kLWEventUpdateConnectionStats = 3;
    public static final int kLWEventConnectionsUpdated = 14;
    public static final int kLWEventQueryResult = 5;
    public static final int kLWEventAddUpload = 6;
    public static final int kLWEventRemoveUpload = 7;
    public static final int kLWEventUpdateUploadStats = 8;
    public static final int kLWEventUploadsUpdated = 12;
    public static final int kLWEventAddDownload = 9;
    public static final int kLWEventRemoveDownload = 10;
    public static final int kLWEventUpdateDownloadStats = 11;
    public static final int kLWEventDownloadsUpdated = 13;
    public static final int kShutdownSettingsHandler = 90;
    public static final int kShutdownTigerTree = 91;
    public static final int kShutdownCreationTime = 92;
    public static final int kShutdownURNCache = 93;
    public static final int kShutdownDownloadsCache = 94;
    public static final int kShutdownDownloadsFile = 95;
    public static final int kShutdownCleanDirectory = 96;

    public static String replaceStringWithString(String string, String target, String replacement) {
        int position;
        while (-1 < (position = string.indexOf(target))) {
            string = string.substring(0, position) + replacement + string.substring(position + target.length());
        }
        return string;
    }

    public static String correctedString(String string) {
        if (string == null) {
            return null;
        }
        string = AqEvent.replaceStringWithString(string, "&apos;", "'");
        string = AqEvent.replaceStringWithString(string, "apos;", "'");
        string = AqEvent.replaceStringWithString(string, "&amp;", "");
        string = AqEvent.replaceStringWithString(string, "amp;", "");
        return string;
    }

    public static void signalEvent(int type) {
        AqEvent.signalEvent(type, null, null, null);
    }

    public static void signalEvent(int type, Object obj) {
        AqEvent.signalEvent(type, obj, null, null);
    }

    public static void signalEvent(int type, Object obj, Object obj1) {
        AqEvent.signalEvent(type, obj, obj1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signalEvent(int type, Object obj, Object obj2, Object obj3) {
        if (!shouldSignalEvents && type < 90 || shouldSignalEvents && type >= 90) {
            return;
        }
        String event = null;
        if (writer == null) {
            try {
                writer = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        switch (type) {
            case 1: {
                ManagedConnection c = (ManagedConnection)obj;
                String ua = c.getUserAgent();
                String connectionType = c.isClientSupernodeConnection() || c.isSupernodeConnection() ? "Ultrapeer" : (c.isSupernodeClientConnection() ? "Leaf" : "Peer");
                if (ua == null) {
                    ua = "";
                }
                event = type + kSep + c.getAddress() + kSep + c.getPort() + kSep + ua + kSep + connectionType;
                break;
            }
            case 2: {
                ManagedConnection c = (ManagedConnection)obj;
                event = type + kSep + c.getAddress() + kSep + c.getPort();
                break;
            }
            case 3: {
                ManagedConnection c = (ManagedConnection)obj;
                ConnectionManager cm = RouterService.getConnectionManager();
                int total = cm.getNumInitializedConnections() + cm.getNumInitializedClientConnections();
                int negotiating = cm.getNumConnections() - total;
                if (negotiating < 0) {
                    negotiating = 0;
                }
                event = type + kSep + c.getAddress() + kSep + c.getPort() + kSep + c.getNumFiles() + kSep + negotiating;
                break;
            }
            case 5: {
                int bh;
                RemoteFileDesc r = (RemoteFileDesc)obj;
                HostData hd = (HostData)obj2;
                Set locs = (Set)obj3;
                int quality = hd.getQuality();
                if (quality < 0) {
                    quality = 0;
                }
                if (quality == 3 && hd.getSpeed() > 2000 && hd.isMeasuredSpeed()) {
                    quality = 4;
                }
                int queryIndex = AqEventHandler.queries.indexOf(new GUID(hd.getMessageGUID()).toString());
                AqEventHandler.responses.add(r);
                AqEventHandler.alts.add(locs);
                AqEventHandler.queryGUIDs.add(new GUID(hd.getMessageGUID()));
                int localIndex = AqEventHandler.responses.size() - 1;
                int bitrate = 0;
                String artist = null;
                String album = null;
                String year = null;
                String title = null;
                LimeXMLDocument xml = r.getXMLDoc();
                if (xml != null) {
                    String value = xml.getValue("audios__audio__bitrate__");
                    if (value != null) {
                        try {
                            bitrate = new Integer(value);
                        }
                        catch (Exception e) {
                            bitrate = 0;
                        }
                    }
                    artist = AqEvent.correctedString(xml.getValue("audios__audio__artist__"));
                    album = AqEvent.correctedString(xml.getValue("audios__audio__album__"));
                    year = xml.getValue("audios__audio__year__");
                    title = AqEvent.correctedString(xml.getValue("audios__audio__title__"));
                }
                String filename = r.getFileName();
                if (bitrate > 1000) {
                    bitrate = 0;
                }
                if (artist == null) {
                    artist = "";
                }
                if (album == null) {
                    album = "";
                }
                if (year == null) {
                    year = "";
                }
                if (title == null) {
                    title = "";
                }
                GUID cguid = new GUID(hd.getClientGUID());
                int n = bh = hd.isBrowseHostEnabled() ? 1 : 0;
                if (!AqEventHandler.hosts.containsKey(hd.getIP() + hd.getPort())) {
                    AqEventHandler.hosts.put(hd.getIP() + hd.getPort(), cguid);
                }
                String sha1 = "";
                if (r.getSHA1Urn() != null) {
                    sha1 = r.getSHA1Urn().toString();
                }
                event = type + kSep + queryIndex + kSep + hd.getIP() + kSep + hd.getPort() + kSep + "" + kSep + quality + kSep + hd.getSpeed() + kSep + r.getIndex() + kSep + r.getSize() + kSep + filename + kSep + sha1 + kSep + bitrate + kSep + localIndex + kSep + bh + kSep + artist + kSep + album + kSep + year + kSep + title + kSep + locs.size();
                break;
            }
            case 6: {
                Uploader u = (Uploader)obj;
                String ua = u.getUserAgent();
                String p = "";
                if (u.getFileDesc() != null) {
                    p = u.getFileDesc().getPath();
                }
                if (ua == null) {
                    ua = "";
                }
                event = type + kSep + u.getHost() + kSep + u.getIndex() + kSep + u.getFileName() + kSep + ua + kSep + u.getState() + kSep + u.getAmountRequested() + kSep + p + kSep + (u.isBrowseHostEnabled() ? 1 : 0) + kSep + u.getGnutellaPort();
                break;
            }
            case 7: {
                Uploader u = (Uploader)obj;
                event = type + kSep + u.getHost() + kSep + u.getIndex() + kSep + u.getFileName() + kSep + u.getState();
                break;
            }
            case 8: {
                Uploader u = (Uploader)obj;
                float b = 0.0f;
                float b1 = 0.0f;
                try {
                    b = u.getMeasuredBandwidth() * 1024.0f;
                    b1 = u.getAverageBandwidth() * 1024.0f;
                }
                catch (Exception e) {
                    // empty catch block
                }
                event = type + kSep + u.getHost() + kSep + u.getIndex() + kSep + u.getFileName() + kSep + u.getState() + kSep + u.getFileSize() + kSep + u.getTotalAmountUploaded() + kSep + b + kSep + b1;
                break;
            }
            case 9: {
                ManagedDownloader d = (ManagedDownloader)obj;
                String index = (String)AqEventHandler.downloadsToIndices.get(d);
                if (index == null) {
                    index = "";
                }
                event = type + kSep + index + kSep + d.getFileName() + kSep + d.getState() + kSep + d.getContentLength() + kSep + d.getAmountReadDW();
                break;
            }
            case 10: {
                ManagedDownloader d = (ManagedDownloader)obj;
                String index = (String)AqEventHandler.downloadsToIndices.get(d);
                if (index == null) {
                    index = "";
                }
                event = type + kSep + index;
                downloadStateCache.remove(d);
                break;
            }
            case 11: {
                int l;
                ManagedDownloader d = (ManagedDownloader)obj;
                String index = (String)AqEventHandler.downloadsToIndices.get(d);
                if (index == null) {
                    index = "";
                }
                String p = "";
                if (d.getDownloadFragment() != null) {
                    p = d.getDownloadFragment().getAbsolutePath();
                }
                float b = 0.0f;
                float b1 = 0.0f;
                try {
                    b = d.getMeasuredBandwidth() * 1024.0f;
                    b1 = d.getAverageBandwidth() * 1024.0f;
                }
                catch (Exception e) {
                    // empty catch block
                }
                int q = 0;
                if (d.getState() == 10) {
                    q = d.getQueuePosition();
                }
                if ((l = d.getContentLength()) < 0) {
                    l = 1;
                }
                int r = d.getState() != 11 && d.getState() != 12 ? d.getAmountReadDW() : l;
                String hosts = "";
                Iterator i = d.getHosts();
                while (i.hasNext()) {
                    Endpoint e = (Endpoint)i.next();
                    hosts = hosts + e.getAddress() + ":" + e.getPort() + ",";
                }
                event = type + kSep + index + kSep + d.getState() + kSep + l + kSep + r + kSep + b + kSep + b1 + kSep + d.numberOfDownloaders() + kSep + d.getBusyHostCount() + kSep + d.numberOfFiles() + kSep + d.getQueuedHostCount() + kSep + p + kSep + q + kSep + hosts;
                String lastWrittenString = (String)downloadStateCache.get(d);
                if (lastWrittenString != null && lastWrittenString.equals(event)) {
                    event = null;
                    break;
                }
                downloadStateCache.put(d, event);
                break;
            }
            default: {
                String s1 = obj != null ? kSep + obj : "";
                String s2 = obj2 != null ? kSep + obj2 : "";
                String s3 = obj3 != null ? kSep + obj3 : "";
                event = type + s1 + s2 + s3;
                break;
            }
        }
        if (event != null) {
            boolean wasWritten = false;
            if (writer != null) {
                OutputStreamWriter outputStreamWriter = writer;
                synchronized (outputStreamWriter) {
                    try {
                        writer.write(event);
                        writer.write("\n");
                        writer.flush();
                        wasWritten = true;
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        wasWritten = false;
                    }
                }
            }
            if (!wasWritten) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println(event);
                }
            }
        }
    }
}

