/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrowseHostHandler {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$BrowseHostHandler == null ? (class$com$limegroup$gnutella$BrowseHostHandler = BrowseHostHandler.class$("com.limegroup.gnutella.BrowseHostHandler")) : class$com$limegroup$gnutella$BrowseHostHandler));
    private static final int NOT_STARTED = -1;
    private static final int STARTED = 0;
    private static final int DIRECTLY_CONNECTING = 1;
    private static final int PUSHING = 2;
    private static final int EXCHANGING = 3;
    private static final int FINISHED = 4;
    private static final int DIRECT_CONNECT_TIME = 10000;
    private static final long EXPIRE_TIME = 15000L;
    private static final int SPECIAL_INDEX = 0;
    private static Map _pushedHosts = new HashMap();
    private ActivityCallback _callback = null;
    private GUID _guid = null;
    private GUID _serventID = null;
    private volatile long _replyLength = 0L;
    private volatile long _currentLength = 0L;
    private volatile int _state = -1;
    private volatile long _stateStarted = 0L;
    static /* synthetic */ Class class$com$limegroup$gnutella$BrowseHostHandler;

    public BrowseHostHandler(ActivityCallback callback, GUID guid, GUID serventID) {
        this._callback = callback;
        this._guid = guid;
        this._serventID = serventID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browseHost(String host, int port, Set proxies, boolean canDoFWTransfer) {
        if (!NetworkUtils.isValidPort(port) || !NetworkUtils.isValidAddress(host)) {
            this.failed();
            return;
        }
        LOG.trace((Object)"starting browse protocol.");
        this.setState(0);
        int shouldPush = BrowseHostHandler.needsPush(host);
        LOG.trace((Object)("push needed? " + shouldPush));
        boolean shouldTryPush = false;
        switch (shouldPush) {
            case 0: {
                try {
                    this.setState(1);
                    Socket socket = Sockets.connect(host, port, 10000);
                    LOG.trace((Object)"direct connect successful");
                    this.browseExchange(socket);
                }
                catch (IOException ioe) {
                    shouldTryPush = true;
                }
                if (!shouldTryPush) break;
            }
            case 1: {
                if (this._serventID == null) {
                    this.failed();
                    break;
                }
                RemoteFileDesc fakeRFD = new RemoteFileDesc(host, port, 0L, "fake", 0, this._serventID.bytes(), 0, false, 0, false, null, null, false, false, "", 0L, proxies, -1L, canDoFWTransfer ? 1 : 0);
                Map map = _pushedHosts;
                synchronized (map) {
                    _pushedHosts.put(this._serventID, new PushRequestDetails(this));
                }
                LOG.trace((Object)"trying push.");
                this.setState(2);
                RouterService.getDownloadManager().sendPush(fakeRFD);
            }
        }
    }

    public double getPercentComplete(long currentTime) {
        switch (this._state) {
            case -1: {
                return 0.0;
            }
            case 0: {
                return 0.0;
            }
            case 1: {
                long elapsed = currentTime - this._stateStarted;
                return (double)elapsed / 10000.0;
            }
            case 2: {
                long elapsed = currentTime - this._stateStarted;
                return (double)elapsed / 15000.0;
            }
            case 3: {
                if (this._replyLength > 0L) {
                    return (double)this._currentLength / (double)this._replyLength;
                }
                return 0.5;
            }
            case 4: {
                return 1.0;
            }
        }
        throw new IllegalStateException("invalid state");
    }

    private void setState(int state) {
        this._state = state;
        this._stateStarted = System.currentTimeMillis();
    }

    private void failed() {
        this.setState(4);
        this._callback.browseHostFailed(this._guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void browseExchange(Socket socket) throws IOException {
        try {
            this.browseExchangeInternal(socket);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            this.setState(4);
        }
    }

    private void browseExchangeInternal(Socket socket) throws IOException {
        socket.setSoTimeout(5000);
        LOG.trace((Object)"BHH.browseExchange(): entered.");
        this.setState(3);
        String LF = "\r\n";
        String str = null;
        OutputStream oStream = socket.getOutputStream();
        LOG.trace((Object)"BHH.browseExchange(): got output stream.");
        str = "GET / HTTP/1.1\r\n";
        oStream.write(str.getBytes());
        str = "Host: " + NetworkUtils.ip2string(RouterService.getAddress()) + ":" + RouterService.getPort() + "\r\n";
        oStream.write(str.getBytes());
        str = "User-Agent: " + CommonUtils.getVendor() + "\r\n";
        oStream.write(str.getBytes());
        str = "Accept: application/x-gnutella-packets\r\n";
        oStream.write(str.getBytes());
        str = "Content-Length: 0\r\n";
        oStream.write(str.getBytes());
        str = "Connection: close\r\n";
        oStream.write(str.getBytes());
        str = "\r\n";
        oStream.write(str.getBytes());
        oStream.flush();
        LOG.trace((Object)"BHH.browseExchange(): wrote request A-OK.");
        InputStream in = socket.getInputStream();
        LOG.trace((Object)"BHH.browseExchange(): got input stream.");
        ByteReader br = new ByteReader(in);
        LOG.trace((Object)"BHH.browseExchange(): trying to get HTTP code....");
        int code = BrowseHostHandler.parseHTTPCode(br.readLine());
        if (code < 200 || code >= 300) {
            throw new IOException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BHH.browseExchange(): HTTP Response is " + code));
        }
        boolean readingHTTP = true;
        String currLine = null;
        while (readingHTTP) {
            currLine = br.readLine();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("BHH.browseExchange(): currLine = " + currLine));
            }
            if (currLine == null || currLine.equals("")) {
                readingHTTP = false;
                continue;
            }
            if (this.indexOfIgnoreCase(currLine, "Content-Type") > -1) {
                if (this.indexOfIgnoreCase(currLine, "application/x-gnutella-packets") >= 0) continue;
                throw new IOException();
            }
            if (this.indexOfIgnoreCase(currLine, "Content-Encoding") > -1) {
                throw new IOException();
            }
            if (!this.markContentLength(currLine)) continue;
        }
        LOG.debug((Object)"BHH.browseExchange(): read HTTP seemingly OK.");
        in = new BufferedInputStream(in);
        Message m = null;
        while (true) {
            try {
                m = null;
                LOG.debug((Object)"reading message");
                m = Message.read(in);
                LOG.debug((Object)("read message " + m));
            }
            catch (BadPacketException bpe) {
                LOG.debug((Object)bpe);
            }
            catch (IOException expected) {
                // empty catch block
            }
            if (m == null) {
                return;
            }
            if (!(m instanceof QueryReply)) continue;
            this._currentLength += (long)m.getTotalLength();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("BHH.browseExchange(): read QR:" + m));
            }
            QueryReply reply = (QueryReply)m;
            reply.setBrowseHostReply(true);
            reply.setGUID(this._guid);
            ForMeReplyHandler.instance().handleQueryReply(reply, null);
        }
    }

    private boolean markContentLength(String line) {
        int idx = this.indexOfIgnoreCase(line, "Content-Length:");
        if (idx < 0) {
            return false;
        }
        String length = line.substring("Content-Length:".length()).trim();
        try {
            this._replyLength = Long.parseLong(length);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        return true;
    }

    private static int needsPush(String host) {
        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && NetworkUtils.isPrivateAddress(host)) {
            return 1;
        }
        return 0;
    }

    private int indexOfIgnoreCase(String str, String section) {
        String aaa = str.toLowerCase();
        String bbb = section.toLowerCase();
        return aaa.indexOf(bbb);
    }

    private static int parseHTTPCode(String str) throws IOException {
        if (str == null) {
            return -1;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        if (!tokenizer.hasMoreTokens()) {
            throw new IOException();
        }
        String token = tokenizer.nextToken();
        if (token.toUpperCase().indexOf("HTTP") < 0) {
            throw new IOException();
        }
        if (!tokenizer.hasMoreTokens()) {
            throw new IOException();
        }
        token = tokenizer.nextToken();
        String num = token.trim();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("BHH.parseHTTPCode(): returning " + num));
            }
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handlePush(int index, GUID serventID, final Socket socket) throws IOException {
        boolean retVal = false;
        LOG.trace((Object)"BHH.handlePush(): entered.");
        if (index == 0) {
            // empty if block
        }
        PushRequestDetails prd = null;
        Map map = _pushedHosts;
        synchronized (map) {
            prd = (PushRequestDetails)_pushedHosts.remove(serventID);
        }
        if (prd != null) {
            final PushRequestDetails finalPRD = prd;
            ManagedThread runLater = new ManagedThread(){

                public void managedRun() {
                    try {
                        finalPRD.bhh.browseExchange(socket);
                    }
                    catch (IOException ohWell) {
                        finalPRD.bhh.failed();
                    }
                }
            };
            runLater.setName("BrowseHost");
            runLater.setDaemon(true);
            runLater.start();
            retVal = true;
        } else {
            LOG.debug((Object)"BHH.handlePush(): no matching BHH.");
        }
        LOG.trace((Object)"BHH.handlePush(): returning.");
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Expirer expirer = new Expirer();
        RouterService.schedule(expirer, 0L, 5000L);
    }

    private static class PushRequestDetails {
        private BrowseHostHandler bhh;
        private long timeStamp = System.currentTimeMillis();

        public PushRequestDetails(BrowseHostHandler bhh) {
            this.bhh = bhh;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timeStamp > 15000L;
        }
    }

    private static class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Iterator<Object> keys = null;
                HashSet toRemove = new HashSet();
                Map map = _pushedHosts;
                synchronized (map) {
                    keys = _pushedHosts.keySet().iterator();
                    while (keys.hasNext()) {
                        Object currKey = keys.next();
                        PushRequestDetails currPRD = null;
                        currPRD = (PushRequestDetails)_pushedHosts.get(currKey);
                        if (currPRD == null || !currPRD.isExpired()) continue;
                        LOG.debug((Object)"Expirer.run(): expiring a badboy.");
                        toRemove.add(currKey);
                        currPRD.bhh.failed();
                    }
                    keys = toRemove.iterator();
                    while (keys.hasNext()) {
                        _pushedHosts.remove(keys.next());
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

