/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteHostData;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.URLRemoteFileDesc;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteFileDesc
implements Serializable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$RemoteFileDesc == null ? (class$com$limegroup$gnutella$RemoteFileDesc = RemoteFileDesc.class$("com.limegroup.gnutella.RemoteFileDesc")) : class$com$limegroup$gnutella$RemoteFileDesc));
    private static final long serialVersionUID = 6619479308616716538L;
    private static final int COPY_INDEX = Integer.MAX_VALUE;
    public static final String BOGUS_IP = "1.1.1.1";
    private final String _host;
    private final int _port;
    private final String _filename;
    private final long _index;
    private final byte[] _clientGUID;
    private final int _speed;
    private final int _size;
    private final boolean _chatEnabled;
    private final int _quality;
    private final boolean _replyToMulticast;
    private LimeXMLDocument[] _xmlDocs;
    private Set _urns;
    private boolean _browseHostEnabled;
    private boolean _firewalled;
    private String _vendor;
    private long _timestamp;
    private boolean _http11;
    private transient PushEndpoint _pushAddr;
    private transient IntervalSet _availableRanges = null;
    private transient int _failedCount = 0;
    private transient long _earliestRetryTime = 0L;
    private transient int _hashCode = 0;
    private transient boolean _THEXFailed = false;
    private transient RemoteHostData _hostData = null;
    private transient boolean _isDownloading = false;
    private transient long _creationTime;
    static /* synthetic */ Class class$com$limegroup$gnutella$RemoteFileDesc;

    public RemoteFileDesc(RemoteFileDesc rfd, IpPort ep) {
        this(ep.getAddress(), ep.getPort(), Integer.MAX_VALUE, rfd.getFileName(), rfd.getSize(), DataUtils.EMPTY_GUID, 0, false, 2, false, rfd.getXMLDoc(), rfd.getUrns(), false, false, "ALT", System.currentTimeMillis(), Collections.EMPTY_SET, rfd.getCreationTime(), 0);
    }

    public RemoteFileDesc(RemoteFileDesc rfd, PushEndpoint pe) {
        this(rfd.getHost(), rfd.getPort(), Integer.MAX_VALUE, rfd.getFileName(), rfd.getSize(), rfd.getSpeed(), false, rfd.getQuality(), false, rfd.getXMLDoc(), rfd.getUrns(), false, true, "ALT", System.currentTimeMillis(), rfd.getCreationTime(), pe);
    }

    public RemoteFileDesc(String host, int port, long index, String filename, int size, byte[] clientGUID, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set urns, boolean replyToMulticast, boolean firewalled, String vendor, long timestamp, Set proxies, long createTime) {
        this(host, port, index, filename, size, clientGUID, speed, chat, quality, browseHost, xmlDoc, urns, replyToMulticast, firewalled, vendor, timestamp, proxies, createTime, 0);
    }

    public RemoteFileDesc(String host, int port, long index, String filename, int size, byte[] clientGUID, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set urns, boolean replyToMulticast, boolean firewalled, String vendor, long timestamp, Set proxies, long createTime, int FWTVersion) {
        this(host, port, index, filename, size, speed, chat, quality, browseHost, xmlDoc, urns, replyToMulticast, firewalled, vendor, timestamp, createTime, clientGUID == null ? null : new PushEndpoint(clientGUID, proxies, 0, FWTVersion));
    }

    public RemoteFileDesc(String host, int port, long index, String filename, int size, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set urns, boolean replyToMulticast, boolean firewalled, String vendor, long timestamp, long createTime, PushEndpoint pe) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (((long)speed & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + speed);
        }
        if (filename == null) {
            throw new NullPointerException("null filename");
        }
        if (filename.equals("")) {
            throw new IllegalArgumentException("cannot accept empty string file name");
        }
        if (((long)size & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (host == null) {
            throw new NullPointerException("null host");
        }
        this._speed = speed;
        this._host = host;
        this._port = port;
        this._index = index;
        this._filename = filename;
        this._size = size;
        this._pushAddr = pe;
        this._clientGUID = (byte[])(pe != null ? pe.getClientGUID() : null);
        this._chatEnabled = chat;
        this._quality = quality;
        this._browseHostEnabled = browseHost;
        this._replyToMulticast = replyToMulticast;
        this._firewalled = firewalled;
        this._vendor = vendor;
        this._timestamp = timestamp;
        this._creationTime = createTime;
        this._xmlDocs = xmlDoc != null ? new LimeXMLDocument[]{xmlDoc} : null;
        this._urns = urns == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(urns);
        this._http11 = !this._urns.isEmpty();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._urns == null) {
            this._urns = Collections.EMPTY_SET;
            this._browseHostEnabled = false;
        } else {
            HashSet newUrns = null;
            Iterator iter = this._urns.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (next instanceof URN) continue;
                if (newUrns == null) {
                    newUrns = new HashSet();
                    newUrns.addAll(this._urns);
                }
                newUrns.remove(next);
            }
            if (newUrns != null) {
                this._urns = Collections.unmodifiableSet(newUrns);
            }
        }
        if (this._xmlDocs != null && this._xmlDocs.length == 0) {
            this._xmlDocs = null;
        }
        this._http11 = this._http11 || !this._urns.isEmpty();
    }

    public boolean isHTTP11() {
        return this._http11;
    }

    public void setHTTP11(boolean http11) {
        this._http11 = http11;
    }

    public boolean isPartialSource() {
        return this._availableRanges != null;
    }

    public boolean isMe() {
        return this.needsPush() ? Arrays.equals(this._clientGUID, RouterService.getMyGUID()) : NetworkUtils.isMe(this.getHost(), this.getPort());
    }

    public IntervalSet getAvailableRanges() {
        return (IntervalSet)this._availableRanges.clone();
    }

    public void setAvailableRanges(IntervalSet availableRanges) {
        this._availableRanges = availableRanges;
    }

    public void setPushAddress(PushEndpoint pe) {
        if (!Arrays.equals(pe.getClientGUID(), this._clientGUID)) {
            throw new IllegalArgumentException("different clientGUID");
        }
        this._pushAddr = pe;
    }

    public int getFailedCount() {
        return this._failedCount;
    }

    public void incrementFailedCount() {
        ++this._failedCount;
    }

    public void resetFailedCount() {
        this._failedCount = 0;
    }

    public boolean isFromAlternateLocation() {
        return "ALT".equals(this._vendor);
    }

    public boolean isBusy() {
        return System.currentTimeMillis() < this._earliestRetryTime;
    }

    public int getWaitTime() {
        return this.isBusy() ? (int)(this._earliestRetryTime - System.currentTimeMillis()) / 1000 + 1 : 0;
    }

    public void setRetryAfter(int seconds) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setting retry after to be [" + seconds + "] seconds for " + this));
        }
        this._earliestRetryTime = System.currentTimeMillis() + (long)(seconds * 1000);
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public boolean hasTHEXFailed() {
        return this._THEXFailed;
    }

    public void setTHEXFailed() {
        this._THEXFailed = true;
    }

    public void setDownloading(boolean dl) {
        this._isDownloading = dl;
    }

    public boolean isDownloading() {
        return this._isDownloading;
    }

    public final String getHost() {
        return this._host;
    }

    public final int getPort() {
        return this._port;
    }

    public final long getIndex() {
        return this._index;
    }

    public final int getSize() {
        return this._size;
    }

    public final String getFileName() {
        return this._filename;
    }

    public final byte[] getClientGUID() {
        return this._clientGUID;
    }

    public final int getSpeed() {
        return this._speed;
    }

    public final String getVendor() {
        return this._vendor;
    }

    public final boolean chatEnabled() {
        return this._chatEnabled;
    }

    public final boolean browseHostEnabled() {
        return this._browseHostEnabled;
    }

    public final int getQuality() {
        return this._quality;
    }

    public final LimeXMLDocument getXMLDoc() {
        if (this._xmlDocs == null) {
            return null;
        }
        return this._xmlDocs[0];
    }

    public final Set getUrns() {
        return this._urns;
    }

    public final URN getSHA1Urn() {
        Iterator iter = this._urns.iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            if (urn == null || !urn.isSHA1()) continue;
            return urn;
        }
        return null;
    }

    public URL getUrl() {
        try {
            String fileName = "";
            URN urn = this.getSHA1Urn();
            fileName = urn == null ? "/get/" + this._index + "/" + this._filename : "/uri-res/N2R?" + urn.httpStringValue();
            return new URL("http", this._host, this._port, fileName);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public final boolean isReplyToMulticast() {
        return this._replyToMulticast;
    }

    public final boolean isPrivate() {
        return NetworkUtils.isPrivateAddress(this._host);
    }

    public final Set getPushProxies() {
        if (this._pushAddr != null) {
            return this._pushAddr.getProxies();
        }
        return Collections.EMPTY_SET;
    }

    public final boolean supportsFWTransfer() {
        if (this._host.equals(BOGUS_IP) || !NetworkUtils.isValidAddress(this._host) || NetworkUtils.isPrivateAddress(this._host)) {
            return false;
        }
        return this._pushAddr == null ? false : this._pushAddr.supportsFWTVersion() > 0;
    }

    public final RemoteHostData getRemoteHostData() {
        if (this._hostData == null) {
            this._hostData = new RemoteHostData(this._host, this._port, this._clientGUID);
        }
        return this._hostData;
    }

    public final boolean isAltLocCapable() {
        boolean ret;
        boolean bl = ret = this.getSHA1Urn() != null && !this._replyToMulticast;
        ret = this._firewalled ? ret && this._pushAddr != null && this._pushAddr.getProxies().size() > 0 : ret && NetworkUtils.isValidPort(this._port) && !NetworkUtils.isPrivateAddress(this._host) && NetworkUtils.isValidAddress(this._host);
        return ret;
    }

    public boolean needsPush() {
        if (this.isReplyToMulticast()) {
            return true;
        }
        if (this.isPrivate()) {
            return !(this instanceof URLRemoteFileDesc);
        }
        if (!NetworkUtils.isValidPort(this.getPort())) {
            return true;
        }
        return this._firewalled && this._pushAddr != null;
    }

    public PushEndpoint getPushAddr() {
        return this._pushAddr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFileDesc)) {
            return false;
        }
        RemoteFileDesc other = (RemoteFileDesc)o;
        if (!this.nullEquals(this._host, other._host) || this._port != other._port) {
            return false;
        }
        if (this._size != other._size) {
            return false;
        }
        if (this._clientGUID == null != (other._clientGUID == null)) {
            return false;
        }
        if (this._clientGUID != null && !Arrays.equals(this._clientGUID, other._clientGUID)) {
            return false;
        }
        if (this._urns.isEmpty() && other._urns.isEmpty()) {
            return this.nullEquals(this._filename, other._filename);
        }
        return this.urnSetEquals(this._urns, other._urns);
    }

    private boolean nullEquals(Object one, Object two) {
        return one == null ? two == null : one.equals(two);
    }

    private boolean urnSetEquals(Set one, Set two) {
        Iterator iter = one.iterator();
        while (iter.hasNext()) {
            if (!two.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    private boolean byteArrayEquals(byte[] one, byte[] two) {
        return one == null ? two == null : Arrays.equals(one, two);
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int result = 17;
            result = 37 * result + this._host.hashCode();
            result = 37 * result + this._port;
            result = 37 * result + this._size;
            result = 37 * result + ((Object)this._urns).hashCode();
            if (this._clientGUID != null) {
                result = 37 * result + this._clientGUID.hashCode();
            }
            this._hashCode = result;
        }
        return this._hashCode;
    }

    public String toString() {
        return "<" + this.getHost() + ":" + this.getPort() + ", " + this.getFileName().toLowerCase() + ">";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

