/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.HUGEExtension;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class Response {
    private static final byte EXT_SEPERATOR = 28;
    private static final String EXT_STRING = "\u001c";
    private static final int MAX_LOCATIONS = 10;
    private final long index;
    private final long size;
    private final byte[] nameBytes;
    private final String name;
    private String metadata;
    private byte[] metaBytes;
    private LimeXMLDocument document;
    private final Set urns;
    private final byte[] extBytes;
    private volatile RemoteFileDesc cachedRFD;
    private final GGEPContainer ggepData;
    private static final String AUDIOS_NAMESPACE = "<audios xsi:noNamespaceSchemaLocation=\"http://www.limewire.com/schemas/audio.xsd\">";
    private static final String AUDIO_TITLE = "<audio title=\"";
    private static final String AUDIO_BITRATE = "bitrate=\"";
    private static final String AUDIO_SECONDS = "seconds=\"";
    private static final String AUDIOS_CLOSE = "</audio></audios>";
    private static final String QUOTE_SPACE = "\" ";
    private static final String CLOSE_TAG = "\">";
    private static final String KBPS = "kbps";
    private static final String KHZ = "kHz";

    public Response(long index, long size, String name) {
        this(index, size, name, "", null, null, null, null);
    }

    public Response(long index, long size, String name, LimeXMLDocument doc) {
        this(index, size, name, Response.extractMetadata(doc), null, doc, null, null);
    }

    public Response(long index, long size, String name, String metadata) {
        this(index, size, name, metadata, null, null, null, null);
    }

    public Response(FileDesc fd) {
        this(fd.getIndex(), fd.getSize(), fd.getName(), "", fd.getUrns(), null, new GGEPContainer(Response.getAsEndpoints(fd.getAlternateLocationCollection()), CreationTimeCache.instance().getCreationTimeAsLong(fd.getSHA1Urn())), null);
    }

    private Response(long index, long size, String name, String metadata, Set urns, LimeXMLDocument doc, GGEPContainer ggepData, byte[] extensions) {
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (size > Integer.MAX_VALUE || size < 0L) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        this.index = index;
        this.size = size;
        this.name = name == null ? "" : name;
        byte[] temp = null;
        try {
            temp = this.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException namex) {
            ErrorService.error(namex);
        }
        this.nameBytes = temp;
        this.urns = urns == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(urns);
        this.ggepData = ggepData == null ? GGEPContainer.EMPTY : ggepData;
        this.extBytes = extensions != null ? extensions : Response.createExtBytes(this.urns, this.ggepData);
        this.metadata = (metadata == null || metadata.equals("")) && doc != null ? Response.extractMetadata(doc) : (metadata == null ? "" : metadata.trim());
        Assert.that(this.metadata != null, "Null metadata");
        try {
            this.metaBytes = this.metadata.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            ErrorService.error(ueex);
        }
        this.document = doc;
    }

    public static Response createFromStream(InputStream is) throws IOException {
        int c;
        long index = ByteOrder.ubytes2long(ByteOrder.leb2int(is));
        long size = ByteOrder.ubytes2long(ByteOrder.leb2int(is));
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("invalid index: " + index);
        }
        if (size > Integer.MAX_VALUE || size < 0L) {
            throw new IOException("invalid size: " + size);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = is.read()) != 0) {
            if (c == -1) {
                throw new IOException("EOF before null termination");
            }
            baos.write(c);
        }
        String name = new String(baos.toByteArray(), "UTF-8");
        if (name.length() == 0) {
            throw new IOException("empty name in response");
        }
        baos.reset();
        while ((c = is.read()) != 0) {
            if (c == -1) {
                throw new IOException("EOF before null termination");
            }
            baos.write(c);
        }
        byte[] rawMeta = baos.toByteArray();
        String betweenNulls = new String(rawMeta);
        if (betweenNulls == null || betweenNulls.equals("")) {
            if (is.available() < 16) {
                throw new IOException("not enough room for the GUID");
            }
            return new Response(index, size, name);
        }
        HUGEExtension huge = new HUGEExtension(rawMeta);
        Set urns = huge.getURNS();
        String metaString = "";
        Iterator iter = huge.getMiscBlocks().iterator();
        while (iter.hasNext() && metaString.equals("")) {
            metaString = Response.createXmlString(name, (String)iter.next());
        }
        GGEPContainer ggep = GGEPUtil.getGGEP(huge.getGGEPBlocks());
        return new Response(index, size, name, metaString, urns, null, ggep, rawMeta);
    }

    private static String createXmlString(String name, String ext) {
        StringTokenizer tok = new StringTokenizer(ext);
        if (tok.countTokens() < 2) {
            return "";
        }
        String first = tok.nextToken();
        String second = tok.nextToken();
        if (first != null) {
            first = first.toLowerCase();
        }
        if (second != null) {
            second = second.toLowerCase();
        }
        String length = "";
        String bitrate = "";
        boolean bearShare1 = false;
        boolean bearShare2 = false;
        boolean gnotella = false;
        if (second.startsWith(KBPS)) {
            bearShare1 = true;
        } else if (first.endsWith(KBPS)) {
            bearShare2 = true;
        }
        if (bearShare1) {
            bitrate = first;
        } else if (bearShare2) {
            int j = first.indexOf(KBPS);
            bitrate = first.substring(0, j);
        }
        if (bearShare1 || bearShare2) {
            while (tok.hasMoreTokens()) {
                length = tok.nextToken();
            }
        } else if (ext.endsWith(KHZ)) {
            gnotella = true;
            length = first;
            int i = second.indexOf(KBPS);
            if (i > -1) {
                bitrate = second.substring(0, i);
            } else {
                gnotella = false;
            }
        }
        if (bearShare1 || bearShare2 || gnotella) {
            StringBuffer sb = new StringBuffer();
            sb.append(AUDIOS_NAMESPACE);
            sb.append(AUDIO_TITLE);
            sb.append(name);
            sb.append(QUOTE_SPACE);
            sb.append(AUDIO_BITRATE);
            sb.append(bitrate);
            sb.append(QUOTE_SPACE);
            sb.append(AUDIO_SECONDS);
            sb.append(length);
            sb.append(CLOSE_TAG);
            sb.append(AUDIOS_CLOSE);
            return sb.toString();
        }
        return "";
    }

    private static byte[] createExtBytes(Set urns, GGEPContainer ggep) {
        try {
            if (Response.isEmpty(urns) && ggep.isEmpty()) {
                return DataUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!Response.isEmpty(urns)) {
                Iterator iter = urns.iterator();
                while (iter.hasNext()) {
                    URN urn = (URN)iter.next();
                    Assert.that(urn != null, "Null URN");
                    baos.write(urn.toString().getBytes());
                    if (!iter.hasNext()) continue;
                    baos.write(28);
                }
                if (!ggep.isEmpty()) {
                    baos.write(28);
                }
            }
            if (!ggep.isEmpty()) {
                GGEPUtil.addGGEP(baos, ggep);
            }
            return baos.toByteArray();
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
    }

    private static boolean isEmpty(Set set) {
        return set == null || set.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getAsEndpoints(AlternateLocationCollection col) {
        if (col == null || col.getAltLocsSize() == 0) {
            return Collections.EMPTY_SET;
        }
        AlternateLocationCollection alternateLocationCollection = col;
        synchronized (alternateLocationCollection) {
            HashSet<Endpoint> endpoints = null;
            int i = 0;
            Iterator iter = col.iterator();
            while (iter.hasNext() && i < 10) {
                DirectAltLoc al;
                Endpoint host;
                Object o = iter.next();
                if (!(o instanceof DirectAltLoc) || NetworkUtils.isMe((host = (al = (DirectAltLoc)o).getHost()).getAddress(), host.getPort())) continue;
                if (endpoints == null) {
                    endpoints = new HashSet<Endpoint>();
                }
                endpoints.add(al.getHost());
                ++i;
            }
            return endpoints == null ? Collections.EMPTY_SET : endpoints;
        }
    }

    private static String extractMetadata(LimeXMLDocument doc) {
        if (doc == null) {
            return "";
        }
        try {
            return doc.getXMLString();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return "";
        }
    }

    public int writeToArray(byte[] array, int i) {
        ByteOrder.int2leb((int)this.index, array, i);
        ByteOrder.int2leb((int)this.size, array, i + 4);
        System.arraycopy(this.nameBytes, 0, array, i += 8, this.nameBytes.length);
        i += this.nameBytes.length;
        array[i++] = 0;
        System.arraycopy(this.extBytes, 0, array, i, this.extBytes.length);
        i += this.extBytes.length;
        array[i++] = 0;
        return i;
    }

    public void writeToStream(OutputStream os) throws IOException {
        int i;
        ByteOrder.int2leb((int)this.index, os);
        ByteOrder.int2leb((int)this.size, os);
        for (i = 0; i < this.nameBytes.length; ++i) {
            os.write(this.nameBytes[i]);
        }
        os.write(0);
        for (i = 0; i < this.extBytes.length; ++i) {
            os.write(this.extBytes[i]);
        }
        os.write(0);
    }

    public void setDocument(LimeXMLDocument doc) {
        this.document = doc;
        this.metadata = Response.extractMetadata(this.document);
        try {
            this.metaBytes = this.metadata.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            ErrorService.error(uee);
        }
    }

    public int getLength() {
        return 8 + this.nameBytes.length + 1 + this.extBytes.length + 1;
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public int getNameBytesSize() {
        return this.nameBytes.length;
    }

    public int getMetaBytesSize() {
        return this.metaBytes.length;
    }

    public byte[] getNameBytes() {
        byte[] copy = new byte[this.nameBytes.length];
        System.arraycopy(this.nameBytes, 0, copy, 0, this.nameBytes.length);
        return copy;
    }

    public byte[] getMetaBytes() {
        byte[] copy = new byte[this.metaBytes.length];
        System.arraycopy(this.metaBytes, 0, copy, 0, this.metaBytes.length);
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public LimeXMLDocument getDocument() {
        if (this.document != null) {
            return this.document;
        }
        if (this.metadata != null && !this.metadata.equals("")) {
            try {
                this.document = new LimeXMLDocument(this.metadata);
                return this.document;
            }
            catch (SAXException e) {
            }
            catch (SchemaNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getUrns() {
        return this.urns;
    }

    public Set getLocations() {
        return this.ggepData.locations;
    }

    public long getCreateTime() {
        return this.ggepData.createTime;
    }

    byte[] getExtBytes() {
        return this.extBytes;
    }

    public RemoteFileDesc toRemoteFileDesc(HostData data) {
        RemoteFileDesc rfd;
        if (this.cachedRFD != null && this.cachedRFD.getPort() == data.getPort() && this.cachedRFD.getHost().equals(data.getIP())) {
            return this.cachedRFD;
        }
        this.cachedRFD = rfd = new RemoteFileDesc(data.getIP(), data.getPort(), this.getIndex(), this.getName(), (int)this.getSize(), data.getClientGUID(), data.getSpeed(), data.isChatEnabled(), data.getQuality(), data.isBrowseHostEnabled(), this.getDocument(), this.getUrns(), data.isReplyToMulticastQuery(), data.isFirewalled(), data.getVendorCode(), System.currentTimeMillis(), data.getPushProxies(), this.getCreateTime(), data.getFWTVersionSupported());
        return rfd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response r = (Response)o;
        return this.getIndex() == r.getIndex() && this.getSize() == r.getSize() && this.getName().equals(r.getName()) && Arrays.equals(this.getNameBytes(), r.getNameBytes()) && this.getMetadata().equals(r.getMetadata()) && Arrays.equals(this.getMetaBytes(), r.getMetaBytes()) && (this.getDocument() == null ? r.getDocument() == null : this.getDocument().equals(r.getDocument())) && ((Object)this.getUrns()).equals(r.getUrns());
    }

    public int hashCode() {
        return this.getName().hashCode() + (int)this.getSize() + (int)this.getIndex();
    }

    public String toString() {
        return "index:        " + this.index + "\r\n" + "size:         " + this.size + "\r\n" + "name:         " + this.name + "\r\n" + "metadata:     " + this.metadata + "\r\n" + "xml document: " + this.document + "\r\n" + "urns:         " + this.urns;
    }

    static final class GGEPContainer {
        final Set locations;
        final long createTime;
        private static final GGEPContainer EMPTY = new GGEPContainer();

        private GGEPContainer() {
            this(null, -1L);
        }

        GGEPContainer(Set locs, long create) {
            this.locations = locs == null ? Collections.EMPTY_SET : locs;
            this.createTime = create;
        }

        boolean isEmpty() {
            return this.locations.isEmpty() && this.createTime <= 0L;
        }
    }

    private static class GGEPUtil {
        private GGEPUtil() {
        }

        static void addGGEP(OutputStream out, GGEPContainer ggep) throws IOException {
            if (ggep == null || ggep.locations.size() == 0 && ggep.createTime <= 0L) {
                throw new NullPointerException("null or empty locations");
            }
            GGEP info = new GGEP();
            if (ggep.locations.size() > 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    Iterator i = ggep.locations.iterator();
                    while (i.hasNext()) {
                        try {
                            Endpoint ep = (Endpoint)i.next();
                            baos.write(ep.getHostBytes());
                            ByteOrder.short2leb((short)ep.getPort(), baos);
                        }
                        catch (UnknownHostException uhe) {}
                    }
                }
                catch (IOException impossible) {
                    ErrorService.error(impossible);
                }
                info.put("ALT", baos.toByteArray());
            }
            if (ggep.createTime > 0L) {
                info.put("CT", ggep.createTime / 1000L);
            }
            info.write(out);
        }

        static GGEPContainer getGGEP(Set ggeps) {
            if (ggeps == null) {
                return GGEPContainer.EMPTY;
            }
            HashSet<Endpoint> locations = null;
            long createTime = -1L;
            byte[] ip = new byte[4];
            IPFilter ipFilter = IPFilter.instance();
            Iterator iter = ggeps.iterator();
            while (iter.hasNext()) {
                GGEP currGGEP = (GGEP)iter.next();
                if (currGGEP.hasKey("ALT")) {
                    byte[] locBytes;
                    try {
                        locBytes = currGGEP.getBytes("ALT");
                        if (locBytes.length % 6 != 0) {
                        }
                    }
                    catch (BadGGEPPropertyException bad) {}
                    continue;
                    for (int j = 0; j < locBytes.length; j += 6) {
                        int port = ByteOrder.ubytes2int(ByteOrder.leb2short(locBytes, j + 4));
                        if (!NetworkUtils.isValidPort(port)) continue;
                        ip[0] = locBytes[j];
                        ip[1] = locBytes[j + 1];
                        ip[2] = locBytes[j + 2];
                        ip[3] = locBytes[j + 3];
                        if (!NetworkUtils.isValidAddress(ip) || !ipFilter.allow(ip) || NetworkUtils.isMe(ip, port)) continue;
                        if (locations == null) {
                            locations = new HashSet<Endpoint>();
                        }
                        locations.add(new Endpoint(ip, port));
                    }
                }
                if (!currGGEP.hasKey("CT")) continue;
                try {
                    createTime = currGGEP.getLong("CT") * 1000L;
                }
                catch (BadGGEPPropertyException bad) {}
            }
            return locations == null && createTime == -1L ? GGEPContainer.EMPTY : new GGEPContainer(locations, createTime);
        }
    }
}

