/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UrnCache {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$UrnCache == null ? (class$com$limegroup$gnutella$UrnCache = UrnCache.class$("com.limegroup.gnutella.UrnCache")) : class$com$limegroup$gnutella$UrnCache));
    private static final File URN_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.cache");
    private static final File URN_CACHE_BACKUP_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.bak");
    private static UrnCache instance = null;
    private static final Map URN_MAP = UrnCache.createMap();
    static /* synthetic */ Class class$com$limegroup$gnutella$UrnCache;

    public static synchronized UrnCache instance() {
        if (instance == null) {
            instance = new UrnCache();
        }
        return instance;
    }

    private UrnCache() {
        UrnCache.removeOldEntries(URN_MAP);
    }

    public synchronized Set getUrns(File file) {
        if (file.lastModified() == 0L) {
            return Collections.EMPTY_SET;
        }
        UrnSetKey key = new UrnSetKey(file);
        Set cachedUrns = (Set)URN_MAP.get(key);
        if (cachedUrns == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(cachedUrns);
    }

    public synchronized void removeUrns(File f) {
        UrnSetKey k = new UrnSetKey(f);
        URN_MAP.remove(k);
    }

    public synchronized void addUrns(File file, Set urns) {
        UrnSetKey key = new UrnSetKey(file);
        URN_MAP.put(key, Collections.unmodifiableSet(urns));
    }

    private static Map createMap() {
        HashMap result = UrnCache.readMap(URN_CACHE_FILE);
        if (result == null) {
            result = UrnCache.readMap(URN_CACHE_BACKUP_FILE);
        }
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map readMap(File file) {
        void var1_2;
        ObjectInputStream ois = null;
        ois = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        Map result = (Map)ois.readObject();
        Object var5_3 = null;
        if (ois == null) return var1_2;
        try {
            ois.close();
            return var1_2;
        }
        catch (IOException e) {}
        return var1_2;
        {
            catch (Throwable t) {
                LOG.error((Object)"Unable to read UrnCache", t);
                result = null;
                Object var5_4 = null;
                if (ois == null) return var1_2;
                try {
                    ois.close();
                    return var1_2;
                }
                catch (IOException e) {}
                return var1_2;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static void removeOldEntries(Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof UrnSetKey) {
                File f;
                UrnSetKey key = (UrnSetKey)next;
                if (key == null || (f = new File(key._path)).exists() && f.lastModified() == key._modTime) continue;
                iter.remove();
                continue;
            }
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void persistCache() {
        URN_CACHE_FILE.renameTo(URN_CACHE_BACKUP_FILE);
        ObjectOutputStream oos = null;
        oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(URN_CACHE_FILE)));
        oos.writeObject(URN_MAP);
        Object var4_2 = null;
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (Exception e) {
                ErrorService.error(e);
                Object var4_3 = null;
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class UrnSetKey
    implements Serializable {
        static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int result = 17;
            result = result * 37 + (int)(this._modTime ^ this._modTime >>> 32);
            result = result * 37 + this._path.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey key = (UrnSetKey)o;
            return this._modTime == key._modTime && this._path.equals(key._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeLong(this._modTime);
            s.writeObject(this._path);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this._modTime = s.readLong();
            this._path = (String)s.readObject();
            this._hashCode = this.calculateHashCode();
        }
    }
}

