/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;

public abstract class AlternateLocation
implements HTTPHeaderValue,
Comparable {
    public static final String ALT_VENDOR = "ALT";
    protected final URN SHA1_URN;
    private String DISPLAY_STRING;
    protected volatile int hashCode = 0;
    protected volatile int _count = 0;

    public static AlternateLocation create(String location) throws IOException {
        if (location == null || location.equals("")) {
            throw new IOException("null or empty location");
        }
        URL url = AlternateLocation.createUrl(location);
        URN sha1 = URN.createSHA1UrnFromURL(url);
        return new DirectAltLoc(url, sha1);
    }

    public static AlternateLocation create(String location, URN urn) throws IOException {
        if (location == null || location.equals("")) {
            throw new IOException("null or empty location");
        }
        if (urn == null) {
            throw new IOException("null URN.");
        }
        if (location.toLowerCase().startsWith("http")) {
            URL url = AlternateLocation.createUrl(location);
            URN sha1 = URN.createSHA1UrnFromURL(url);
            DirectAltLoc al = new DirectAltLoc(url, sha1);
            if (!al.SHA1_URN.equals(urn)) {
                throw new IOException("mismatched URN");
            }
            return al;
        }
        if (location.indexOf(";") == -1) {
            IpPort addr = AlternateLocation.createUrlFromMini(location, urn);
            return new DirectAltLoc(addr, urn);
        }
        PushEndpoint pe = new PushEndpoint(location);
        return new PushAltLoc(pe, urn);
    }

    public static AlternateLocation create(RemoteFileDesc rfd) throws IOException {
        if (rfd == null) {
            throw new NullPointerException("cannot accept null RFD");
        }
        URN urn = rfd.getSHA1Urn();
        if (urn == null) {
            throw new NullPointerException("cannot accept null URN");
        }
        int port = rfd.getPort();
        if (!rfd.needsPush()) {
            return new DirectAltLoc(new Endpoint(rfd.getHost(), rfd.getPort()), urn);
        }
        PushEndpoint copy = new PushEndpoint(rfd.getClientGUID(), rfd.getPushAddr().getProxies(), rfd.getPushAddr().getFeatures(), rfd.getPushAddr().supportsFWTVersion(), new IpPortImpl(rfd.getHost(), rfd.getPort()));
        return new PushAltLoc(copy, urn);
    }

    public static AlternateLocation create(URN urn) {
        if (urn == null) {
            throw new NullPointerException("null sha1");
        }
        try {
            boolean open = RouterService.isConnected() ? RouterService.acceptedIncomingConnection() : ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue();
            if (open) {
                return new DirectAltLoc(urn);
            }
            return new PushAltLoc(urn);
        }
        catch (IOException bad) {
            ErrorService.error(bad);
            return null;
        }
    }

    protected AlternateLocation(URN sha1) throws IOException {
        if (sha1 == null) {
            throw new IOException("null sha1");
        }
        this.SHA1_URN = sha1;
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public synchronized int getCount() {
        return this._count;
    }

    public abstract boolean isDemoted();

    public String httpStringValue() {
        if (this.DISPLAY_STRING == null) {
            this.DISPLAY_STRING = this.generateHTTPString();
        }
        return this.DISPLAY_STRING;
    }

    public abstract RemoteFileDesc createRemoteFileDesc(int var1);

    public abstract boolean isMe();

    public synchronized void increment() {
        ++this._count;
    }

    abstract void demote();

    abstract void promote();

    public abstract AlternateLocation createClone();

    private static URL createUrl(String locationHeader) throws IOException {
        String locHeader = locationHeader.toLowerCase();
        if (!locHeader.startsWith("http")) {
            throw new IOException("invalid location: " + locationHeader);
        }
        if (locHeader.lastIndexOf("http://") > 4) {
            throw new IOException("invalid location: " + locationHeader);
        }
        String urlStr = AlternateLocation.removeTimestamp(locHeader);
        URL url = new URL(urlStr);
        String host = url.getHost();
        if (host == null || host.equals("")) {
            throw new IOException("invalid location: " + locationHeader);
        }
        if (url.getPort() == -1) {
            url = new URL("http", url.getHost(), 80, url.getFile());
        }
        return url;
    }

    private static IpPort createUrlFromMini(String location, URN urn) throws IOException {
        int port = location.indexOf(58);
        String loc = port == -1 ? location : location.substring(0, port);
        try {
            new IP(loc);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("invalid location: " + location);
        }
        if (loc.indexOf(47) != -1) {
            throw new IOException("invalid location: " + location);
        }
        if (!NetworkUtils.isValidAddress(loc)) {
            throw new IOException("invalid location: " + location);
        }
        if (port == -1) {
            port = 6346;
        } else {
            if (location.length() < port + 1) {
                throw new IOException("invalid location: " + location);
            }
            try {
                port = Short.parseShort(location.substring(port + 1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("invalid location: " + location);
            }
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IOException("invalid port: " + port);
        }
        return new Endpoint(loc, port);
    }

    private static String removeTimestamp(String locationHeader) {
        StringTokenizer st = new StringTokenizer(locationHeader);
        int numToks = st.countTokens();
        if (numToks == 1) {
            return locationHeader;
        }
        String curTok = null;
        for (int i = 0; i < numToks; ++i) {
            curTok = st.nextToken();
        }
        int tsIndex = locationHeader.indexOf(curTok);
        if (tsIndex == -1) {
            return null;
        }
        return locationHeader.substring(0, tsIndex);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlternateLocation)) {
            return false;
        }
        AlternateLocation other = (AlternateLocation)obj;
        return this.SHA1_URN.equals(other.SHA1_URN);
    }

    public int compareTo(Object obj) {
        AlternateLocation other = (AlternateLocation)obj;
        int ret = this._count - other._count;
        if (ret != 0) {
            return ret;
        }
        return ret;
    }

    protected abstract String generateHTTPString();

    public int hashCode() {
        return 629 + this.SHA1_URN.hashCode();
    }
}

