/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;

public class DirectAltLoc
extends AlternateLocation {
    private final IpPort _node;
    protected volatile boolean _demoted = false;

    protected DirectAltLoc(URL url, URN sha1) throws IOException {
        super(sha1);
        if (!NetworkUtils.isValidPort(url.getPort())) {
            throw new IOException("invalid port: " + url.getPort());
        }
        if (!NetworkUtils.isValidAddress(url.getHost())) {
            throw new IOException("invalid address: " + url.getHost());
        }
        if (NetworkUtils.isPrivateAddress(url.getHost())) {
            throw new IOException("invalid address: " + url.getHost());
        }
        try {
            this._node = new QueryReply.IPPortCombo(url.getHost(), url.getPort());
        }
        catch (UnknownHostException bad) {
            throw new IOException(bad.getMessage());
        }
        this._count = 1;
        this._demoted = false;
    }

    protected DirectAltLoc(URN sha1) throws IOException {
        this(new Endpoint(NetworkUtils.ip2string(RouterService.getAddress()), RouterService.getPort()), sha1);
    }

    protected DirectAltLoc(IpPort address, URN sha1) throws IOException {
        super(sha1);
        this._node = address;
    }

    protected String generateHTTPString() {
        String ret = this._node.getAddress();
        if (this._node.getPort() != 6346) {
            ret = ret + ":" + this._node.getPort();
        }
        return ret;
    }

    public RemoteFileDesc createRemoteFileDesc(int size) {
        HashSet<URN> urnSet = new HashSet<URN>();
        urnSet.add(this.getSHA1Urn());
        int quality = 3;
        RemoteFileDesc ret = new RemoteFileDesc(this._node.getAddress(), this._node.getPort(), 0L, "/uri-res/N2R?" + this.SHA1_URN, size, DataUtils.EMPTY_GUID, 1000, true, quality, false, null, urnSet, false, false, "ALT", System.currentTimeMillis(), null, -1L);
        return ret;
    }

    public synchronized AlternateLocation createClone() {
        DirectAltLoc ret = null;
        try {
            ret = new DirectAltLoc(this._node, this.SHA1_URN);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
        ret._demoted = this._demoted;
        ret._count = this._count;
        return ret;
    }

    public boolean isMe() {
        return NetworkUtils.isMe(this._node.getAddress(), this._node.getPort());
    }

    public Endpoint getHost() {
        if (this._node instanceof Endpoint) {
            return (Endpoint)this._node;
        }
        return new Endpoint(this._node.getAddress(), this._node.getPort());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DirectAltLoc)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DirectAltLoc other = (DirectAltLoc)o;
        return this._node.getInetAddress().equals(other._node.getInetAddress()) && this._node.getPort() == other._node.getPort();
    }

    synchronized void demote() {
        this._demoted = true;
    }

    synchronized void promote() {
        this._demoted = false;
    }

    public synchronized boolean isDemoted() {
        return this._demoted;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        int ret = super.compareTo(o);
        if (!(o instanceof DirectAltLoc)) {
            if (ret != 0) {
                return ret;
            }
            return -1;
        }
        DirectAltLoc other = (DirectAltLoc)o;
        if (this._demoted != other._demoted) {
            if (this._demoted) {
                return 1;
            }
            return -1;
        }
        if (ret != 0) {
            return ret;
        }
        ret = this._node.getAddress().compareTo(other._node.getAddress());
        if (ret != 0) {
            return ret;
        }
        ret = this._node.getPort() - other._node.getPort();
        return ret;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = super.hashCode();
            result = 37 * result + this._node.getAddress().hashCode();
            this.hashCode = result = 37 * result + this._node.getPort();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._node + "," + this._count + "," + this._demoted;
    }
}

