/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointForSelf;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.FileIncompleteException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.ReaderIsNullException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.statistics.NumericalDownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.udpconnect.UDPConnection;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.CountingInputStream;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPDownloader
implements BandwidthTracker {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$downloader$HTTPDownloader == null ? (class$com$limegroup$gnutella$downloader$HTTPDownloader = HTTPDownloader.class$("com.limegroup.gnutella.downloader.HTTPDownloader")) : class$com$limegroup$gnutella$downloader$HTTPDownloader));
    public static final int BUF_LENGTH = 1024;
    private static final int MIN_RETRY_AFTER = 60;
    private static final int MAX_RETRY_AFTER = 3600;
    private static final BandwidthThrottle THROTTLE = new BandwidthThrottle(Float.MAX_VALUE, false);
    private static final BandwidthThrottle UDP_THROTTLE = new BandwidthThrottle(Float.MAX_VALUE, false);
    static int MIN_PARTIAL_FILE_BYTES = 0x100000;
    private RemoteFileDesc _rfd;
    private boolean _isPush;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private volatile int _totalAmountRead;
    private volatile int _amountRead;
    private volatile int _amountToRead;
    private int _initialReadingPoint;
    private int _contentLength;
    private boolean _bodyConsumed = true;
    private ByteReader _byteReader;
    private Socket _socket;
    private OutputStream _output;
    private InputStream _input;
    private File _incompleteFile;
    private boolean _outIsCorrupted;
    private AlternateLocationCollection _altLocsReceived;
    private AlternateLocationCollection _pushAltLocsReceived;
    private Set _goodLocs;
    private Set _goodPushLocs;
    private Set _badPushLocs;
    private Set _badLocs;
    private Set _writtenGoodLocs;
    private Set _writtenBadLocs;
    private Set _writtenPushLocs;
    private Set _writtenBadPushLocs;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;
    private boolean _browseEnabled = false;
    private String _server = "";
    private String _thexUri = null;
    private String _root32 = null;
    private boolean _thexSucceeded = false;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();
    private volatile boolean _isActive = false;
    private Interval _requestedInterval = null;
    private boolean _wantsFalts = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$downloader$HTTPDownloader;

    public HTTPDownloader(RemoteFileDesc rfd, File incompleteFile) {
        this(null, rfd, incompleteFile);
        this._isPush = false;
    }

    public HTTPDownloader(Socket socket, RemoteFileDesc rfd, File incompleteFile) {
        if (rfd == null) {
            throw new NullPointerException("null rfd");
        }
        this._isPush = true;
        this._rfd = rfd;
        this._socket = socket;
        this._incompleteFile = incompleteFile;
        this._filename = rfd.getFileName();
        this._index = rfd.getIndex();
        this._guid = rfd.getClientGUID();
        this._amountToRead = rfd.getSize();
        this._port = rfd.getPort();
        this._host = rfd.getHost();
        this._chatEnabled = rfd.chatEnabled();
        this._browseEnabled = rfd.browseHostEnabled();
        URN urn = rfd.getSHA1Urn();
        if (urn != null) {
            this._altLocsReceived = AlternateLocationCollection.create(urn);
            this._pushAltLocsReceived = AlternateLocationCollection.create(urn);
        } else {
            this._altLocsReceived = null;
            this._pushAltLocsReceived = null;
        }
        this._goodLocs = new HashSet();
        this._badLocs = new HashSet();
        this._goodPushLocs = new HashSet();
        this._badPushLocs = new HashSet();
        this._writtenGoodLocs = new HashSet();
        this._writtenBadLocs = new HashSet();
        this._writtenPushLocs = new HashSet();
        this._writtenBadPushLocs = new HashSet();
        this._amountRead = 0;
        this._totalAmountRead = 0;
        HTTPDownloader.applyRate();
    }

    AlternateLocationCollection getAltLocsReceived() {
        return this._altLocsReceived;
    }

    AlternateLocationCollection getPushLocsReceived() {
        return this._pushAltLocsReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSuccessfulAltLoc(AlternateLocation loc) {
        if (loc instanceof DirectAltLoc) {
            Set set = this._badLocs;
            synchronized (set) {
                this._writtenBadLocs.remove(loc);
                this._badLocs.remove(loc);
            }
            set = this._goodLocs;
            synchronized (set) {
                if (!this._writtenGoodLocs.contains(loc)) {
                    this._goodLocs.add(loc);
                }
            }
        }
        Set set = this._badPushLocs;
        synchronized (set) {
            this._writtenBadPushLocs.remove(loc);
            this._badPushLocs.remove(loc);
        }
        set = this._goodPushLocs;
        synchronized (set) {
            if (!this._writtenPushLocs.contains(loc)) {
                this._goodPushLocs.add(loc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailedAltLoc(AlternateLocation loc) {
        if (loc instanceof DirectAltLoc) {
            Set set = this._goodLocs;
            synchronized (set) {
                this._writtenGoodLocs.remove(loc);
                this._goodLocs.remove(loc);
            }
            set = this._badLocs;
            synchronized (set) {
                if (!this._writtenBadLocs.contains(loc)) {
                    this._badLocs.add(loc);
                }
            }
        }
        Set set = this._goodPushLocs;
        synchronized (set) {
            this._writtenPushLocs.remove(loc);
            this._goodPushLocs.remove(loc);
        }
        set = this._badPushLocs;
        synchronized (set) {
            if (!this._writtenBadPushLocs.contains(loc)) {
                this._badPushLocs.add(loc);
            }
        }
    }

    public void connectTCP(int timeout) throws IOException {
        try {
            if (this._socket == null) {
                long curTime = System.currentTimeMillis();
                this._socket = Sockets.connect(this._host, this._port, timeout);
                NumericalDownloadStat.TCP_CONNECT_TIME.addData((int)(System.currentTimeMillis() - curTime));
            }
            Sockets.setKeepAlive(this._socket, true);
            this._input = this._socket.getInputStream();
            this._output = new BufferedOutputStream(this._socket.getOutputStream());
        }
        catch (IOException e) {
            throw new CantConnectException();
        }
        this._socket.setSoTimeout(8000);
        this._byteReader = new ByteReader(this._input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectHTTP(int start, int stop, boolean supportQueueing) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, RangeNotAvailableException, ProblemReadingHeaderException, UnknownCodeException {
        Object next;
        Iterator iter;
        URN sha1;
        AlternateLocation me;
        if (start < 0) {
            throw new IllegalArgumentException("invalid start: " + start);
        }
        if (stop <= start) {
            throw new IllegalArgumentException("stop(" + stop + ") <= start(" + start + ")");
        }
        this._amountToRead = stop - start;
        this._totalAmountRead += this._amountRead;
        this._amountRead = 0;
        this._initialReadingPoint = start;
        this._bodyConsumed = false;
        this._contentLength = 0;
        HashSet<HTTPHeaderValue> features = new HashSet<HTTPHeaderValue>();
        OutputStreamWriter osw = new OutputStreamWriter(this._output);
        BufferedWriter out = new BufferedWriter(osw);
        String startRange = String.valueOf(this._initialReadingPoint);
        out.write("GET " + this._rfd.getUrl().getFile() + " HTTP/1.1\r\n");
        out.write("HOST: " + this._host + ":" + this._port + "\r\n");
        out.write("User-Agent: " + CommonUtils.getHttpServer() + "\r\n");
        if (supportQueueing) {
            out.write("X-Queue: 0.1\r\n");
            features.add(ConstantHTTPHeaderValue.QUEUE_FEATURE);
        }
        features.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
        if (!RouterService.acceptedIncomingConnection() && UDPService.instance().canDoFWT()) {
            features.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
        }
        if (this.isPartialFileValid() && (RouterService.acceptedIncomingConnection() || this._wantsFalts) && (me = AlternateLocation.create(this._rfd.getSHA1Urn())) != null) {
            this.addSuccessfulAltLoc(me);
        }
        if ((sha1 = this._rfd.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)sha1, (Writer)out);
        }
        HashSet<Object> writeClone = null;
        Set set = this._goodLocs;
        synchronized (set) {
            if (this._goodLocs.size() > 0) {
                writeClone = new HashSet<Object>();
                iter = this._goodLocs.iterator();
                while (iter.hasNext()) {
                    next = iter.next();
                    writeClone.add(next);
                    this._writtenGoodLocs.add(next);
                }
                this._goodLocs.clear();
            }
        }
        if (writeClone != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(writeClone), (Writer)out);
        }
        writeClone = null;
        set = this._badLocs;
        synchronized (set) {
            if (this._badLocs.size() > 0) {
                writeClone = new HashSet();
                iter = this._badLocs.iterator();
                while (iter.hasNext()) {
                    next = iter.next();
                    writeClone.add(next);
                    this._writtenBadLocs.add(next);
                }
                this._badLocs.clear();
            }
        }
        if (writeClone != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.NALTS, (HTTPHeaderValue)new HTTPHeaderValueCollection(writeClone), (Writer)out);
        }
        if (this._wantsFalts) {
            writeClone = null;
            set = this._goodPushLocs;
            synchronized (set) {
                if (this._goodPushLocs.size() > 0) {
                    writeClone = new HashSet();
                    iter = this._goodPushLocs.iterator();
                    while (iter.hasNext()) {
                        next = (PushAltLoc)iter.next();
                        if (((PushAltLoc)next).getPushAddress().getProxies().isEmpty()) {
                            if (((PushAltLoc)next).getPushAddress() instanceof PushEndpointForSelf) continue;
                            Assert.that(false, "empty pushloc in downloader");
                        }
                        writeClone.add(next);
                        this._writtenPushLocs.add(next);
                    }
                    this._goodPushLocs.clear();
                }
            }
            if (writeClone != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.FALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(writeClone), (Writer)out);
            }
            writeClone = null;
            set = this._badPushLocs;
            synchronized (set) {
                if (this._badPushLocs.size() > 0) {
                    writeClone = new HashSet();
                    iter = this._badPushLocs.iterator();
                    while (iter.hasNext()) {
                        next = (PushAltLoc)iter.next();
                        Assert.that(!((PushAltLoc)next).getPushAddress().getProxies().isEmpty());
                        writeClone.add(next);
                        this._writtenBadPushLocs.add(next);
                    }
                    this._badPushLocs.clear();
                }
            }
            if (writeClone != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.BFALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(writeClone), (Writer)out);
            }
        }
        out.write("Range: bytes=" + startRange + "-" + (stop - 1) + "\r\n");
        this._requestedInterval = new Interval(this._initialReadingPoint, stop - 1);
        if (ChatSettings.CHAT_ENABLED.getValue() && RouterService.acceptedIncomingConnection() && !NetworkUtils.isPrivateAddress(RouterService.getAddress())) {
            int port = RouterService.getPort();
            String host = NetworkUtils.ip2string(RouterService.getAddress());
            out.write("X-Node: " + host + ":" + port + "\r\n");
            features.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
            if (ChatSettings.CHAT_ENABLED.getValue()) {
                out.write("Chat: " + host + ":" + port + "\r\n");
                features.add(ConstantHTTPHeaderValue.CHAT_FEATURE);
            }
        }
        if (features.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection(features), (Writer)out);
        }
        out.write("\r\n");
        out.flush();
        this.readHeaders();
    }

    public void consumeBodyIfNecessary() {
        LOG.trace((Object)"enter consumeBodyIfNecessary");
        try {
            if (!this._bodyConsumed) {
                this.consumeBody(this._contentLength);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._bodyConsumed = true;
    }

    public ConnectionStatus requestHashTree() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("requesting HashTree for " + this._thexUri + " from " + this._host + ":" + this._port));
        }
        try {
            String str = "GET " + this._thexUri + " HTTP/1.1\r\n";
            this._output.write(str.getBytes());
            str = "HOST: " + this._host + ":" + this._port + "\r\n";
            this._output.write(str.getBytes());
            str = "User-Agent: " + CommonUtils.getHttpServer() + "\r\n";
            this._output.write(str.getBytes());
            str = "\r\n";
            this._output.write(str.getBytes());
            this._output.flush();
        }
        catch (IOException ioe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"connection failed during sending hashtree request");
            }
            return ConnectionStatus.getConnected();
        }
        try {
            String line = this._byteReader.readLine();
            if (line == null) {
                throw new IOException("disconnected");
            }
            int code = HTTPDownloader.parseHTTPCode(line, this._rfd);
            if (code < 200 || code >= 300) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("invalid HTTP code: " + code));
                }
                this._rfd.setTHEXFailed();
                return this.consumeResponse(code);
            }
            int contentLength = this.consumeHeaders(null);
            InputStream in = this._input;
            if (contentLength != -1) {
                in = new CountingInputStream(this._input);
            }
            try {
                HashTree hashTree = HashTree.createHashTree(in, this._rfd.getSHA1Urn().toString(), this._root32, this._rfd.getSize());
                this._thexSucceeded = true;
                return ConnectionStatus.getThexResponse(hashTree);
            }
            catch (IOException ioe) {
                if (in instanceof CountingInputStream) {
                    LOG.debug((Object)"failed with contentLength", (Throwable)ioe);
                    this._rfd.setTHEXFailed();
                    int read = ((CountingInputStream)in).getAmountRead();
                    return this.consumeBody(contentLength - read);
                }
                throw ioe;
            }
        }
        catch (IOException ioe) {
            LOG.debug((Object)"failed without contentLength", (Throwable)ioe);
            this._rfd.setTHEXFailed();
            return ConnectionStatus.getConnected();
        }
    }

    private int consumeHeaders(int[] queueInfo) throws IOException {
        String str;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " consuming headers"));
        }
        int contentLength = -1;
        while ((str = this._byteReader.readLine()) != null && !str.equals("")) {
            if (HTTPHeaderName.CONTENT_LENGTH.matchesStartOfString(str)) {
                String value = HTTPUtils.extractHeaderValue(str);
                if (value == null) continue;
                try {
                    contentLength = Integer.parseInt(value.trim());
                }
                catch (NumberFormatException nfe) {
                    contentLength = -1;
                }
                continue;
            }
            if (queueInfo == null || !HTTPHeaderName.QUEUE.matchesStartOfString(str)) continue;
            this.parseQueueHeaders(str, queueInfo);
        }
        return contentLength;
    }

    private ConnectionStatus consumeResponse(int code) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " consuming response, code: " + code));
        }
        int[] queueInfo = new int[]{-1, -1, -1};
        int contentLength = this.consumeHeaders(queueInfo);
        if (code == 503) {
            int min = queueInfo[0];
            int max = queueInfo[1];
            int pos = queueInfo[2];
            if (min != -1 && max != -1 && pos != -1) {
                return ConnectionStatus.getQueued(pos, min);
            }
        }
        return this.consumeBody(contentLength);
    }

    private ConnectionStatus consumeBody(int contentLength) throws IOException {
        int toRead;
        int read;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("enter consumeBody(" + contentLength + ")"));
        }
        if (contentLength < 0) {
            throw new IOException("unknown content-length, can't consume");
        }
        byte[] buf = new byte[1024];
        while (contentLength > 0 && (read = this._input.read(buf, 0, toRead = Math.min(buf.length, contentLength))) != -1) {
            contentLength -= read;
        }
        return ConnectionStatus.getConnected();
    }

    private void readHeaders() throws IOException {
        if (this._byteReader == null) {
            throw new ReaderIsNullException();
        }
        String str = this._byteReader.readLine();
        if (str == null || str.equals("")) {
            throw new IOException();
        }
        BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(str.length());
        int code = HTTPDownloader.parseHTTPCode(str, this._rfd);
        int[] refQueueInfo = new int[]{-1, -1, -1};
        while ((str = this._byteReader.readLine()) != null && !str.equals("")) {
            BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(str.length());
            if (str.toUpperCase().startsWith("CONTENT-RANGE:")) {
                Interval responseRange = this.parseContentRange(str);
                int low = responseRange.low;
                int high = responseRange.high + 1;
                if (low < this._initialReadingPoint || high > this._initialReadingPoint + this._amountToRead) {
                    throw new ProblemReadingHeaderException("invalid subrange given.  wanted low: " + this._initialReadingPoint + ", high: " + (this._initialReadingPoint + this._amountToRead - 1) + "... given low: " + low + ", high: " + high);
                }
                this._initialReadingPoint = low;
                this._amountToRead = high - low;
                continue;
            }
            if (HTTPHeaderName.CONTENT_LENGTH.matchesStartOfString(str)) {
                this._contentLength = HTTPDownloader.readContentLength(str);
                continue;
            }
            if (HTTPHeaderName.CONTENT_URN.matchesStartOfString(str)) {
                this.checkContentUrnHeader(str, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.GNUTELLA_CONTENT_URN.matchesStartOfString(str)) {
                this.checkContentUrnHeader(str, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.ALT_LOCATION.matchesStartOfString(str)) {
                this.readAlternateLocations(str);
                continue;
            }
            if (HTTPHeaderName.QUEUE.matchesStartOfString(str)) {
                this.parseQueueHeaders(str, refQueueInfo);
                continue;
            }
            if (HTTPHeaderName.SERVER.matchesStartOfString(str)) {
                this._server = HTTPDownloader.readServer(str);
                continue;
            }
            if (HTTPHeaderName.AVAILABLE_RANGES.matchesStartOfString(str)) {
                this.parseAvailableRangesHeader(str, this._rfd);
                continue;
            }
            if (HTTPHeaderName.RETRY_AFTER.matchesStartOfString(str)) {
                HTTPDownloader.parseRetryAfterHeader(str, this._rfd);
                continue;
            }
            if (HTTPHeaderName.CREATION_TIME.matchesStartOfString(str)) {
                HTTPDownloader.parseCreationTimeHeader(str, this._rfd);
                continue;
            }
            if (HTTPHeaderName.FEATURES.matchesStartOfString(str)) {
                this.parseFeatureHeader(str);
                continue;
            }
            if (HTTPHeaderName.THEX_URI.matchesStartOfString(str)) {
                this.parseTHEXHeader(str);
                continue;
            }
            if (HTTPHeaderName.FALT_LOCATION.matchesStartOfString(str)) {
                this.parseFALTHeader(str);
                continue;
            }
            if (!HTTPHeaderName.PROXIES.matchesStartOfString(str)) continue;
            this.parseProxiesHeader(str);
        }
        if (code < 200 || code >= 300) {
            if (code == 404) {
                throw new FileNotFoundException();
            }
            if (code == 410) {
                throw new NotSharingException();
            }
            if (code == 416) {
                if (this._rfd.isPartialSource()) {
                    Iterator iter = this._rfd.getAvailableRanges().getAllIntervals();
                    while (iter.hasNext()) {
                        Interval next = (Interval)iter.next();
                        if (!this._requestedInterval.isSubrange(next)) continue;
                        throw new ProblemReadingHeaderException("Bad ranges sent");
                    }
                } else {
                    throw new ProblemReadingHeaderException("no ranges sent");
                }
                throw new RangeNotAvailableException();
            }
            if (code == 503) {
                int min = refQueueInfo[0];
                int max = refQueueInfo[1];
                int pos = refQueueInfo[2];
                if (min != -1 && max != -1 && pos != -1) {
                    throw new QueuedException(min, max, pos);
                }
                throw new TryAgainLaterException();
            }
            throw new UnknownCodeException(code);
        }
    }

    private void checkContentUrnHeader(String str, URN sha1) throws ContentUrnMismatchException {
        String value = HTTPUtils.extractHeaderValue(str);
        if (this._root32 == null && value.indexOf("urn:bitprint:") > -1) {
            this._root32 = value.substring(value.lastIndexOf(".") + 1).trim();
        }
        if (sha1 == null) {
            return;
        }
        URN contentUrn = null;
        try {
            contentUrn = URN.createSHA1Urn(value);
        }
        catch (IOException ioe) {
            return;
        }
        if (!sha1.equals(contentUrn)) {
            throw new ContentUrnMismatchException();
        }
    }

    private void readAlternateLocations(String altHeader) {
        String altStr = HTTPUtils.extractHeaderValue(altHeader);
        if (altStr == null) {
            return;
        }
        URN sha1 = this._rfd.getSHA1Urn();
        if (sha1 == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(altStr, ",");
        while (st.hasMoreTokens()) {
            try {
                boolean added;
                AlternateLocation al = AlternateLocation.create(st.nextToken().trim(), sha1);
                Assert.that(al.getSHA1Urn().equals(sha1));
                if (al.isMe()) continue;
                if (al instanceof DirectAltLoc) {
                    boolean added2;
                    DirectAltLoc dal = (DirectAltLoc)al;
                    if (!IPFilter.instance().allow(dal.getHost().getHostBytes())) continue;
                    if (this._altLocsReceived == null) {
                        this._altLocsReceived = AlternateLocationCollection.create(sha1);
                    }
                    if (!(added2 = this._altLocsReceived.add(al))) continue;
                    DownloadStat.ALTERNATE_COLLECTED.incrementStat();
                    continue;
                }
                if (this._pushAltLocsReceived == null) {
                    this._pushAltLocsReceived = AlternateLocationCollection.create(sha1);
                }
                if (!(added = this._pushAltLocsReceived.add(al))) continue;
                DownloadStat.PUSH_ALTERNATE_COLLECTED.incrementStat();
            }
            catch (IOException e) {}
        }
    }

    private boolean isPartialFileValid() {
        return this._rfd.getSHA1Urn() != null && UploadSettings.ALLOW_PARTIAL_SHARING.getValue() && !this._outIsCorrupted && RouterService.acceptedIncomingConnection() && this._incompleteFile.length() > (long)MIN_PARTIAL_FILE_BYTES && NetworkUtils.isValidPort(RouterService.getPort()) && NetworkUtils.isValidAddress(RouterService.getAddress()) && !NetworkUtils.isPrivateAddress(RouterService.getAddress());
    }

    public static String readServer(String serverHeader) {
        int colon = serverHeader.indexOf(58);
        if (colon != -1 && colon < serverHeader.length() - 1) {
            return serverHeader.substring(colon + 1).trim();
        }
        return "";
    }

    public static int readContentLength(String header) {
        String value = HTTPUtils.extractHeaderValue(header);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private static int parseHTTPCode(String str, RemoteFileDesc rfd) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String token = tokenizer.nextToken();
        if (token.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException("got: " + str);
        }
        rfd.setHTTP11(token.indexOf("1.1") > 0);
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        token = tokenizer.nextToken();
        String num = token.trim();
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(e);
        }
    }

    private void parseQueueHeaders(String str, int[] refQueueInfo) {
        if (str == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, " ,:=");
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        String token = tokenizer.nextToken();
        if (!token.equalsIgnoreCase("X-Queue")) {
            return;
        }
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            try {
                String value;
                if (token.equalsIgnoreCase("pollMin")) {
                    value = tokenizer.nextToken();
                    refQueueInfo[0] = Integer.parseInt(value);
                    continue;
                }
                if (token.equalsIgnoreCase("pollMax")) {
                    value = tokenizer.nextToken();
                    refQueueInfo[1] = Integer.parseInt(value);
                    continue;
                }
                if (!token.equalsIgnoreCase("position")) continue;
                value = tokenizer.nextToken();
                refQueueInfo[2] = Integer.parseInt(value);
            }
            catch (NumberFormatException nfx) {
                Arrays.fill(refQueueInfo, -1);
            }
            catch (NoSuchElementException nsex) {
                Arrays.fill(refQueueInfo, -1);
            }
        }
    }

    private Interval parseContentRange(String str) throws IOException {
        int numAfterSlash;
        int numBeforeSlash;
        int numBeforeDash;
        try {
            int start = str.indexOf("bytes") + 6;
            int slash = str.indexOf(47);
            if (str.substring(start, slash).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._rfd + " Content-Range like */?, " + str));
                }
                return new Interval(0, this._amountToRead - 1);
            }
            int dash = str.lastIndexOf("-");
            numBeforeDash = Integer.parseInt(str.substring(start, dash));
            numBeforeSlash = Integer.parseInt(str.substring(dash + 1, slash));
            if (numBeforeSlash < numBeforeDash) {
                throw new ProblemReadingHeaderException("invalid range, high (" + numBeforeSlash + ") less than low (" + numBeforeDash + ")");
            }
            if (str.substring(slash + 1).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._rfd + " Content-Range like #-#/*, " + str));
                }
                return new Interval(numBeforeDash, numBeforeSlash);
            }
            numAfterSlash = Integer.parseInt(str.substring(slash + 1));
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProblemReadingHeaderException(str);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(str);
        }
        if (numBeforeSlash == numAfterSlash) {
            --numBeforeDash;
            --numBeforeSlash;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " Content-Range like #-#/#, " + str));
        }
        return new Interval(numBeforeDash, numBeforeSlash);
    }

    private void parseAvailableRangesHeader(String line, RemoteFileDesc rfd) throws IOException {
        int stop;
        IntervalSet availableRanges = new IntervalSet();
        line = line.toLowerCase();
        int start = line.indexOf("bytes") + 6;
        while (start != -1 && start < line.length() && (stop = line.indexOf(45, start)) != -1) {
            Interval interval = null;
            try {
                int high;
                int low = Integer.parseInt(line.substring(start, stop).trim());
                start = stop + 1;
                stop = line.indexOf(44, start);
                if (stop == -1) {
                    stop = line.length();
                }
                if ((high = Integer.parseInt(line.substring(start, stop).trim())) >= rfd.getSize()) {
                    high = rfd.getSize() - 1;
                }
                if (low > high) continue;
                interval = new Interval(low, high);
                start = stop + 1;
            }
            catch (NumberFormatException e) {
                throw new ProblemReadingHeaderException(e);
            }
            availableRanges.add(interval);
        }
        rfd.setAvailableRanges(availableRanges);
    }

    private static void parseRetryAfterHeader(String str, RemoteFileDesc rfd) throws IOException {
        str = HTTPUtils.extractHeaderValue(str);
        int seconds = 0;
        try {
            seconds = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(e);
        }
        seconds = Math.max(seconds, 60);
        seconds = Math.min(seconds, 3600);
        rfd.setRetryAfter(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCreationTimeHeader(String str, RemoteFileDesc rfd) throws IOException {
        str = HTTPUtils.extractHeaderValue(str);
        long milliSeconds = 0L;
        try {
            milliSeconds = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(e);
        }
        if (rfd.getSHA1Urn() != null) {
            CreationTimeCache ctCache;
            CreationTimeCache creationTimeCache = ctCache = CreationTimeCache.instance();
            synchronized (creationTimeCache) {
                Long cTime = ctCache.getCreationTime(rfd.getSHA1Urn());
                if (cTime == null || cTime > milliSeconds) {
                    ctCache.addTime(rfd.getSHA1Urn(), milliSeconds);
                }
            }
        }
    }

    private void parseFeatureHeader(String str) {
        str = HTTPUtils.extractHeaderValue(str);
        StringTokenizer tok = new StringTokenizer(str, ",");
        while (tok.hasMoreTokens()) {
            String feature = tok.nextToken();
            String protocol = "";
            int slash = feature.indexOf("/");
            protocol = slash == -1 ? feature.toLowerCase().trim() : feature.substring(0, slash).toLowerCase().trim();
            if (protocol.equals("chat")) {
                this._chatEnabled = true;
                continue;
            }
            if (protocol.equals("browse")) {
                this._browseEnabled = true;
                continue;
            }
            if (protocol.equals("fwalt")) {
                this._wantsFalts = true;
                continue;
            }
            if (!protocol.equals("fwt")) continue;
            int FWTVersion = 0;
            try {
                FWTVersion = (int)HTTPUtils.parseFeatureToken(feature);
                this._wantsFalts = true;
            }
            catch (ProblemReadingHeaderException prhe) {
                continue;
            }
            PushEndpoint.setFWTVersionSupported(this._rfd.getClientGUID(), FWTVersion);
        }
    }

    private void parseTHEXHeader(String str) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._host + ":" + this._port + ">" + str));
        }
        if ((str = HTTPUtils.extractHeaderValue(str)).indexOf(";") > 0) {
            StringTokenizer tok = new StringTokenizer(str, ";");
            this._thexUri = tok.nextToken();
            this._root32 = tok.nextToken();
        } else {
            this._thexUri = str;
        }
    }

    private void parseFALTHeader(String str) {
        this._wantsFalts = true;
        this.readAlternateLocations(str);
    }

    private void parseProxiesHeader(String str) {
        str = HTTPUtils.extractHeaderValue(str);
        if (this._rfd.getPushAddr() == null || str == null || str.length() < 12) {
            return;
        }
        try {
            PushEndpoint.overwriteProxies(this._rfd.getClientGUID(), str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDownload(VerifyingFile commonOutFile) throws IOException {
        this._socket.setSoTimeout(600000);
        long currPos = this._initialReadingPoint;
        try {
            int atr;
            this._isActive = true;
            int c = -1;
            byte[] buf = new byte[1024];
            while (this._amountRead < (atr = this._amountToRead)) {
                int left = atr - this._amountRead;
                Assert.that(left > 0);
                BandwidthThrottle throttle = this._socket instanceof UDPConnection ? UDP_THROTTLE : THROTTLE;
                int toRead = throttle.request(Math.min(1024, left));
                c = this._byteReader.read(buf, 0, toRead);
                if (c == -1) break;
                BandwidthStat.HTTP_BODY_DOWNSTREAM_BANDWIDTH.addData(c);
                commonOutFile.writeBlock(currPos, c, buf);
                this._outIsCorrupted = commonOutFile.isCorrupted();
                currPos += (long)c;
                this._amountRead += c;
            }
            if (this._amountRead < this._amountToRead) {
                throw new FileIncompleteException();
            }
            Object var11_9 = null;
            this._bodyConsumed = true;
            this._isActive = false;
            if (!this.isHTTP11()) {
                this._byteReader.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this._bodyConsumed = true;
            this._isActive = false;
            if (!this.isHTTP11()) {
                this._byteReader.close();
            }
            throw throwable;
        }
    }

    public void stop() {
        if (this._byteReader != null) {
            this._byteReader.close();
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this._input != null) {
                this._input.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this._output != null) {
                this._output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stopAt(int stop) {
        this._amountToRead = stop - this._initialReadingPoint;
    }

    public int getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public int getAmountRead() {
        return this._amountRead;
    }

    public int getTotalAmountRead() {
        return this._totalAmountRead + this._amountRead;
    }

    public int getAmountToRead() {
        return this._amountToRead;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean browseEnabled() {
        return this._browseEnabled;
    }

    public boolean wantsFalts() {
        return this._wantsFalts;
    }

    public String getVendor() {
        return this._server;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isPush() {
        return this._isPush;
    }

    public boolean isHTTP11() {
        return this._rfd.isHTTP11();
    }

    public boolean hasHashTree() {
        return this._thexUri != null && this._root32 != null && !this._rfd.hasTHEXFailed() && !this._thexSucceeded;
    }

    public void measureBandwidth() {
        this.bandwidthTracker.measureBandwidth(this.getTotalAmountRead());
    }

    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public static void setRate(float bytesPerSecond) {
        THROTTLE.setRate(bytesPerSecond);
        UDP_THROTTLE.setRate(bytesPerSecond);
    }

    public static void applyRate() {
        float downloadRate = Float.MAX_VALUE;
        int downloadThrottle = DownloadSettings.DOWNLOAD_SPEED.getValue();
        if (downloadThrottle < 100) {
            downloadRate = (float)downloadThrottle / 100.0f * ((float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f) * 1024.0f;
        }
        HTTPDownloader.setRate(downloadRate);
    }

    public String toString() {
        return "<" + this._host + ":" + this._port + ", " + this.getFileName() + ">";
    }

    public static void setThrottleSwitching(boolean on) {
        THROTTLE.setSwitching(on);
    }

    private HTTPDownloader(String str) {
        ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes());
        this._byteReader = new ByteReader(stream);
        this._altLocsReceived = null;
        this._goodLocs = null;
        this._badLocs = null;
        this._writtenGoodLocs = null;
        this._writtenBadLocs = null;
        this._rfd = new RemoteFileDesc("127.0.0.1", 1, 0L, "a", 0, new byte[16], 0, false, 0, false, null, null, false, false, "", 0L, null, -1L, 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

