/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;

final class HeadRequester
implements Runnable {
    private final Set HOSTS;
    private final URN RESOURCE_NAME;
    private final AlternateLocationCollector COLLECTOR;
    private final AlternateLocationCollection TOTAL_ALTS;

    public HeadRequester(Set hosts, URN resourceName, AlternateLocationCollector collector, AlternateLocationCollection totalAlts) {
        this.HOSTS = hosts;
        this.RESOURCE_NAME = resourceName;
        this.COLLECTOR = collector;
        this.TOTAL_ALTS = totalAlts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Iterator iter = this.HOSTS.iterator();
            while (iter.hasNext()) {
                URN urn;
                RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
                if (QueryReply.isFirewalledQuality(rfd.getQuality()) || (urn = rfd.getSHA1Urn()) == null || !urn.equals(this.RESOURCE_NAME)) continue;
                URL url = rfd.getUrl();
                String connectTo = url.toExternalForm();
                HeadMethod head = new HeadMethod(connectTo);
                head.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
                head.addRequestHeader("Cache-Control", "no-cache");
                head.addRequestHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN.httpStringValue(), this.RESOURCE_NAME.httpStringValue());
                head.addRequestHeader(HTTPHeaderName.ALT_LOCATION.httpStringValue(), this.TOTAL_ALTS.httpStringValue());
                head.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
                head.setFollowRedirects(false);
                HttpClient client = HttpClientManager.getNewClient();
                try {
                    AlternateLocationCollection alc;
                    URN reportedUrn;
                    client.executeMethod((HttpMethod)head);
                    String contentUrn = HeadRequester.getHeader((HttpMethod)head, HTTPHeaderName.GNUTELLA_CONTENT_URN);
                    if (contentUrn == null || !(reportedUrn = URN.createSHA1Urn(contentUrn)).equals(this.RESOURCE_NAME)) continue;
                    String altLocs = HeadRequester.getHeader((HttpMethod)head, HTTPHeaderName.ALT_LOCATION);
                    if (altLocs == null || (alc = AlternateLocationCollection.createCollectionFromHttpValue(altLocs)) == null || !alc.getSHA1Urn().equals(this.COLLECTOR.getSHA1Urn())) continue;
                    this.COLLECTOR.addAll(alc);
                }
                catch (IOException e) {}
                continue;
                finally {
                    if (head == null) continue;
                    head.releaseConnection();
                }
            }
        }
        catch (Throwable e) {
            ErrorService.error(e);
        }
    }

    private static String getHeader(HttpMethod methid, HTTPHeaderName name) {
        Header header = methid.getResponseHeader(name.httpStringValue());
        if (header == null) {
            return null;
        }
        return header.getValue();
    }
}

