/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NameValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

public class PingRequest
extends Message {
    public static final byte SCP_LEAF = 0;
    public static final byte SCP_ULTRAPEER = 1;
    private byte[] payload = null;
    private GGEP[] _ggeps;

    public PingRequest(byte[] guid, byte ttl, byte hops) {
        super(guid, (byte)0, ttl, hops, 0);
    }

    protected PingRequest(byte[] guid, byte ttl, byte hops, byte length) {
        super(guid, (byte)0, ttl, hops, length);
    }

    public PingRequest(byte[] guid, byte ttl, byte hops, byte[] payload) {
        super(guid, (byte)0, ttl, hops, payload.length);
        this.payload = payload;
    }

    public PingRequest(byte ttl) {
        super((byte)0, ttl, 0);
        this.addBasicGGEPs();
    }

    public PingRequest(byte[] guid, byte ttl) {
        super(guid, (byte)0, ttl, (byte)0, 0);
        this.addBasicGGEPs();
    }

    private PingRequest(byte[] guid, byte ttl, List ggeps) {
        super(guid, (byte)0, ttl, (byte)0, 0);
        this.addGGEPs(ggeps);
    }

    public static PingRequest createQueryKeyRequest() {
        LinkedList<NameValue> l = new LinkedList<NameValue>();
        l.add(new NameValue("QK"));
        return new PingRequest(GUID.makeGuid(), 1, l);
    }

    public static PingRequest createUDPPing() {
        GUID guid;
        LinkedList<NameValue> l = new LinkedList<NameValue>();
        if (ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue()) {
            guid = new GUID();
        } else {
            l.add(new NameValue("IP"));
            guid = UDPService.instance().getSolicitedGUID();
        }
        byte[] data = new byte[]{RouterService.isSupernode() ? (byte)1 : 0};
        l.add(new NameValue("SCP", data));
        return new PingRequest(guid.bytes(), 1, l);
    }

    public static PingRequest createMulticastPing() {
        GUID guid = new GUID();
        byte[] data = new byte[]{RouterService.isSupernode() ? (byte)1 : 0};
        LinkedList<NameValue> l = new LinkedList<NameValue>();
        l.add(new NameValue("SCP", data));
        return new PingRequest(guid.bytes(), 1, l);
    }

    protected void writePayload(OutputStream out) throws IOException {
        if (this.payload != null) {
            out.write(this.payload);
        }
        SentMessageStatHandler.TCP_PING_REQUESTS.addMessage(this);
    }

    public Message stripExtendedPayload() {
        if (this.payload == null) {
            return this;
        }
        return new PingRequest(this.getGUID(), this.getTTL(), this.getHops());
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_PING_REQUESTS.addMessage(this);
    }

    public String toString() {
        return "PingRequest(" + super.toString() + ")";
    }

    public boolean isHeartbeat() {
        return this.getHops() == 1 && this.getTTL() == 0;
    }

    public void addIPRequest() {
        LinkedList<NameValue> l = new LinkedList<NameValue>();
        l.add(new NameValue("IP"));
        this.addGGEPs(l);
    }

    private void addBasicGGEPs() {
        LinkedList<NameValue> l = new LinkedList<NameValue>();
        l.add(new NameValue("LOC", ApplicationSettings.LANGUAGE.getValue()));
        this.addGGEPs(l);
    }

    private void addGGEPs(List ggeps) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this._ggeps == null) {
                this._ggeps = new GGEP[1];
            }
            if (this._ggeps[0] == null) {
                this._ggeps[0] = new GGEP(true);
            }
            this._ggeps[0].putAll(ggeps);
            this._ggeps[0].write(baos);
            baos.write(0);
            this.payload = baos.toByteArray();
            this.updateLength(this.payload.length);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
    }

    public String getLocale() {
        if (this.payload != null) {
            try {
                if (this._ggeps == null) {
                    this._ggeps = GGEP.read(this.payload, 0);
                }
                for (int i = 0; i < this._ggeps.length; ++i) {
                    if (!this._ggeps[i].hasKey("LOC")) continue;
                    return this._ggeps[i].getString("LOC");
                }
                return ApplicationSettings.DEFAULT_LOCALE.getValue();
            }
            catch (BadGGEPBlockException ignored) {
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
            return ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        return ApplicationSettings.DEFAULT_LOCALE.getValue();
    }

    public boolean supportsCachedPongs() {
        if (this.payload != null) {
            try {
                if (this._ggeps == null) {
                    this._ggeps = GGEP.read(this.payload, 0);
                }
                for (int i = 0; i < this._ggeps.length; ++i) {
                    if (!this._ggeps[i].hasKey("SCP")) continue;
                    return true;
                }
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    public byte[] getSupportsCachedPongData() {
        if (this.payload == null) {
            return null;
        }
        try {
            if (this._ggeps == null) {
                this._ggeps = GGEP.read(this.payload, 0);
            }
            for (int i = 0; i < this._ggeps.length; ++i) {
                if (!this._ggeps[i].hasKey("SCP")) continue;
                byte[] data = this._ggeps[i].getBytes("SCP");
                if (data == null) {
                    return DataUtils.EMPTY_BYTE_ARRAY;
                }
                return data;
            }
        }
        catch (BadGGEPBlockException ignored) {
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            // empty catch block
        }
        return null;
    }

    public boolean isQueryKeyRequest() {
        if (this.getTTL() != 0 || this.getHops() != 1) {
            return false;
        }
        if (this.payload == null) {
            return false;
        }
        try {
            if (this._ggeps == null) {
                this._ggeps = GGEP.read(this.payload, 0);
            }
            for (int i = 0; i < this._ggeps.length; ++i) {
                if (!this._ggeps[i].hasKey("QK")) continue;
                return true;
            }
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            // empty catch block
        }
        return false;
    }

    public boolean requestsIP() {
        if (this.payload == null) {
            return false;
        }
        try {
            if (this._ggeps == null) {
                this._ggeps = GGEP.read(this.payload, 0);
            }
            for (int i = 0; i < this._ggeps.length; ++i) {
                if (!this._ggeps[i].hasKey("IP")) continue;
                return true;
            }
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            // empty catch block
        }
        return false;
    }
}

