/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.ErrorService;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class SignatureVerifier {
    private byte[] plainText;
    private byte[] signature;
    private PublicKey publicKey;
    private String algorithm;

    public SignatureVerifier(byte[] pText, byte[] sigBytes, PublicKey key, String algorithm) {
        this.plainText = pText;
        this.signature = sigBytes;
        this.publicKey = key;
        this.algorithm = algorithm;
    }

    public boolean verifySignature() {
        try {
            Signature verifier = Signature.getInstance(this.algorithm);
            verifier.initVerify(this.publicKey);
            verifier.update(this.plainText, 0, this.plainText.length);
            return verifier.verify(this.signature);
        }
        catch (NoSuchAlgorithmException nsax) {
            ErrorService.error(nsax);
            return false;
        }
        catch (InvalidKeyException ikx) {
            return false;
        }
        catch (SignatureException sx) {
            return false;
        }
        catch (ClassCastException ccx) {
            return false;
        }
    }
}

