/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class User
implements Serializable {
    static final long serialVersionUID = -3608126644033971628L;
    private String _username;
    private String _password;
    private Set _domains;
    public static final String DEFAULT_UNAUTHENTICATED_DOMAIN = "__DEFAULT_UNAUTHENTICATED_DOMAIN__";

    public User(String username, String password) {
        this(username, password, User.createDefaultDomainSet());
    }

    public User(String username, String password, Set domains) {
        this._username = username;
        this._password = password;
        this._domains = domains;
    }

    public static Set createDefaultDomainSet() {
        HashSet<String> domainSet = new HashSet<String>();
        domainSet.add(DEFAULT_UNAUTHENTICATED_DOMAIN);
        return domainSet;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public void addDomain(String domain) {
        this._domains.add(domain);
    }

    public void removeDomain(String domain) {
        this._domains.remove(domain);
    }

    public Set getDomains() {
        return this._domains;
    }

    public String toString() {
        return "username=" + this._username + "&password=" + this._password + "&domains=" + this._domains;
    }
}

