/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.FileArraySetting;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;

public class SharingSettings
extends LimeProps {
    public static final File DEFAULT_SAVE_DIR = new File(CommonUtils.getUserHomeDir(), "Shared");
    public static final BooleanSetting ADD_ALTERNATE_FOR_SELF = FACTORY.createBooleanSetting("ADD_ALTERNATE_FOR_SELF", true);
    public static final FileSetting DIRECTORY_FOR_SAVING_FILES = (FileSetting)FACTORY.createFileSetting("DIRECTORY_FOR_SAVING_FILES", DEFAULT_SAVE_DIR).setAlwaysSave(true);
    public static final FileSetting INCOMPLETE_DIRECTORY = FACTORY.createFileSetting("INCOMPLETE_DIRECTORY", new File(DIRECTORY_FOR_SAVING_FILES.getValue().getParent(), "Incomplete"));
    public static final FileSetting DOWNLOAD_SNAPSHOT_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_FILE", new File(CommonUtils.getUserSettingsDir(), "downloads.cache"));
    public static final FileSetting DOWNLOAD_SNAPSHOT_BACKUP_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_BACKUP_FILE", new File(CommonUtils.getUserSettingsDir(), "downloads.cache.backup"));
    public static final IntSetting INCOMPLETE_PURGE_TIME = FACTORY.createIntSetting("INCOMPLETE_PURGE_TIME", 7);
    public static final BooleanSetting CLEAR_DOWNLOAD = FACTORY.createBooleanSetting("CLEAR_DOWNLOAD", false);
    private static final String DEFAULT_EXTENSIONS_TO_SHARE = "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;lwtp;pmf;m4a;idx;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;sxw";
    public static final FileArraySetting DIRECTORIES_TO_SHARE = FACTORY.createFileArraySetting("DIRECTORIES_TO_SEARCH_FOR_FILES", new File[0]);
    public static final StringSetting EXTENSIONS_TO_SHARE = FACTORY.createStringSetting("EXTENSIONS_TO_SEARCH_FOR", "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;lwtp;pmf;m4a;idx;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;sxw");
    public static final IntSetting FREELOADER_ALLOWED = FACTORY.createIntSetting("FREELOADER_ALLOWED", 100);
    public static final IntSetting FREELOADER_FILES = FACTORY.createIntSetting("FREELOADER_FILES", 1);
    public static final IntSetting PERSISTENT_HTTP_CONNECTION_TIMEOUT = FACTORY.createIntSetting("PERSISTENT_HTTP_CONNECTION_TIMEOUT", 15000);
    public static final BooleanSetting CLEAR_UPLOAD = FACTORY.createBooleanSetting("CLEAR_UPLOAD", true);
    public static final BooleanSetting ALLOW_BROWSER = FACTORY.createBooleanSetting("ALLOW_BROWSER", false);

    private SharingSettings() {
    }

    public static final void setSaveDirectory(File saveDir) throws IOException {
        if (saveDir == null) {
            throw new NullPointerException();
        }
        if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
            throw new IOException("could not create save dir");
        }
        String parentDir = saveDir.getParent();
        File incDir = new File(parentDir, "Incomplete");
        if (!incDir.isDirectory() && !incDir.mkdirs()) {
            throw new IOException("could not create incomplete dir");
        }
        FileUtils.setWriteable(saveDir);
        FileUtils.setWriteable(incDir);
        if (!(saveDir.canRead() && saveDir.canWrite() && incDir.canRead() && incDir.canWrite())) {
            throw new IOException("could not write to selected directory");
        }
        try {
            saveDir = FileUtils.getCanonicalFile(saveDir);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            incDir = FileUtils.getCanonicalFile(incDir);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        File snapFile = new File(incDir, "downloads.dat");
        try {
            snapFile = FileUtils.getCanonicalFile(snapFile);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        File snapBackup = new File(incDir, "downloads.bak");
        try {
            snapBackup = FileUtils.getCanonicalFile(snapBackup);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        DIRECTORY_FOR_SAVING_FILES.setValue(saveDir);
        INCOMPLETE_DIRECTORY.setValue(incDir);
    }

    public static final File getSaveDirectory() {
        return DIRECTORY_FOR_SAVING_FILES.getValue();
    }

    public static final void addDirectory(File dir) throws IOException {
        if (dir == null || !dir.isDirectory() || !dir.exists()) {
            throw new IOException();
        }
        File[] shared = DIRECTORIES_TO_SHARE.getValue();
        HashSet<File> set = new HashSet<File>();
        for (int i = 0; i < shared.length; ++i) {
            set.add(shared[i]);
        }
        set.add(dir);
        DIRECTORIES_TO_SHARE.setValue(set.toArray(new File[0]));
    }

    public static final void setDirectories(File[] files) throws IOException {
        HashSet<File> set = new HashSet<File>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || !files[i].isDirectory() || !files[i].exists()) {
                throw new IOException();
            }
            set.add(files[i]);
        }
        DIRECTORIES_TO_SHARE.setValue(set.toArray(new File[0]));
    }

    public static void setDirectoriesWithString(String dirs) {
        StringTokenizer st = new StringTokenizer(dirs, ";");
        int length = st.countTokens();
        Vector<File> v = new Vector<File>();
        for (int i = 0; i < length; ++i) {
            File f = new File(st.nextToken());
            if (!f.exists() || !f.isDirectory()) continue;
            v.add(f);
        }
        File[] array = new File[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            array[i] = (File)v.get(i);
        }
        try {
            SharingSettings.setDirectories(array);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

