/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.security.TigerTree;
import com.limegroup.gnutella.tigertree.HashTreeHandler;
import com.limegroup.gnutella.tigertree.HashTreeNodeManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HashTree
implements HTTPHeaderValue,
Serializable {
    private static final long serialVersionUID = -5752974896215224469L;
    private static final transient Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$tigertree$HashTree == null ? (class$com$limegroup$gnutella$tigertree$HashTree = HashTree.class$("com.limegroup.gnutella.tigertree.HashTree")) : class$com$limegroup$gnutella$tigertree$HashTree));
    private static final transient int KB = 1024;
    private static final transient int MB = 0x100000;
    static final transient int BLOCK_SIZE = 1024;
    private static final transient byte INTERNAL_HASH_PREFIX = 1;
    private final List NODES;
    private final byte[] ROOT_HASH;
    private final long FILE_SIZE;
    private final int DEPTH;
    private final String THEX_URI;
    private transient HashTreeHandler _treeWriter;
    static /* synthetic */ Class class$com$limegroup$gnutella$tigertree$HashTree;

    private HashTree(List allNodes, String sha1, long fileSize) {
        this.THEX_URI = "/uri-res/N2X?" + sha1;
        this.NODES = (List)allNodes.get(allNodes.size() - 1);
        this.FILE_SIZE = fileSize;
        this.ROOT_HASH = (byte[])((List)allNodes.get(0)).get(0);
        this.DEPTH = allNodes.size() - 1;
        Assert.that(HashTree.log2Ceil(this.NODES.size()) == this.DEPTH);
        HashTreeNodeManager.instance().register(this, allNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HashTree createHashTree(FileDesc fd) throws IOException {
        HashTree hashTree;
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("creating hashtree for file " + fd));
            }
            InputStream in = null;
            try {
                in = fd.createInputStream();
                hashTree = HashTree.createHashTree(fd.getSize(), in, fd.getSHA1Urn());
                Object var4_3 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    if (in == null) break block7;
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return hashTree;
    }

    private static HashTree createHashTree(long fileSize, InputStream is, URN sha1) throws IOException {
        int depth = HashTree.calculateDepth(fileSize);
        int maxNodes = 1 << depth;
        int idealNodeSize = (int)(fileSize + 1L) / maxNodes;
        int n = HashTree.log2Ceil(idealNodeSize);
        int nodeSize = 1 << n;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fileSize " + fileSize));
            LOG.debug((Object)("depth " + depth));
            LOG.debug((Object)("nodeSize " + nodeSize));
        }
        Assert.that((long)nodeSize >= fileSize / (long)maxNodes, "nodeSize: " + nodeSize + ", fileSize: " + fileSize + ", maxNode: " + maxNodes);
        Assert.that((long)nodeSize <= fileSize / (long)maxNodes * 2L, "nodeSize: " + nodeSize + ", fileSize: " + fileSize + ", maxNode: " + maxNodes);
        List nodes = HashTree.createTTNodes(nodeSize, fileSize, is);
        List allNodes = HashTree.createAllParentNodes(nodes);
        return new HashTree(allNodes, sha1.toString(), fileSize);
    }

    public static HashTree createHashTree(InputStream is, String sha1, String root32, long fileSize) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("reading " + sha1 + "." + root32 + " dime data."));
        }
        return new HashTree(HashTreeHandler.read(is, fileSize, root32), sha1, fileSize);
    }

    public List getCorruptRanges(InputStream is) throws IOException {
        LOG.trace((Object)"getting corrupt ranges ");
        ArrayList<Interval> ret = new ArrayList<Interval>();
        int n = HashTree.log2Ceil((int)this.FILE_SIZE) - this.DEPTH;
        int nodeSize = 1 << n;
        List fileHashes = HashTree.createTTNodes(nodeSize, this.FILE_SIZE, is);
        int minSize = Math.min(fileHashes.size(), this.NODES.size());
        block0: for (int i = 0; i < minSize; ++i) {
            byte[] aHash = (byte[])fileHashes.get(i);
            byte[] bHash = (byte[])this.NODES.get(i);
            for (int j = 0; j < aHash.length; ++j) {
                if (aHash[j] == bHash[j]) continue;
                Interval in = new Interval(i * nodeSize, (int)Math.min((long)((i + 1) * nodeSize - 1), this.FILE_SIZE - 1L));
                ret.add(in);
                if (!LOG.isDebugEnabled()) continue block0;
                LOG.debug((Object)(Base32.encode(this.ROOT_HASH) + " -> found corrupted range: " + in));
                continue block0;
            }
        }
        return ret;
    }

    public String httpStringValue() {
        return this.THEX_URI + ";" + Base32.encode(this.ROOT_HASH);
    }

    public boolean isGoodDepth() {
        return this.DEPTH == HashTree.calculateDepth(this.FILE_SIZE);
    }

    public boolean isDepthGoodEnough() {
        return this.DEPTH >= HashTree.calculateDepth(this.FILE_SIZE);
    }

    public boolean isBetterTree(HashTree other) {
        int diff2;
        if (other == null) {
            return true;
        }
        if (other.isGoodDepth()) {
            return false;
        }
        if (this.isGoodDepth()) {
            return true;
        }
        int ideal = HashTree.calculateDepth(this.FILE_SIZE);
        int diff1 = Math.abs(this.DEPTH - ideal);
        return diff1 < (diff2 = Math.abs(other.DEPTH - ideal));
    }

    public long getFileSize() {
        return this.FILE_SIZE;
    }

    public String getRootHash() {
        return Base32.encode(this.ROOT_HASH);
    }

    public String getThexURI() {
        return this.THEX_URI;
    }

    public int getDepth() {
        return this.DEPTH;
    }

    public List getNodes() {
        return this.NODES;
    }

    public int getNodeCount() {
        double last = this.NODES.size();
        int count = (int)last;
        for (int i = this.DEPTH - 1; i >= 0; --i) {
            last = Math.ceil(last / 2.0);
            count += (int)last;
        }
        return count;
    }

    public List getAllNodes() {
        return HashTreeNodeManager.instance().getAllNodes(this);
    }

    public void write(OutputStream out) throws IOException {
        this.getTreeWriter().write(out);
    }

    public int getOutputLength() {
        return this.getTreeWriter().getLength();
    }

    public String getOutputType() {
        return this.getTreeWriter().getType();
    }

    public static int calculateDepth(long size) {
        if (size < 262144L) {
            return 0;
        }
        if (size < 524288L) {
            return 1;
        }
        if (size < 0x100000L) {
            return 2;
        }
        if (size < 0x200000L) {
            return 3;
        }
        if (size < 0x500000L) {
            return 4;
        }
        if (size < 0xA00000L) {
            return 5;
        }
        if (size < 0x1400000L) {
            return 6;
        }
        if (size < 0x3200000L) {
            return 7;
        }
        if (size < 0x6400000L) {
            return 8;
        }
        return 9;
    }

    private HashTreeHandler getTreeWriter() {
        if (this._treeWriter == null) {
            this._treeWriter = new HashTreeHandler(this);
        }
        return this._treeWriter;
    }

    static List createAllParentNodes(List nodes) {
        ArrayList<List> allNodes = new ArrayList<List>();
        allNodes.add(Collections.unmodifiableList(nodes));
        while (nodes.size() > 1) {
            nodes = HashTree.createParentGeneration(nodes);
            allNodes.add(0, nodes);
        }
        return allNodes;
    }

    static List createParentGeneration(List nodes) {
        Tiger md = new Tiger();
        int size = nodes.size();
        size = size % 2 == 0 ? size / 2 : (size + 1) / 2;
        ArrayList<byte[]> ret = new ArrayList<byte[]>(size);
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            byte[] left = (byte[])iter.next();
            if (iter.hasNext()) {
                byte[] right = (byte[])iter.next();
                md.reset();
                md.update((byte)1);
                md.update(left, 0, left.length);
                md.update(right, 0, right.length);
                byte[] result = md.digest();
                ret.add(result);
                continue;
            }
            ret.add(left);
        }
        return ret;
    }

    private static List createTTNodes(int nodeSize, long fileSize, InputStream is) throws IOException {
        ArrayList<byte[]> ret = new ArrayList<byte[]>((int)Math.ceil((double)fileSize / (double)nodeSize));
        TigerTree tt = new TigerTree();
        byte[] block = new byte[131072];
        long offset = 0L;
        int read = 0;
        while (offset < fileSize) {
            int nodeOffset = 0;
            long time = System.currentTimeMillis();
            tt.reset();
            while (nodeOffset < nodeSize && (read = is.read(block)) != -1) {
                tt.update(block, 0, read);
                nodeOffset += read;
                offset += (long)read;
                try {
                    long sleep = (System.currentTimeMillis() - time) * 2L;
                    if (sleep > 0L) {
                        Thread.sleep(sleep);
                    }
                }
                catch (InterruptedException ie) {
                    throw new IOException("interrupted during hashing operation");
                }
                time = System.currentTimeMillis();
            }
            ret.add(tt.digest());
            if (offset == fileSize) {
                if (read == -1 || is.read() == -1) continue;
                LOG.warn((Object)"More data than fileSize!");
                throw new IOException("unknown file size.");
            }
            if (read != -1 || offset == fileSize) continue;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("couldn't hash whole file. read: " + read + ", offset: " + offset + ", fileSize: " + fileSize));
            }
            throw new IOException("couldn't hash whole file.");
        }
        return ret;
    }

    private static int log2Ceil(int number) {
        int n = 0;
        while (number > 1) {
            ++number;
            number >>>= 1;
            ++n;
        }
        return n;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

